/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.ComposingWatch;
import com.saxonica.stream.watch.StringValueAccumulator;
import com.saxonica.stream.watch.Watch;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedValueWatch
extends ComposingWatch
implements Watch {
    Stack<PendingItem> valuesUnderConstructionStack = new Stack();
    List<Value> valuesReadyToBeOutput = new ArrayList<Value>(5);

    public TypedValueWatch(Feed result, Stack<XPathContext> contextStack) {
        super(result, contextStack);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        FastStringBuffer nodeValueBuffer = new FastStringBuffer(100);
        PendingItem item = new PendingItem(this.valuesReadyToBeOutput.size(), node, nodeValueBuffer);
        this.valuesUnderConstructionStack.push(item);
        this.valuesReadyToBeOutput.add(StringValue.EMPTY_STRING);
        return new StringValueAccumulator(nodeValueBuffer);
    }

    @Override
    public void endSelectedParentNode(int locationId) throws XPathException {
        PendingItem item = this.valuesUnderConstructionStack.pop();
        int seq = item.sequence;
        FleetingNode element = item.node;
        element.setStringValue(item.buffer);
        Value typedValue = (Value)SequenceExtent.makeSequenceExtent(element.getTypedValue());
        this.valuesReadyToBeOutput.set(seq, typedValue);
        if (this.valuesUnderConstructionStack.isEmpty()) {
            for (int i = 0; i < this.valuesReadyToBeOutput.size(); ++i) {
                AtomicValue av;
                Value val = this.valuesReadyToBeOutput.get(i);
                SequenceIterator iter = val.iterate();
                while ((av = (AtomicValue)iter.next()) != null) {
                    this.getResult().append(av);
                }
            }
            this.valuesReadyToBeOutput.clear();
        }
    }

    @Override
    public void notifySelectedLeafNode(FleetingNode node, int locationId) throws XPathException {
        if (this.valuesUnderConstructionStack.isEmpty()) {
            AtomicValue item;
            SequenceIterator iter = node.getTypedValue();
            while ((item = (AtomicValue)iter.next()) != null) {
                this.getResult().append(item);
            }
        } else {
            this.valuesReadyToBeOutput.add((Value)SequenceExtent.makeSequenceExtent(node.getTypedValue()));
        }
    }

    private static class PendingItem {
        public int sequence;
        public FleetingNode node;
        public FastStringBuffer buffer;

        public PendingItem(int sequence, FleetingNode element, FastStringBuffer buffer) {
            this.sequence = sequence;
            this.node = element;
            this.buffer = buffer;
        }
    }
}

