/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.ComposingWatch;
import com.saxonica.stream.watch.StringValueAccumulator;
import com.saxonica.stream.watch.Watch;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringValueWatch
extends ComposingWatch
implements Watch {
    Stack<PendingItem> nodesUnderConstructionStack = new Stack();
    List<String> nodesReadyToBeOutput = new ArrayList<String>(5);

    public StringValueWatch(Feed result, Stack<XPathContext> contextStack) {
        super(result, contextStack);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        FastStringBuffer nodeValueBuffer = new FastStringBuffer(100);
        PendingItem item = new PendingItem(this.nodesReadyToBeOutput.size(), nodeValueBuffer);
        this.nodesUnderConstructionStack.push(item);
        this.nodesReadyToBeOutput.add("");
        return new StringValueAccumulator(nodeValueBuffer);
    }

    @Override
    public void endSelectedParentNode(int locationId) throws XPathException {
        PendingItem item = this.nodesUnderConstructionStack.pop();
        int seq = item.sequence;
        this.nodesReadyToBeOutput.set(seq, item.buffer.toString());
        if (this.nodesUnderConstructionStack.isEmpty()) {
            for (int i = 0; i < this.nodesReadyToBeOutput.size(); ++i) {
                this.getResult().append(new StringValue(this.nodesReadyToBeOutput.get(i)));
            }
            this.nodesReadyToBeOutput.clear();
        }
    }

    @Override
    public void notifySelectedLeafNode(FleetingNode node, int locationId) throws XPathException {
        String s = node.getStringValue();
        if (this.nodesUnderConstructionStack.isEmpty()) {
            this.getResult().append(new StringValue(s));
        } else {
            this.nodesReadyToBeOutput.add(s);
        }
    }

    private static class PendingItem {
        public int sequence;
        public FastStringBuffer buffer;

        public PendingItem(int sequence, FastStringBuffer buffer) {
            this.sequence = sequence;
            this.buffer = buffer;
        }
    }
}

