/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.expr.BreakInstr;
import com.saxonica.expr.IterateInstr;
import com.saxonica.stream.InvertedExpression;
import com.saxonica.stream.ManualIterator;
import com.saxonica.stream.om.FleetingDocumentNode;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.EventPushingWatch;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterateWatch
extends EventPushingWatch {
    private XPathContext localContext;
    private WatchManager watchManager;
    private Stack<Activation> activationStack = new Stack();
    boolean broken = false;
    private List<ValueRepresentation> valuesAwaitingOutput = new ArrayList<ValueRepresentation>(5);
    private InvertedExpression body;

    public IterateWatch(Expression expression, SequenceReceiver result, Stack<XPathContext> contextStack) {
        super(expression, result, contextStack);
    }

    protected XPathContext getLocalContext() {
        return this.localContext;
    }

    public void setBody(InvertedExpression body) {
        this.body = body;
    }

    public void setWatchManager(WatchManager watchManager) {
        this.watchManager = watchManager;
    }

    @Override
    public void open() throws XPathException {
        super.open();
        XPathContext outerContext = this.getContext();
        ((IterateInstr)this.getExpression()).getInitialExpression().process(outerContext);
        this.localContext = outerContext.newContext();
        ManualIterator iter = new ManualIterator();
        this.localContext.setCurrentIterator(iter);
        this.getContextStack().push(this.localContext);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        XPathContext context;
        if (this.broken) {
            return null;
        }
        ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        if (this.activationStack.isEmpty()) {
            context = this.localContext;
        } else {
            context = this.localContext.newMinorContext();
            SequenceOutputter out = new SequenceOutputter();
            out.setPipelineConfiguration(this.getPipelineConfiguration());
            context.setReceiver(out);
            this.valuesAwaitingOutput.add(StringValue.EMPTY_STRING);
        }
        Activation activation = new Activation(this.valuesAwaitingOutput.size() - 1);
        activation.contextStack = new Stack();
        activation.contextStack.push(context);
        activation.stateStack = new Stack();
        activation.isDocumentNode = node instanceof FleetingDocumentNode;
        this.activationStack.push(activation);
        Watch watch = this.body.getStreamingRoute().getWatch(this.watchManager, null, activation.contextStack);
        this.watchManager.addWatch(watch);
        return null;
    }

    @Override
    public void notifySelectedLeafNode(FleetingNode node, int locationId) throws XPathException {
        if (this.broken) {
            return;
        }
        ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        Activation activation = this.activationStack.peek();
    }

    @Override
    public void endSelectedParentNode(int locationId) throws XPathException {
        if (this.broken) {
            return;
        }
        Activation activation = this.activationStack.pop();
        XPathContextMajor context = (XPathContextMajor)activation.contextStack.pop();
        if (this.activationStack.isEmpty()) {
            for (int i = 0; i < this.valuesAwaitingOutput.size(); ++i) {
                Item item;
                SequenceIterator iter = Value.asIterator(this.valuesAwaitingOutput.get(i));
                while ((item = iter.next()) != null) {
                    this.getResult().append(item);
                }
            }
            this.valuesAwaitingOutput.clear();
        } else {
            SequenceOutputter temp = (SequenceOutputter)context.getReceiver();
            int seq = activation.sequence;
            ValueRepresentation root = SequenceExtent.makeSequenceExtent(temp.getList());
            temp.close();
            this.valuesAwaitingOutput.set(seq, root);
        }
        UserFunction fn = context.getTailCallFunction();
        if (fn != null && fn.getFunctionName().equals(BreakInstr.SAXON_BREAK)) {
            this.broken = true;
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.broken) {
            ((IterateInstr)this.getExpression()).getOnCompletionExpression().process(this.getContextStack().peek());
        }
        this.getContextStack().pop();
        super.close();
    }

    private static class Activation {
        public int sequence;
        public boolean isDocumentNode;
        public Stack<XPathContext> contextStack;
        public Stack<Object> stateStack;

        public Activation(int sequence) {
            this.sequence = sequence;
        }
    }
}

