/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.InvertedExpression;
import com.saxonica.stream.ManualIterator;
import com.saxonica.stream.om.FleetingDocumentNode;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.EventPushingWatch;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachWatch
extends EventPushingWatch {
    private XPathContext localContext;
    private WatchManager watchManager;
    private Stack<Activation> activationStack = new Stack();
    private List<ValueRepresentation> valuesAwaitingOutput = new ArrayList<ValueRepresentation>(5);
    private InvertedExpression body;

    public ForEachWatch(Expression expression, SequenceReceiver result, Stack<XPathContext> contextStack) {
        super(expression, result, contextStack);
    }

    protected XPathContext getLocalContext() {
        return this.localContext;
    }

    public void setBody(InvertedExpression body) {
        this.body = body;
    }

    public void setWatchManager(WatchManager watchManager) {
        this.watchManager = watchManager;
    }

    @Override
    public void open() throws XPathException {
        super.open();
        this.localContext = this.getContext().newContext();
        ManualIterator iter = new ManualIterator();
        this.localContext.setCurrentIterator(iter);
        this.getContextStack().push(this.localContext);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        Activation activation = this.startSelectedNode(node);
        Watch watch = this.body.getStreamingRoute().getWatch(this.watchManager, null, activation.contextStack);
        this.watchManager.addWatch(watch);
        return null;
    }

    private Activation startSelectedNode(FleetingNode node) {
        XPathContext context;
        ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        if (this.activationStack.isEmpty()) {
            context = this.localContext;
        } else {
            context = this.localContext.newMinorContext();
            SequenceOutputter out = new SequenceOutputter();
            out.setPipelineConfiguration(this.getPipelineConfiguration());
            context.setReceiver(out);
            this.valuesAwaitingOutput.add(StringValue.EMPTY_STRING);
        }
        Activation activation = new Activation(this.valuesAwaitingOutput.size() - 1);
        activation.contextStack = new Stack();
        activation.contextStack.push(context);
        activation.stateStack = new Stack();
        activation.isDocumentNode = node instanceof FleetingDocumentNode;
        this.activationStack.push(activation);
        return activation;
    }

    @Override
    public void notifySelectedLeafNode(FleetingNode node, int locationId) throws XPathException {
        this.startSelectedNode(node);
        Watch watch = this.body.getStreamingRoute().getWatch(this.watchManager, null, this.activationStack.peek().contextStack);
        watch.open();
        watch.notifySelectedLeafNode(node, locationId);
        watch.close();
        this.endSelectedParentNode(locationId);
    }

    @Override
    public void endSelectedParentNode(int locationId) throws XPathException {
        Activation activation = this.activationStack.pop();
        XPathContext context = activation.contextStack.pop();
        if (this.activationStack.isEmpty()) {
            for (int i = 0; i < this.valuesAwaitingOutput.size(); ++i) {
                Item item;
                SequenceIterator iter = Value.asIterator(this.valuesAwaitingOutput.get(i));
                while ((item = iter.next()) != null) {
                    this.getResult().append(item);
                }
            }
            this.valuesAwaitingOutput.clear();
        } else {
            SequenceOutputter temp = (SequenceOutputter)context.getReceiver();
            int seq = activation.sequence;
            ValueRepresentation root = SequenceExtent.makeSequenceExtent(temp.getList());
            temp.close();
            this.valuesAwaitingOutput.set(seq, root);
        }
    }

    @Override
    public void close() throws XPathException {
        this.getContextStack().pop();
        super.close();
    }

    private static class Activation {
        public int sequence;
        public boolean isDocumentNode;
        public Stack<XPathContext> contextStack;
        public Stack<Object> stateStack;

        public Activation(int sequence) {
            this.sequence = sequence;
        }
    }
}

