/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.feed.Feed;
import com.saxonica.validate.AbstractWatch;
import java.util.Stack;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventPushingWatch
extends AbstractWatch {
    private SequenceReceiver result;
    private Stack<XPathContext> contextStack;
    private Expression expression;
    private Feed parentExpressionFeed;

    public EventPushingWatch(Expression expression, SequenceReceiver result, Stack<XPathContext> contextStack) {
        this.expression = expression;
        this.result = result;
        this.contextStack = contextStack;
        this.setPipelineConfiguration(result.getPipelineConfiguration());
    }

    public void setResult(SequenceReceiver result) {
        this.result = result;
    }

    public SequenceReceiver getResult() {
        return this.result;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public XPathContext getContext() {
        return this.contextStack.peek();
    }

    public Stack<XPathContext> getContextStack() {
        return this.contextStack;
    }

    public void setParentExpressionFeed(Feed feed) {
        this.parentExpressionFeed = feed;
        if (this.getPipelineConfiguration() == null && feed != null) {
            this.setPipelineConfiguration(feed.getPipelineConfiguration());
        }
    }

    @Override
    public void open() throws XPathException {
        if (this.parentExpressionFeed != null) {
            this.parentExpressionFeed.open();
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.parentExpressionFeed != null) {
            this.parentExpressionFeed.close();
        }
    }
}

