/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.ManualIterator;
import com.saxonica.stream.TemplateInversion;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.om.FleetingDocumentNode;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.EventPushingWatch;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyTemplatesWatch
extends EventPushingWatch {
    private Mode mode;
    private XPathContextMajor localContext;
    private WatchManager watchManager;
    private Stack<Activation> activationStack = new Stack();
    private List<ValueRepresentation> valuesAwaitingOutput = new ArrayList<ValueRepresentation>(5);
    private ParameterSet actualParams = null;
    private ParameterSet tunnelParams = null;
    private static LocationPathPattern CHILD_NODE_SELECTION = new LocationPathPattern();

    public ApplyTemplatesWatch(Expression expression, SequenceReceiver result, Stack<XPathContext> contextStack) {
        super(expression, result, contextStack);
    }

    @Override
    public void open() throws XPathException {
        super.open();
        ITemplateCall exp = (ITemplateCall)((Object)this.getExpression());
        if (exp != null) {
            this.computeActualParams(exp.getActualParams());
            this.computeTunnelParams(exp.getTunnelParams());
        }
        this.localContext = this.getContext().newContext();
        ManualIterator iter = new ManualIterator();
        this.localContext.setCurrentIterator(iter);
        this.getContextStack().push(this.localContext);
    }

    public void computeActualParams(WithParam[] params) throws XPathException {
        this.actualParams = Instruction.assembleParams(this.getContext(), params);
    }

    public void computeTunnelParams(WithParam[] params) throws XPathException {
        this.tunnelParams = Instruction.assembleTunnelParams(this.getContext(), params);
    }

    public void setActualParams(ParameterSet params) throws XPathException {
        this.actualParams = params;
    }

    public void setTunnelParams(ParameterSet params) throws XPathException {
        this.tunnelParams = params;
    }

    protected XPathContext getLocalContext() {
        return this.localContext;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setWatchManager(WatchManager watchManager) {
        this.watchManager = watchManager;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        XPathContextMinor context;
        ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        Rule rule = this.getRule(node);
        TemplateInversion t = rule == null ? this.getBuiltInTemplateForParentNode() : (TemplateInversion)rule.getAction();
        this.localContext.openStackFrame(t.getStackFrame());
        this.localContext.setLocalParameters(this.actualParams);
        this.localContext.setTunnelParameters(this.tunnelParams);
        this.localContext.setCurrentTemplateRule(rule);
        if (this.activationStack.isEmpty()) {
            context = this.localContext;
        } else {
            context = this.localContext.newMinorContext();
            SequenceOutputter out = new SequenceOutputter();
            out.setPipelineConfiguration(this.getPipelineConfiguration());
            context.setReceiver(out);
            this.valuesAwaitingOutput.add(StringValue.EMPTY_STRING);
        }
        Activation activation = new Activation(this.valuesAwaitingOutput.size() - 1);
        activation.template = t;
        activation.contextStack = new Stack();
        activation.contextStack.push(context);
        activation.stateStack = new Stack();
        activation.isDocumentNode = node instanceof FleetingDocumentNode;
        this.activationStack.push(activation);
        Watch watch = t.getWatch(this.watchManager, activation.contextStack);
        this.watchManager.addWatch(watch);
        return null;
    }

    protected Rule getRule(FleetingNode node) throws XPathException {
        return this.mode.getRule(node, this.getContext());
    }

    @Override
    public void notifySelectedLeafNode(FleetingNode node, int locationId) throws XPathException {
        Rule rule = this.mode.getRule(node, this.getContext());
        this.localContext.setCurrentTemplateRule(rule);
        ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        if (rule == null) {
            int kind = node.getNodeKind();
            if (kind == 2 || kind == 3) {
                if (this.activationStack.isEmpty()) {
                    this.localContext.getReceiver().append(node);
                } else {
                    Activation act = this.activationStack.peek();
                    act.contextStack.peek().getReceiver().characters(node.getStringValueCS(), locationId, 0);
                }
            }
        } else {
            RuleTarget target = rule.getAction();
            Template template = target instanceof Template ? (Template)target : ((TemplateInversion)target).getOriginalTemplate();
            this.localContext.openStackFrame(template.getStackFrameMap());
            template.apply(this.localContext);
        }
    }

    private TemplateInversion getBuiltInTemplateForParentNode() {
        WatchMaker defaultApplyTemplates = new WatchMaker(){

            @Override
            public EventPushingWatch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                XPathContext context = contextStack.peek();
                SequenceReceiver receiver = context.getReceiver();
                Mode mode = context.getCurrentMode();
                if (mode == null) {
                    mode = context.getController().getRuleManager().getUnnamedMode();
                }
                ApplyTemplatesWatch watch = new ApplyTemplatesWatch(null, receiver, contextStack);
                watch.setSelection(CHILD_NODE_SELECTION);
                watch.setMode(mode);
                watch.setWatchManager(watchManager);
                watch.setActualParams(ApplyTemplatesWatch.this.actualParams);
                watch.setTunnelParams(ApplyTemplatesWatch.this.tunnelParams);
                return watch;
            }
        };
        return TemplateInversion.makeBuiltInTemplate(defaultApplyTemplates);
    }

    @Override
    public void endSelectedParentNode(int locationId) throws XPathException {
        Activation activation = this.activationStack.pop();
        XPathContext context = activation.contextStack.pop();
        if (this.activationStack.isEmpty()) {
            for (int i = 0; i < this.valuesAwaitingOutput.size(); ++i) {
                Item item;
                SequenceIterator iter = Value.asIterator(this.valuesAwaitingOutput.get(i));
                while ((item = iter.next()) != null) {
                    this.getResult().append(item);
                }
            }
            this.valuesAwaitingOutput.clear();
        } else {
            SequenceOutputter temp = (SequenceOutputter)context.getReceiver();
            int seq = activation.sequence;
            ValueRepresentation root = SequenceExtent.makeSequenceExtent(temp.getList());
            temp.close();
            this.valuesAwaitingOutput.set(seq, root);
        }
    }

    @Override
    public void close() throws XPathException {
        this.getContextStack().pop();
        super.close();
    }

    static {
        CHILD_NODE_SELECTION.setNodeTest(AnyChildNodeTest.getInstance());
        CHILD_NODE_SELECTION.setUpperPattern((byte)9, new AnchorPattern());
    }

    private static class Activation {
        public int sequence;
        public boolean isDocumentNode;
        public TemplateInversion template;
        public Stack<XPathContext> contextStack;
        public Stack<Object> stateStack;

        public Activation(int sequence) {
            this.sequence = sequence;
        }
    }
}

