/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Sum;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumFeed
extends ItemFeed {
    private AtomicValue runningTotal = null;

    public SumFeed(Expression sumExpr, Feed result, Stack<XPathContext> contextStack) {
        super(sumExpr, result, contextStack);
    }

    @Override
    public void append(Item item) throws XPathException {
        XPathContext context = this.getContext();
        ConversionRules rules = context.getConfiguration().getConversionRules();
        AtomicValue next = (AtomicValue)item;
        if (this.runningTotal == null) {
            if (next instanceof UntypedAtomicValue) {
                next = next.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
            }
            this.runningTotal = next;
        } else if (this.runningTotal instanceof NumericValue) {
            if (next instanceof UntypedAtomicValue) {
                next = next.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
            } else if (!(next instanceof NumericValue)) {
                XPathException err = new XPathException("Input to sum() contains a mix of numeric and non-numeric values");
                err.setXPathContext(context);
                err.setErrorCode("FORG0006");
                throw err;
            }
            this.runningTotal = ArithmeticExpression.compute(this.runningTotal, 0, next, context);
        } else if (this.runningTotal instanceof DurationValue) {
            if (!(next instanceof DurationValue)) {
                XPathException err = new XPathException("Input to sum() contains a mix of duration and non-duration values");
                err.setXPathContext(context);
                err.setErrorCode("FORG0006");
                throw err;
            }
            this.runningTotal = ((DurationValue)this.runningTotal).add((DurationValue)next);
        } else {
            XPathException err = new XPathException("Input to sum() contains a value of type " + next.getPrimitiveType().getDisplayName() + " which is neither numeric, nor a duration");
            err.setXPathContext(context);
            err.setErrorCode("FORG0006");
            throw err;
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.runningTotal == null) {
            Sum sumExpr = (Sum)this.getExpression();
            if (sumExpr.getNumberOfArguments() == 1) {
                this.runningTotal = DoubleValue.ZERO;
            } else {
                Expression zeroExpr = sumExpr.getArguments()[1];
                this.runningTotal = (AtomicValue)zeroExpr.evaluateItem(this.getContext());
            }
        }
        Feed result = this.getResult();
        result.append(this.runningTotal);
        result.close();
    }
}

