/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.ManualIterator;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterExpressionFeed
extends ItemFeed {
    Expression filter;
    XPathContext localContext;
    ManualIterator manual;
    boolean isPositional;

    public FilterExpressionFeed(Expression expr, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
        this.filter = ((FilterExpression)expr).getControlledExpression();
        this.localContext = contextStack.peek().newMinorContext();
        this.manual = new ManualIterator();
        this.localContext.setCurrentIterator(this.manual);
        this.isPositional = ((FilterExpression)expr).isPositional(this.localContext.getConfiguration().getTypeHierarchy());
    }

    @Override
    public void append(Item item) throws XPathException {
        boolean matches;
        this.manual.setContextItem(item);
        if (this.isPositional) {
            this.manual.incrementPosition();
            SequenceIterator pred = this.filter.iterate(this.localContext);
            matches = ExpressionTool.effectiveBooleanValue(pred);
        } else {
            matches = this.filter.effectiveBooleanValue(this.localContext);
        }
        if (matches) {
            this.getResult().append(item);
        }
    }
}

