/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventFeed
implements Feed {
    private Expression expression;
    private Feed result;
    private Stack<XPathContext> contextStack;
    private PipelineConfiguration pipe;

    public EventFeed(Expression exp, Feed result, Stack<XPathContext> contextStack) {
        this.expression = exp;
        this.result = result;
        this.contextStack = contextStack;
        if (result != null) {
            this.pipe = result.getPipelineConfiguration();
        }
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Feed getResult() {
        return this.result;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public XPathContext getContext() {
        return this.contextStack.peek();
    }

    public Stack<XPathContext> getContextStack() {
        return this.contextStack;
    }

    @Override
    public void open() throws XPathException {
        if (this.result != null) {
            this.result.open();
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        this.getContext().getReceiver().append(item);
    }

    @Override
    public void close() throws XPathException {
        if (this.result != null) {
            this.result.close();
        }
    }
}

