/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.HashSet;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistinctValuesFeed
extends ItemFeed {
    private AtomicComparer atomicComparer;
    private HashSet<ComparisonKey> lookup = new HashSet(40);

    public DistinctValuesFeed(Expression expr, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
    }

    @Override
    public void open() throws XPathException {
        this.atomicComparer = ((DistinctValues)this.getExpression()).getAtomicComparer();
        this.getResult().open();
    }

    @Override
    public void append(Item item) throws XPathException {
        AtomicValue next = (AtomicValue)item;
        ComparisonKey key = this.atomicComparer.getComparisonKey(next);
        if (this.lookup.add(key)) {
            this.getResult().append(item);
        }
    }
}

