/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvgFeed
extends ItemFeed {
    private AtomicValue runningTotal = null;
    private int count = 0;

    public AvgFeed(Expression expr, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
    }

    @Override
    public void append(Item item) throws XPathException {
        XPathContext context = this.getContext();
        ConversionRules rules = context.getConfiguration().getConversionRules();
        ++this.count;
        AtomicValue next = (AtomicValue)item;
        if (this.runningTotal == null) {
            if (next instanceof UntypedAtomicValue) {
                next = next.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
            }
            this.runningTotal = next;
        } else if (this.runningTotal instanceof NumericValue) {
            if (next instanceof UntypedAtomicValue) {
                next = next.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
            } else if (!(next instanceof NumericValue)) {
                XPathException err = new XPathException("Input to avg() contains a mix of numeric and non-numeric values");
                err.setXPathContext(context);
                err.setErrorCode("FORG0006");
                throw err;
            }
            this.runningTotal = ArithmeticExpression.compute(this.runningTotal, 0, next, context);
        } else if (this.runningTotal instanceof DurationValue) {
            if (!(next instanceof DurationValue)) {
                XPathException err = new XPathException("Input to avg() contains a mix of duration and non-duration values");
                err.setXPathContext(context);
                err.setErrorCode("FORG0006");
                throw err;
            }
            this.runningTotal = ((DurationValue)this.runningTotal).add((DurationValue)next);
        } else {
            XPathException err = new XPathException("Input to avg() contains a value of type " + next.getPrimitiveType().getDisplayName() + " which is neither numeric, nor a duration");
            err.setXPathContext(context);
            err.setErrorCode("FORG0006");
            throw err;
        }
    }

    @Override
    public void close() throws XPathException {
        Feed result = this.getResult();
        if (this.count > 0) {
            result.append(ArithmeticExpression.compute(this.runningTotal, 3, new Int64Value(this.count), this.getContext()));
        }
        result.close();
    }
}

