/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Orphan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjacentTextNodeMergerFeed
extends ItemFeed {
    private FastStringBuffer buffer = new FastStringBuffer(100);
    boolean prevText = false;

    public AdjacentTextNodeMergerFeed(Expression expr, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
    }

    @Override
    public void open() throws XPathException {
        super.open();
    }

    @Override
    public void append(Item item) throws XPathException {
        if (AdjacentTextNodeMerger.isTextNode(item)) {
            CharSequence s = item.getStringValueCS();
            if (s.length() > 0) {
                this.buffer.append(s);
                this.prevText = true;
            }
        } else {
            if (this.prevText) {
                Orphan o = new Orphan(this.getPipelineConfiguration().getConfiguration());
                o.setNodeKind((short)3);
                o.setStringValue(this.buffer.toString());
                this.getResult().append(o);
                this.buffer.setLength(0);
            }
            this.prevText = false;
            this.getResult().append(item);
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.prevText) {
            Orphan o = new Orphan(this.getPipelineConfiguration().getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(this.buffer.toString());
            this.getResult().append(o);
            this.buffer.setLength(0);
        }
        this.getResult().close();
    }
}

