/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.adjunct;

import com.saxonica.expr.ee.OptimizerEE;
import com.saxonica.stream.ExpressionInverter;
import com.saxonica.stream.InvertedExpression;
import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.FeedMaker;
import com.saxonica.stream.feed.ForEachFeed;
import com.saxonica.stream.feed.ItemFeed;
import com.saxonica.stream.feed.ItemFeedMaker;
import com.saxonica.stream.watch.EventPushingWatch;
import com.saxonica.stream.watch.ForEachComposingWatch;
import com.saxonica.stream.watch.ForEachWatch;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachAdjunct
extends StreamingAdjunct {
    @Override
    public WatchMaker getWatchMaker(final Expression expression, List<String> reasonsForFailure) throws XPathException {
        block7: {
            Expression select = ((ForEach)expression).getSelectExpression();
            Expression action = ((ForEach)expression).getActionExpression();
            Configuration config = this.getConfiguration();
            if (ExpressionInverter.consumesStream(action)) {
                final Pattern selection = ((OptimizerEE)config.getOptimizer()).makeStreamingPattern(select, reasonsForFailure);
                if (selection == null) {
                    XPathException err = new XPathException("In a streamable for-each, if the body reads the streamed input then the select expression must select nodes from the streamed input");
                    err.setErrorCode("SXST0070");
                    err.setLocator(expression);
                    throw err;
                }
                if (ExpressionInverter.isUpwardsExpression(select)) {
                    XPathException err = new XPathException("In a streamable for-each, it is not permissible to navigate to an ancestor of the context node and then down to its descendants");
                    err.setErrorCode("SXST0071");
                    err.setLocator(expression);
                    throw err;
                }
                try {
                    ExpressionInverter inverter = new ExpressionInverter(config);
                    final InvertedExpression body = inverter.invertExpression(action);
                    if (selection != null) {
                        return new WatchMaker(){

                            @Override
                            public EventPushingWatch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                                SequenceReceiver result = contextStack.peek().getReceiver();
                                ForEachWatch watch = new ForEachWatch(expression, result, contextStack);
                                watch.setSelection(selection);
                                watch.setParentExpressionFeed(out);
                                watch.setPipelineConfiguration(result.getPipelineConfiguration());
                                watch.setWatchManager(watchManager);
                                watch.setBody(body);
                                return watch;
                            }
                        };
                    }
                    break block7;
                }
                catch (XPathException err) {
                    reasonsForFailure.add(err.getMessage());
                    return null;
                }
            }
            final Pattern selection = ((OptimizerEE)config.getOptimizer()).makeStreamingPattern(select, reasonsForFailure);
            if (selection != null) {
                return new WatchMaker(){

                    @Override
                    public Watch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                        ForEachComposingWatch watch = new ForEachComposingWatch((ForEach)expression, out, contextStack);
                        watch.setSelection(selection);
                        return watch;
                    }
                };
            }
        }
        return null;
    }

    @Override
    public FeedMaker getFeedMaker(final Expression expr, int arg) throws XPathException {
        ForEach f = (ForEach)expr;
        if ((f.getActionExpression().getDependencies() & 8) != 0) {
            XPathException err = new XPathException("Cannot use last() in the body of xsl:for-each when processing streamed input");
            err.setErrorCode("SXST0067");
            err.setLocator(f);
            throw err;
        }
        return new ItemFeedMaker(){

            @Override
            public ItemFeed makeItemFeed(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                return new ForEachFeed(expr, out, contextStack);
            }
        };
    }
}

