/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.adjunct;

import com.saxonica.stream.ExpressionInverter;
import com.saxonica.stream.InvertedExpression;
import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.watch.VoidWatchMaker;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseAdjunct
extends StreamingAdjunct {
    @Override
    public WatchMaker getWatchMaker(Expression expression, List<String> reasonsForFailure) throws XPathException {
        int i;
        Choose exp = (Choose)expression;
        final Expression[] conditions = exp.getConditions();
        Expression[] actions = exp.getActions();
        Configuration config = this.getConfiguration();
        boolean firstConditionConsumes = ExpressionInverter.consumesStream(conditions[0]);
        for (i = 1; i < conditions.length; ++i) {
            if (!ExpressionInverter.consumesStream(conditions[i])) continue;
            XPathException err = new XPathException("In a streamed conditional expression, no condition after the first may consume the streamed input");
            err.setErrorCode("SXST0066");
            err.setLocator(conditions[i]);
            throw err;
        }
        if (firstConditionConsumes) {
            for (i = 0; i < actions.length; ++i) {
                if (!ExpressionInverter.consumesStream(actions[i])) continue;
                XPathException err = new XPathException("In a streamed conditional expression, if the initial condition consumes the streamed input then the conditional branches must not do so");
                err.setErrorCode("SXST0066");
                err.setLocator(actions[i]);
                throw err;
            }
        }
        if (!firstConditionConsumes) {
            ExpressionInverter inverter = new ExpressionInverter(config);
            final InvertedExpression[] invertedActions = new InvertedExpression[conditions.length];
            for (int i2 = 0; i2 < conditions.length; ++i2) {
                invertedActions[i2] = inverter.invertExpression(actions[i2]);
            }
            return new WatchMaker(){

                @Override
                public Watch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                    for (int i = 0; i < conditions.length; ++i) {
                        boolean b;
                        try {
                            b = conditions[i].effectiveBooleanValue(contextStack.peek());
                        }
                        catch (XPathException e) {
                            e.maybeSetLocation(conditions[i]);
                            throw e;
                        }
                        if (!b) continue;
                        return invertedActions[i].getStreamingRoute().getWatch(watchManager, out, contextStack);
                    }
                    return VoidWatchMaker.getInstance().makeWatch(watchManager, out, contextStack);
                }
            };
        }
        return null;
    }
}

