/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.adjunct;

import com.saxonica.expr.ee.OptimizerEE;
import com.saxonica.stream.ExpressionInverter;
import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.watch.ApplyTemplatesWatch;
import com.saxonica.stream.watch.EventPushingWatch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyTemplatesAdjunct
extends StreamingAdjunct {
    @Override
    public WatchMaker getWatchMaker(final Expression expression, List<String> reasonsForFailure) throws XPathException {
        final Mode mode = ((ApplyTemplates)expression).getMode();
        Expression select = ((ApplyTemplates)expression).getSelectExpression();
        WithParam[] actualParams = ((ApplyTemplates)expression).getActualParams();
        WithParam[] tunnelParams = ((ApplyTemplates)expression).getTunnelParams();
        ApplyTemplatesAdjunct.checkParams(actualParams);
        ApplyTemplatesAdjunct.checkParams(tunnelParams);
        final Pattern selection = ((OptimizerEE)this.getConfiguration().getOptimizer()).makeStreamingPattern(select, reasonsForFailure);
        if (selection != null) {
            if (selection instanceof LocationPathPattern && ((LocationPathPattern)selection).selectsOutwards()) {
                XPathException err = new XPathException("The select expression cannot be used for a streamable template because it is not a pure downwards selection", expression);
                err.setErrorCode("SXST0064");
                throw err;
            }
            return new WatchMaker(){

                @Override
                public EventPushingWatch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                    XPathContext context = contextStack.peek();
                    SequenceReceiver result = context.getReceiver();
                    Mode actualMode = mode;
                    if (actualMode == null) {
                        actualMode = context.getCurrentMode();
                    }
                    if (actualMode == null) {
                        actualMode = context.getController().getRuleManager().getUnnamedMode();
                    }
                    ApplyTemplatesWatch watch = new ApplyTemplatesWatch(expression, result, contextStack);
                    watch.setParentExpressionFeed(out);
                    watch.setPipelineConfiguration(result.getPipelineConfiguration());
                    watch.setMode(actualMode);
                    watch.setSelection(selection);
                    watch.setWatchManager(watchManager);
                    return watch;
                }
            };
        }
        return null;
    }

    protected static void checkParams(WithParam[] params) throws XPathException {
        for (int i = 0; i < params.length; ++i) {
            Expression select = params[i].getSelectExpression();
            if (ExpressionInverter.consumesStream(select)) {
                XPathException err = new XPathException("In streaming mode, the initializing expression of a template parameter is not allowed to navigate into the subtree rooted at the context node");
                err.setErrorCode("SXST0068");
                err.setLocator(select);
                throw err;
            }
            if (!ExpressionInverter.returnsStreamedNode(select)) continue;
            XPathException err = new XPathException("In streaming mode, a parameter passed to a template must not be bound to a node in the streamed input document");
            err.setErrorCode("SXST0069");
            err.setLocator(select);
            throw err;
        }
    }
}

