/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import com.saxonica.stream.ExpressionInverter;
import com.saxonica.stream.InvertedExpression;
import com.saxonica.stream.StreamingRoute;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateInversion
implements RuleTarget {
    private Configuration config;
    private Template originalTemplate;
    private InvertedExpression body;
    private SlotManager stackFrame = null;

    private TemplateInversion() {
    }

    public TemplateInversion(Template originalTemplate, Configuration config) {
        this.config = config;
        this.originalTemplate = originalTemplate;
    }

    public static TemplateInversion makeBuiltInTemplate(WatchMaker watchMaker) {
        TemplateInversion t = new TemplateInversion();
        StreamingRoute.PushAction action = new StreamingRoute.PushAction();
        action.watchMaker = watchMaker;
        action.pushMethod = 8;
        StreamingRoute route = new StreamingRoute();
        route.append(action);
        t.body = new InvertedExpression(null, route);
        t.setStackFrame(SlotManager.EMPTY);
        return t;
    }

    public Watch getWatch(WatchManager wm, Stack<XPathContext> contextStack) throws XPathException {
        return this.body.getStreamingRoute().getWatch(wm, null, contextStack);
    }

    public Template getOriginalTemplate() {
        return this.originalTemplate;
    }

    public void invert(NodeTest nodeTest) throws XPathException {
        ExpressionInverter inverter = new ExpressionInverter(this.config);
        if (ExpressionInverter.returnsStreamedNode(this.originalTemplate.getBody())) {
            XPathException err = new XPathException("Template body is an expression that returns nodes from the streamed input document", "SXST0063");
            err.setLocator(this.originalTemplate);
            throw err;
        }
        if ((this.originalTemplate.getBody().getDependencies() & 8) != 0) {
            XPathException err = new XPathException("Template body is not streamable, because it calls last()", "SXST0067");
            err.setLocator(this.originalTemplate);
            throw err;
        }
        this.body = inverter.invertExpression(this.originalTemplate.getBody());
    }

    public void setStackFrame(SlotManager frame) {
        this.stackFrame = frame;
    }

    public SlotManager getStackFrame() {
        return this.stackFrame;
    }

    @Override
    public void explain(ExpressionPresenter presenter) {
        Expression exp = this.originalTemplate.getBody();
        presenter.emitAttribute("line", exp.getLineNumber() + "");
        presenter.emitAttribute("module", exp.getSystemId());
        presenter.emitAttribute("streaming", "true");
        this.body.getStreamingRoute().explain(presenter);
        exp.explain(presenter);
    }
}

