/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.DecomposingFeed;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.FeedMaker;
import com.saxonica.stream.watch.VoidWatchMaker;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingRoute {
    private List<PushAction> route = new ArrayList<PushAction>();

    public StreamingRoute copy() {
        StreamingRoute r2 = new StreamingRoute();
        r2.route.addAll(this.route);
        return r2;
    }

    public void append(PushAction action) {
        this.route.add(action);
    }

    public void prepend(PushAction action) {
        this.route.add(0, action);
    }

    public List<PushAction> getRoute() {
        return this.route;
    }

    public Watch getWatch(WatchManager watchManager, Feed parentFeed, Stack<XPathContext> contextStack) throws XPathException {
        if (parentFeed == null) {
            parentFeed = new DecomposingFeed(contextStack.peek().getReceiver());
        }
        List<PushAction> route = this.getRoute();
        for (int i = 0; i < route.size(); ++i) {
            int pushMethod = route.get((int)i).pushMethod;
            FeedMaker feedMaker = route.get((int)i).feedMaker;
            Expression exp = route.get((int)i).expression;
            if (pushMethod == 16) {
                if (feedMaker == null) {
                    XPathException err = new XPathException("Streaming is not possible for " + exp.getExpressionName() + " expression. (No feedMaker available for item feed)", "SXST0060");
                    err.setLocator(exp);
                    throw err;
                }
                parentFeed = feedMaker.makeItemFeed(watchManager, parentFeed, contextStack);
                continue;
            }
            if (pushMethod == 32) {
                if (feedMaker == null) {
                    XPathException err = new XPathException("Streaming is not possible for " + exp.getExpressionName() + " expression. (No feedMaker available for event feed)", "SXST0060");
                    err.setLocator(exp);
                    throw err;
                }
                parentFeed = feedMaker.makeEventFeed(watchManager, parentFeed, contextStack);
                continue;
            }
            if (pushMethod != 8) continue;
            WatchMaker watchMaker = route.get((int)i).watchMaker;
            if (watchMaker == null) {
                XPathException err = new XPathException("Streaming is not possible for " + exp.getExpressionName() + "expression. (No watchMaker available)", "SXST0060");
                err.setLocator(exp);
                throw err;
            }
            return watchMaker.makeWatch(watchManager, parentFeed, contextStack);
        }
        return VoidWatchMaker.getInstance().makeWatch(watchManager, parentFeed, contextStack);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("streamingRoute");
        for (int i = this.route.size() - 1; i >= 0; --i) {
            PushAction action = this.route.get(i);
            out.startSubsidiaryElement("expression");
            out.emitAttribute("name", action.expression == null ? "*unknown*" : action.expression.getExpressionName());
            out.emitAttribute("method", this.getMethodName(action.pushMethod));
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    private String getMethodName(int pushMethod) {
        switch (pushMethod) {
            case 8: {
                return "watch";
            }
            case 16: {
                return "itemFeed";
            }
            case 32: {
                return "eventFeed";
            }
        }
        return "" + pushMethod;
    }

    public static class PushAction {
        public Expression expression;
        public int streamingChildSequence;
        public StreamingAdjunct adjunct;
        public int pushMethod;
        public Pattern selectionPattern;
        public FeedMaker feedMaker;
        public WatchMaker watchMaker;
    }
}

