/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import com.saxonica.stream.ExpressionInverter;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.ConditionalPattern;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class StreamingPatternMaker {
    public static Pattern fromExpression(Expression expression, Configuration config) throws XPathException {
        Pattern result = null;
        if (expression instanceof DocumentSorter) {
            expression = ((DocumentSorter)expression).getBaseExpression();
        }
        if (expression instanceof Choose && !ExpressionInverter.consumesStream(((Choose)expression).getConditions()[0])) {
            Choose choice = (Choose)expression;
            Expression[] actions = choice.getActions();
            Pattern[] patterns = new Pattern[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                patterns[i] = StreamingPatternMaker.fromExpression(actions[i], config);
            }
            result = new ConditionalPattern(choice.getConditions(), patterns);
        } else if (Literal.isEmptySequence(expression)) {
            result = new NodeTestPattern(EmptySequenceTest.getInstance());
        } else if (expression instanceof VennExpression && ((VennExpression)expression).getOperator() == 1) {
            result = new UnionPattern(StreamingPatternMaker.fromExpression(((VennExpression)expression).getOperands()[0], config), StreamingPatternMaker.fromExpression(((VennExpression)expression).getOperands()[1], config));
        } else if (expression instanceof AxisExpression) {
            SlashExpression s = new SlashExpression(new ContextItemExpression(), expression);
            result = PatternMaker.fromExpression(s, config);
        } else if (expression instanceof FilterExpression) {
            Expression base = ((FilterExpression)expression).getControllingExpression();
            Expression filter = ((FilterExpression)expression).getFilter();
            if (ExpressionTool.selectsSideways(filter)) {
                throw new XPathException("The following/preceding axes are not allowed in predicate of a streaming selection", "SXST0067");
            }
            Pattern basePattern = StreamingPatternMaker.fromExpression(base, config);
            if (basePattern instanceof NodeTestPattern) {
                LocationPathPattern path = new LocationPathPattern();
                path.setNodeTest(basePattern.getNodeTest());
                basePattern = path;
            }
            if (!(basePattern instanceof LocationPathPattern)) {
                throw new XPathException("The filtered expression in a pattern must be a simple step");
            }
            ((LocationPathPattern)basePattern).addFilter(filter);
            result = basePattern;
        } else if (expression instanceof SlashExpression) {
            Expression head = ((SlashExpression)expression).getLeadingSteps();
            if (head instanceof RootExpression) {
                throw new XPathException("A streamable pattern must not start with '/' or '//'");
            }
            Expression tail = ((SlashExpression)expression).getLastStep();
            Pattern tailPattern = PatternMaker.fromExpression(tail, config);
            if (tailPattern instanceof NodeTestPattern) {
                LocationPathPattern path = new LocationPathPattern();
                path.setNodeTest(tailPattern.getNodeTest());
                tailPattern = path;
            }
            if (!(tailPattern instanceof LocationPathPattern)) {
                throw new XPathException("The path in a pattern must contain simple steps: found " + tailPattern.toString());
            }
            if (((LocationPathPattern)tailPattern).getUpperPattern() != null) {
                throw new XPathException("The path in a pattern must contain simple steps");
            }
            if (((LocationPathPattern)tailPattern).isPositional(config.getTypeHierarchy())) {
                throw new XPathException("A streamable pattern must not contain a positional predicate");
            }
            byte axis = PatternMaker.getAxisForPathStep(tail);
            Pattern headPattern = StreamingPatternMaker.fromExpression(head, config);
            ((LocationPathPattern)tailPattern).setUpperPattern(axis, headPattern);
            result = tailPattern;
        } else if (expression instanceof ContextItemExpression) {
            result = new AnchorPattern();
        } else if (expression instanceof RootExpression) {
            result = new NodeTestPattern(NodeKindTest.DOCUMENT);
        } else {
            TypeHierarchy th = config.getTypeHierarchy();
            ItemType type = expression.getItemType(th);
            if ((expression.getDependencies() & 0xE) == 0 && (type instanceof NodeTest || expression instanceof VariableReference)) {
                result = new NodeSetPattern(expression, config);
            }
        }
        if (result == null) {
            throw new XPathException("Cannot convert the expression {" + expression.toString() + "} to a streamed selection");
        }
        result.setOriginalText(expression.toString());
        return result;
    }
}

