/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import com.saxonica.stream.Conduit;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class SequenceExchanger {

    public static class SequencePusher
    extends SequenceWriter {
        Conduit conduit;

        public SequencePusher(Conduit si) {
            this.conduit = si;
        }

        public Conduit getConduit() {
            return this.conduit;
        }

        public void write(Item item) throws XPathException {
            this.conduit.write(item);
            if (this.conduit.isClosed()) {
                throw new XPathException("Conduit is closed");
            }
        }

        public void close() throws XPathException {
            this.conduit.finish();
            super.close();
        }
    }

    public static class EvaluationThread
    extends Producer {
        Expression expression;
        XPathContext context;
        Conduit conduit;
        PipelineConfiguration pipe;

        public EvaluationThread(Expression exp, PipelineConfiguration pipe, XPathContext context, Conduit conduit) {
            this.expression = exp;
            this.pipe = pipe;
            this.context = context;
            this.conduit = conduit;
        }

        public void run() {
            this.context = this.context.newContext();
            SequencePusher receiver = new SequencePusher(this.conduit);
            receiver.setPipelineConfiguration(this.pipe);
            this.context.setReceiver(receiver);
            try {
                this.expression.process(this.context);
                receiver.close();
            }
            catch (XPathException e) {
                this.conduit.signalProducerError(e);
                try {
                    receiver.close();
                }
                catch (XPathException e2) {}
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.conduit.signalProducerError(new XPathException(t));
                try {
                    receiver.close();
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
        }

        public Producer getAnother(Conduit conduit) {
            return new EvaluationThread(this.expression, this.pipe, this.context, conduit);
        }
    }

    public static abstract class Producer
    implements Runnable {
        public abstract Producer getAnother(Conduit var1);
    }

    public static class Consumer
    implements SequenceIterator {
        private Item current = null;
        private int position = 0;
        private Conduit conduit;
        private Producer producer;

        public Consumer(Conduit conduit, Producer producer) {
            this.conduit = conduit;
            this.producer = producer;
        }

        public Item current() {
            return this.current;
        }

        public SequenceIterator getAnother() throws XPathException {
            Conduit si = new Conduit();
            return new Consumer(si, this.producer.getAnother(si));
        }

        public int getProperties() {
            return 0;
        }

        public Item next() throws XPathException {
            this.current = this.conduit.read();
            this.position = this.current == null ? -1 : ++this.position;
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.conduit.close();
        }
    }
}

