/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import java.io.PrintStream;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;

public class Projector
extends ProxyReceiver {
    private Stack pathPositionStack;
    private Stack isCopiedStack;
    private int level = 0;
    private int copyAllLevel = Integer.MAX_VALUE;
    private int inputNodes = 0;
    private int outputNodes = 0;
    private boolean displayStatistics = false;
    private int[] nsStack = new int[20];
    private int nsStackTop = 0;
    private int[] nsCountStack = new int[20];

    public Projector(PathMap.PathMapRoot pathMapRoot) {
        this.pathPositionStack = new Stack();
        this.isCopiedStack = new Stack();
        this.pathPositionStack.push(new PathMap.PathMapNodeSet(pathMapRoot));
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.displayStatistics = pipe.getConfiguration().isTiming();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        ++this.level;
        ++this.inputNodes;
        boolean elementCopied = false;
        if (this.level > this.copyAllLevel) {
            super.startElement(nameCode, typeCode, locationId, properties);
            elementCopied = true;
            this.pathPositionStack.push("dummy");
        } else {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            PathMap.PathMapNodeSet newState = new PathMap.PathMapNodeSet();
            boolean foundMatch = false;
            for (PathMap.PathMapNode pathNode : state) {
                PathMap.PathMapArc[] pathMapArcs = pathNode.getArcs();
                for (int a = 0; a < pathMapArcs.length; ++a) {
                    PathMap.PathMapArc arc = pathMapArcs[a];
                    AxisExpression step = arc.getStep();
                    NodeTest test = step.getNodeTest();
                    if (test.matches(1, nameCode & 0xFFFFF, typeCode)) {
                        foundMatch = true;
                        PathMap.PathMapNode target = arc.getTarget();
                        newState.add(target);
                        if (target.isAtomized() || target.isReturnable()) {
                            this.copyAllLevel = this.level;
                        }
                    }
                    if (step.getAxis() != 4) continue;
                    newState.add(pathNode);
                }
            }
            this.pathPositionStack.push(newState);
            if (foundMatch) {
                super.startElement(nameCode, typeCode, locationId, properties);
                elementCopied = true;
            }
        }
        if (elementCopied) {
            int i;
            ++this.outputNodes;
            int pendingNamespaces = 0;
            for (i = this.level - 2; i >= 0 && !((Boolean)this.isCopiedStack.get(i)).booleanValue(); --i) {
                pendingNamespaces += this.nsCountStack[i];
            }
            for (i = this.nsStackTop - pendingNamespaces; i < this.nsStackTop; ++i) {
                boolean duplicate = false;
                for (int j = i + 1; j < this.nsStackTop; ++j) {
                    if ((this.nsStack[j] & 0xFFFF0000) != (this.nsStack[i] & 0xFFFF0000)) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                super.namespace(this.nsStack[i], 0);
            }
        }
        this.isCopiedStack.push(elementCopied);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level > this.copyAllLevel) {
            super.attribute(nameCode, typeCode, value, locationId, properties);
            ++this.outputNodes;
        } else if (((Boolean)this.isCopiedStack.peek()).booleanValue()) {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            for (PathMap.PathMapNode pathNode : state) {
                PathMap.PathMapArc[] pathMapArcs = pathNode.getArcs();
                for (int a = 0; a < pathMapArcs.length; ++a) {
                    PathMap.PathMapArc arc = pathMapArcs[a];
                    AxisExpression step = arc.getStep();
                    NodeTest test = step.getNodeTest();
                    if (!test.matches(2, nameCode & 0xFFFFF, typeCode)) continue;
                    super.attribute(nameCode, typeCode, value, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (((Boolean)this.isCopiedStack.peek()).booleanValue()) {
            super.namespace(namespaceCode, properties);
        } else {
            if (this.nsStack.length <= this.nsStackTop) {
                int[] ns2 = new int[this.nsStack.length * 2];
                System.arraycopy(this.nsStack, 0, ns2, 0, this.nsStackTop);
                this.nsStack = ns2;
            }
            this.nsStack[this.nsStackTop++] = namespaceCode;
            int n = this.level - 1;
            this.nsCountStack[n] = this.nsCountStack[n] + 1;
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level >= this.copyAllLevel) {
            super.characters(chars, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            for (PathMap.PathMapNode pathNode : state) {
                PathMap.PathMapArc[] pathMapArcs = pathNode.getArcs();
                for (int a = 0; a < pathMapArcs.length; ++a) {
                    PathMap.PathMapArc arc = pathMapArcs[a];
                    AxisExpression step = arc.getStep();
                    NodeTest test = step.getNodeTest();
                    if (!test.matches(3, -1, -1)) continue;
                    super.characters(chars, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level > this.copyAllLevel) {
            super.comment(chars, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            for (PathMap.PathMapNode pathNode : state) {
                PathMap.PathMapArc[] pathMapArcs = pathNode.getArcs();
                for (int a = 0; a < pathMapArcs.length; ++a) {
                    PathMap.PathMapArc arc = pathMapArcs[a];
                    AxisExpression step = arc.getStep();
                    NodeTest test = step.getNodeTest();
                    if (!test.matches(8, -1, -1)) continue;
                    super.comment(chars, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level > this.copyAllLevel) {
            super.processingInstruction(target, data, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            for (PathMap.PathMapNode pathNode : state) {
                PathMap.PathMapArc[] pathMapArcs = pathNode.getArcs();
                for (int a = 0; a < pathMapArcs.length; ++a) {
                    int fp;
                    PathMap.PathMapArc arc = pathMapArcs[a];
                    AxisExpression step = arc.getStep();
                    NodeTest test = step.getNodeTest();
                    if (!test.matches(7, fp = this.getNamePool().allocate("", "", target), -1)) continue;
                    super.processingInstruction(target, data, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    public void endElement() throws XPathException {
        boolean wasCopied = (Boolean)this.isCopiedStack.pop();
        if (wasCopied) {
            super.endElement();
        }
        this.pathPositionStack.pop();
        --this.level;
        if (this.level < this.copyAllLevel) {
            this.copyAllLevel = Integer.MAX_VALUE;
        }
        this.nsStackTop -= this.nsCountStack[this.level];
        this.nsCountStack[this.level] = 0;
    }

    public void endDocument() throws XPathException {
        if (this.displayStatistics) {
            this.outputStatistics(System.err);
        }
        super.endDocument();
    }

    public void outputStatistics(PrintStream out) {
        out.println("Document projection for " + this.getSystemId());
        out.println("-- Input nodes " + this.inputNodes + "; output nodes " + this.outputNodes + "; reduction = " + (100 - 100 * this.outputNodes / this.inputNodes) + "%");
    }
}

