/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;

public class Conduit {
    Item[] items = new Item[32];
    int numberUnread = 0;
    int firstUnread = 0;
    int nextToBeWritten = 0;
    boolean consumerIsWaiting = false;
    boolean producerIsWaiting = false;
    boolean closed = false;
    XPathException exception;

    public synchronized Item read() throws XPathException {
        if (this.exception != null) {
            throw this.exception;
        }
        while (this.numberUnread == 0) {
            try {
                this.consumerIsWaiting = true;
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        this.consumerIsWaiting = false;
        --this.numberUnread;
        if (this.producerIsWaiting) {
            this.notifyAll();
        }
        Item res = this.items[this.firstUnread];
        this.firstUnread = (this.firstUnread + 1) % 32;
        return res;
    }

    public synchronized void close() {
        this.closed = true;
        this.numberUnread = 0;
        if (this.producerIsWaiting) {
            this.notifyAll();
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void write(Item value) {
        while (this.numberUnread > 28) {
            try {
                this.producerIsWaiting = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.producerIsWaiting = false;
        if (this.closed) {
            return;
        }
        this.items[this.nextToBeWritten] = value;
        this.nextToBeWritten = (this.nextToBeWritten + 1) % 32;
        ++this.numberUnread;
        if (this.consumerIsWaiting) {
            this.notifyAll();
        }
    }

    public synchronized void finish() {
        this.write(null);
    }

    public synchronized void signalProducerError(XPathException exception) {
        this.exception = exception;
        if (this.consumerIsWaiting) {
            this.notifyAll();
        }
    }
}

