/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.Assertion;
import com.saxonica.schema.AssertionFacet;
import com.saxonica.schema.AttributeGroupReference;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.AttributeWildcard;
import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.schema.sdoc.XSDAnyAttribute;
import com.saxonica.schema.sdoc.XSDAssert;
import com.saxonica.schema.sdoc.XSDAttribute;
import com.saxonica.schema.sdoc.XSDAttributeGroup;
import com.saxonica.schema.sdoc.XSDFacet;
import com.saxonica.schema.sdoc.XSDSimpleType;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;

public class XSDSimpleContentRestriction
extends SchemaElement {
    private UserComplexType complexType = null;
    private SimpleTypeDefinition simpleTypeDef = null;
    private static final int WILD = -1;
    private static final int[] state0terms = new int[]{608, 622, 578, 614, 604, 583, 601, 606, 580, 607, 585, 621, 626, 603, 582, 595, 609, 623, 610, 592, 605, 584, -1};
    private static final int[] state0targets = new int[]{1, 1, 4, 1, 1, 1, 1, 1, 2, 1, 5, 6, 1, 1, 3, 1, 1, 1, 1, 1, 1, 5, 1};
    private static final int[] state1terms = new int[]{608, 622, 614, 604, 583, 601, 606, 580, 607, 585, 626, 603, 582, 595, 609, 623, 610, 592, 605, 584, -1};
    private static final int[] state1targets = new int[]{1, 1, 1, 1, 1, 1, 1, 2, 1, 5, 1, 1, 3, 1, 1, 1, 1, 1, 1, 5, 1};
    private static final int[] state2terms = new int[]{582};
    private static final int[] state2targets = new int[]{3};
    private static final int[] state3terms = new int[]{582};
    private static final int[] state3targets = new int[]{3};
    private static final int[] state4terms = new int[]{608, 622, 614, 604, 583, 601, 606, 580, 607, 585, 621, 626, 603, 582, 595, 609, 623, 610, 592, 605, 584, -1};
    private static final int[] state4targets = new int[]{1, 1, 1, 1, 1, 1, 1, 2, 1, 5, 6, 1, 1, 3, 1, 1, 1, 1, 1, 1, 5, 1};
    private static final int[] state5terms = new int[]{580, 582, 584, 585};
    private static final int[] state5targets = new int[]{2, 3, 5, 5};
    private static final int[] state6terms = new int[]{608, 622, 614, 604, 583, 601, 606, 580, 607, 585, 626, 603, 582, 595, 609, 623, 610, 592, 605, 584, -1};
    private static final int[] state6targets = new int[]{1, 1, 1, 1, 1, 1, 1, 2, 1, 5, 1, 1, 3, 1, 1, 1, 1, 1, 1, 5, 1};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms, state4terms, state5terms, state6terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets, state4targets, state5targets, state6targets};

    public void prepareAttributes() throws SchemaException {
        SingleNamespaceSchema schema = this.getSchema();
        try {
            this.complexType = this.getContainingComplexType();
        }
        catch (SchemaException e) {
            e.setLocator(this);
            this.error(e);
            return;
        }
        this.complexType.setDerivationMethodName("restriction");
        this.complexType.setRestriction(true);
        this.simpleTypeDef = new SimpleTypeDefinition((EnterpriseConfiguration)this.getConfiguration());
        this.simpleTypeDef.setLocator(this);
        this.simpleTypeDef.setIsSimpleContent(true);
        this.simpleTypeDef.setDerivationMethod(1);
        int nameCode = this.allocateAnonymousTypeCode();
        this.simpleTypeDef.setNameCode(nameCode);
        schema.addType(this.simpleTypeDef);
        TypeReference ref = new TypeReference(nameCode & 0xFFFFF, (EnterpriseConfiguration)this.getConfiguration(), this);
        ref.setTarget(this.simpleTypeDef);
        this.complexType.setSimpleContentTypeReference(ref);
        AttributeCollection atts = this.getAttributeList();
        this.processId();
        String[] allowed = new String[]{"base", "id"};
        this.allowAttributes(atts, allowed);
        String base = atts.getValue("", "base");
        if (base == null) {
            this.missingAttribute("base");
        } else {
            int baseFingerprint;
            try {
                baseFingerprint = this.getFingerprint(base, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            this.checkPermittedType(baseFingerprint, base, "a base type");
            TypeReference baseType = new TypeReference(baseFingerprint, (EnterpriseConfiguration)this.getConfiguration(), this);
            this.complexType.setBaseTypeReference(baseType);
        }
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        this.checkContentModel(stateTerms, stateTargets, true);
        boolean foundSimpleType = false;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            String name = child.getLocalPart();
            if (!"simpleType".equals(name)) continue;
            foundSimpleType = true;
        }
        if (!foundSimpleType) {
            TypeReference ref = new TypeReference(this.complexType.getBaseTypeFingerprint(), (EnterpriseConfiguration)this.getConfiguration(), this);
            this.simpleTypeDef.setBaseTypeReference(ref);
        }
    }

    protected boolean isFinalState(int state) {
        return state == 0 || state == 1 || state == 2 || state == 3 || state == 4 || state == 5 || state == 6;
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        IntHashSet facetsSeen = new IntHashSet();
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            int fp = child.getFingerprint();
            switch (fp) {
                case 578: {
                    break;
                }
                case 580: {
                    AttributeWildcard wildcard = ((XSDAnyAttribute)child).getWildcard();
                    this.complexType.setAnyAttribute(wildcard);
                    break;
                }
                case 584: {
                    AttributeUse attrDecl = ((XSDAttribute)child).getAttributeUse();
                    this.complexType.addAttributeUse(attrDecl);
                    break;
                }
                case 585: {
                    AttributeGroupReference attrGroupRef = ((XSDAttributeGroup)child).getAttributeGroupReference();
                    this.complexType.addAttributeGroupReference(attrGroupRef);
                    break;
                }
                case 621: {
                    SimpleTypeDefinition type = ((XSDSimpleType)child).getSimpleTypeDefinition();
                    TypeReference ref = new TypeReference(type.getFingerprint(), (EnterpriseConfiguration)this.getConfiguration(), this);
                    this.simpleTypeDef.setBaseTypeReference(ref);
                    break;
                }
                case 582: {
                    Assertion assertion = ((XSDAssert)child).getAssertion();
                    this.complexType.addAssertion(assertion);
                    break;
                }
                case 583: {
                    if (compiler.getLanguageVersion() == 10) {
                        this.error("To use xs:assertion, you must set xsdversion=1.1");
                    }
                    Assertion assertion = ((XSDAssert)child).getAssertion();
                    AssertionFacet af = new AssertionFacet(assertion);
                    af.setMessage(assertion.getMessage());
                    if (this.simpleTypeDef == null) break;
                    this.simpleTypeDef.addFacet(af);
                    break;
                }
                case 595: 
                case 601: 
                case 603: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 608: 
                case 609: 
                case 610: 
                case 622: 
                case 623: 
                case 626: {
                    if (facetsSeen.contains(fp)) {
                        this.error("The " + child.getDisplayName() + " facet must not appear more than once");
                    }
                    facetsSeen.add(fp);
                }
                case 592: 
                case 614: {
                    Facet facet = ((XSDFacet)child).getFacet();
                    if (facet == null || this.simpleTypeDef == null) break;
                    this.simpleTypeDef.addFacet(facet);
                    break;
                }
            }
        }
    }
}

