/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.sdoc.SchemaDocument;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.SchemaReader;
import com.saxonica.schema.sdoc.XSDSchema;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.transform.Source;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;

public class XSDRedefine
extends SchemaElement {
    private SingleNamespaceSchema externalSchema;
    private SingleNamespaceSchema redefinedSchema;
    private String externalSchemaDocumentURI;

    public void prepareAttributes() throws SchemaException {
        Source source;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue("", "schemaLocation");
        if (schemaLocation == null) {
            this.missingAttribute("schemaLocation");
            throw new SchemaException("Processing abandoned");
        }
        String documentBase = this.getBaseURI();
        PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
        SchemaCompiler manager = this.getXSDSchema().getSchemaCompiler();
        if (manager.isBeingRead((source = SchemaReader.getSource(documentBase, schemaLocation, pipe, null)).getSystemId())) {
            this.error("The schema document " + source.getSystemId() + " includes or redefines itself recursively");
            return;
        }
        if (manager.getExistingSchemaDocument(schemaLocation, this.getXSDSchema().getTargetNamespace()) != null) {
            this.error("Saxon can't handle redefinition of a schema document that has already been loaded by a different route");
            return;
        }
        try {
            SchemaCompiler compiler = this.getSchemaNodeFactory().getSchemaCompiler();
            SchemaDocument schemaDoc = SchemaReader.read(source, compiler, pipe, this);
            XSDSchema redefined = schemaDoc.getXSDSchema();
            this.externalSchema = redefined.getSchema();
            this.externalSchemaDocumentURI = redefined.getSystemId();
        }
        catch (SchemaException e) {
            Throwable cause = e.getException();
            if (cause instanceof IOException) {
                this.warning("Failed to locate redefined schema document " + schemaLocation);
                this.externalSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), "");
            }
            throw e;
        }
    }

    public SingleNamespaceSchema getRedefinedSchema() {
        return this.redefinedSchema;
    }

    public SingleNamespaceSchema getExternalSchema() {
        return this.externalSchema;
    }

    public String getExternalSchemaDocumentURI() {
        return this.externalSchemaDocumentURI;
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        if (this.externalSchema == null) {
            return;
        }
        HashSet<String> redefinedTypes = new HashSet<String>();
        HashSet<String> redefinedAttributeGroups = new HashSet<String>();
        HashSet<String> redefinedModelGroups = new HashSet<String>();
        int nameFP = this.getNamePool().allocate("", "", "name");
        AxisIterator iter = this.iterateAxis((byte)3);
        block6: while ((child = (NodeInfo)iter.next()) != null) {
            int fp = child.getFingerprint();
            switch (fp) {
                case 578: {
                    continue block6;
                }
                case 585: {
                    String attributeGroupName = child.getAttributeValue(nameFP);
                    if (attributeGroupName == null || redefinedAttributeGroups.add(attributeGroupName)) continue block6;
                    this.error("Attempting to redefine the same attribute group more than once");
                    continue block6;
                }
                case 588: 
                case 621: {
                    String typeName = child.getAttributeValue(nameFP);
                    if (typeName == null || redefinedTypes.add(typeName)) continue block6;
                    this.error("Attempting to redefine the same type more than once");
                    continue block6;
                }
                case 596: {
                    String modelGroupName = child.getAttributeValue(nameFP);
                    if (modelGroupName == null || redefinedModelGroups.add(modelGroupName)) continue block6;
                    this.error("Attempting to redefine the same named model group more than once");
                    continue block6;
                }
            }
            this.illegalElement(child);
        }
        this.redefinedSchema = new SingleNamespaceSchema(this.externalSchema.getConfiguration(), this.externalSchema.getTargetNamespace());
        this.externalSchema.copyTo(this.redefinedSchema, compiler);
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        if (this.redefinedSchema != null) {
            this.redefinedSchema.copyTo(this.getSchema(), compiler);
        }
    }
}

