/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.ElementWildcard;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.sdoc.AnnotationParent;
import com.saxonica.schema.sdoc.XSDAny;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSDOpenContent
extends AnnotationParent {
    private String mode = "interleave";
    private ElementWildcard wildcard;
    private static final int[] state0terms = new int[]{578, 579};
    private static final int[] state0targets = new int[]{1, 2};
    private static final int[] state1terms = new int[]{579};
    private static final int[] state1targets = new int[]{2};
    private static final int[] state2terms = new int[0];
    private static final int[] state2targets = new int[0];
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets};

    public void prepareAttributes() throws SchemaException {
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "mode"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String attValue = Whitespace.trim(atts.getValue("", "mode"));
        if (attValue != null) {
            if (attValue.equals("interleave") || attValue.equals("suffix") || attValue.equals("none")) {
                this.mode = attValue;
            } else {
                this.invalidAttributeValue("mode", attValue, "Must be 'interleave' or 'suffix' or 'none");
            }
        }
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        this.checkContentModel(stateTerms, stateTargets, false);
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            int fp = child.getFingerprint();
            switch (fp) {
                case 579: {
                    if ("none".equals(this.mode)) {
                        this.error("When mode='none', the <xs:openContent> element must not have an <xs:any> child element");
                        break;
                    }
                    this.wildcard = ((XSDAny)child).getElementWildcard();
                }
            }
        }
        if (this.wildcard == null && !"none".equals(this.mode)) {
            this.error("Except when mode='none', the <xs:openContent> element must have an <xs:any> child element");
            this.mode = "none";
        }
    }

    protected boolean isFinalState(int state) {
        return state == 0 || state == 1 || state == 2;
    }

    public String getMode() {
        return this.mode;
    }

    public ElementWildcard getElementWildcard() {
        return this.wildcard;
    }
}

