/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.IdentityConstraintReference;
import com.saxonica.schema.IdentityField;
import com.saxonica.schema.IdentitySelector;
import com.saxonica.schema.Key;
import com.saxonica.schema.KeyRef;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.Unique;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.XSDFieldOrSelector;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;

public class XSDIdentityConstraint
extends SchemaElement {
    private boolean isRef = false;
    private int constraintName;
    private IdentityConstraint identityConstraint = null;

    public void prepareAttributes() throws SchemaException {
        String[] allowed;
        AttributeCollection atts = this.getAttributeList();
        if (this.getFingerprint() == 600) {
            allowed = new String[]{"id", "name", "ref", "refer"};
            this.allowAttributes(atts, allowed);
        } else {
            allowed = new String[]{"id", "name", "ref"};
            this.allowAttributes(atts, allowed);
        }
        this.processId();
        this.checkMutuallyExclusiveAttributes("ref", "name");
        this.checkMutuallyExclusiveAttributes("ref", "refer");
        String refAtt = atts.getValue("", "ref");
        int nameCode = -1;
        if (refAtt != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The @ref attribute cannot be used on an integrity constraint unless XSD 1.1 is enabled");
            }
            nameCode = this.getFingerprint(refAtt, 0);
            this.isRef = true;
        } else {
            String name = atts.getValue("", "name");
            if (name == null) {
                this.missingAttribute("name");
                name = "saxon-error-" + this.getLocalPart() + "-name";
            }
            nameCode = this.getNameCode(name, 1);
            if (this.getFingerprint() == 600) {
                int referFingerprint;
                String referAtt = atts.getValue("", "refer");
                if (referAtt == null) {
                    this.missingAttribute("refer");
                    return;
                }
                try {
                    referFingerprint = this.getFingerprint(referAtt, 0);
                }
                catch (SchemaException err) {
                    referFingerprint = this.getNamePool().allocate("", "http://saxon.sf.net/", "_nonexistent_key_definition_");
                    this.error(err.getMessage());
                }
                this.identityConstraint = new KeyRef(referFingerprint);
            } else {
                this.identityConstraint = this.getFingerprint() == 625 ? new Unique() : new Key();
            }
            SingleNamespaceSchema schema = this.getSchema();
            this.identityConstraint.setConfiguration((EnterpriseConfiguration)this.getConfiguration());
            this.identityConstraint.setLocator(this);
            this.identityConstraint.setNameCode(nameCode);
            if (schema.getIdentityConstraint(nameCode & 0xFFFFF) != null) {
                this.duplicate("identity constraint", name);
            }
            schema.addIdentityConstraint(this.identityConstraint);
        }
        this.constraintName = nameCode & 0xFFFFF;
    }

    public boolean isReference() {
        return this.isRef;
    }

    public IdentityConstraintReference getIdentityConstraint() {
        IdentityConstraintReference ref = new IdentityConstraintReference(this.constraintName, this.getFingerprint(), (EnterpriseConfiguration)this.getConfiguration(), this);
        if (this.isRef) {
            return ref;
        }
        if (this.identityConstraint == null) {
            return null;
        }
        ref.setTarget(this.identityConstraint);
        return ref;
    }

    public int getConstraintFingerprint() {
        return this.constraintName;
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        boolean foundAnnotation = false;
        boolean foundSelector = false;
        boolean foundField = false;
        AxisIterator iter = this.iterateAxis((byte)3);
        block5: while ((child = (NodeInfo)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 578: {
                    if (foundAnnotation) {
                        this.duplicateElement("annotation");
                    }
                    if (foundSelector || foundField) {
                        this.mustBeFirstElement("annotation");
                    }
                    foundAnnotation = true;
                    continue block5;
                }
                case 618: {
                    if (foundField) {
                        this.mustPrecede("selector", "field");
                    }
                    if (foundSelector) {
                        this.duplicateElement("selector");
                    }
                    foundSelector = true;
                    continue block5;
                }
                case 594: {
                    foundField = true;
                    continue block5;
                }
            }
            this.illegalElement(child);
        }
        if (this.isRef) {
            if (foundSelector) {
                this.mutuallyExclusiveElementAndAttribute("selector", "ref");
            }
            if (foundField) {
                this.mutuallyExclusiveElementAndAttribute("field", "ref");
            }
        } else {
            if (!foundSelector) {
                this.missingChildElement("selector");
            }
            if (!foundField) {
                this.missingChildElement("field");
            }
        }
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        if (this.identityConstraint == null) {
            return;
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 578: {
                    break;
                }
                case 618: {
                    IdentitySelector selector = ((XSDFieldOrSelector)child).getIdentitySelector();
                    this.identityConstraint.setSelector(selector);
                    break;
                }
                case 594: {
                    IdentityField field = ((XSDFieldOrSelector)child).getIdentityField();
                    this.identityConstraint.addField(field);
                    break;
                }
            }
        }
    }
}

