/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.ModelGroupDefinition;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.Particle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.XSDCompositor;
import com.saxonica.schema.sdoc.XSDRedefine;
import java.util.Iterator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.UnresolvedReferenceException;

public class XSDGroup
extends SchemaElement {
    private ModelGroupDefinition groupDeclaration = null;
    private ModelGroupParticle modelGroupParticle = null;
    private boolean foundMinOccurs = false;
    private boolean foundMaxOccurs = false;
    private boolean isRedefinition;

    public void prepareAttributes() throws SchemaException {
        int maxOccurs;
        String attValue;
        String[] allowed;
        SingleNamespaceSchema schema = this.getSchema();
        this.isRedefinition = this.getParent() instanceof XSDRedefine;
        AttributeCollection atts = this.getAttributeList();
        if (this.isTopLevel()) {
            this.groupDeclaration = new ModelGroupDefinition((EnterpriseConfiguration)this.getConfiguration(), this);
            this.groupDeclaration.setSchemaDocumentURI(this.getParent().getSystemId());
            allowed = new String[]{"id", "name"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
        } else {
            this.modelGroupParticle = new ModelGroupParticle((EnterpriseConfiguration)this.getConfiguration(), this);
            schema.addComponent(this.modelGroupParticle);
            allowed = new String[]{"id", "maxOccurs", "minOccurs", "ref"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "ref");
        }
        String name = atts.getValue("", "name");
        if (name != null && this.groupDeclaration != null) {
            int nc;
            try {
                nc = this.getNameCode(name, 1);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                nc = 574;
            }
            this.groupDeclaration.setNameCode(nc);
        }
        if ((attValue = atts.getValue("", "maxOccurs")) != null && this.modelGroupParticle != null) {
            this.foundMaxOccurs = true;
            if (this.groupDeclaration != null) {
                this.mutuallyExclusiveAttributes("name", "maxOccurs");
            } else {
                int max = this.processMaxOccurs(attValue);
                this.modelGroupParticle.setMaxOccurs(max);
            }
        }
        if ((attValue = atts.getValue("", "minOccurs")) != null && this.modelGroupParticle != null) {
            this.foundMinOccurs = true;
            if (this.groupDeclaration != null) {
                this.mutuallyExclusiveAttributes("name", "minOccurs");
            } else {
                int minOccurs = this.processMinOccurs(attValue);
                this.modelGroupParticle.setMinOccurs(minOccurs);
            }
        }
        if (this.modelGroupParticle != null && (maxOccurs = this.modelGroupParticle.getMaxOccurs()) != -1 && this.modelGroupParticle.getMinOccurs() > maxOccurs) {
            this.error("maxOccurs must not be less than minOccurs");
        }
        if ((attValue = atts.getValue("", "ref")) != null && this.modelGroupParticle != null) {
            if (this.groupDeclaration != null) {
                this.mutuallyExclusiveAttributes("name", "ref");
            } else {
                int fp;
                try {
                    fp = this.getFingerprint(attValue, 0);
                }
                catch (SchemaException err) {
                    this.error(err.getMessage());
                    return;
                }
                this.modelGroupParticle.setNameCode(fp);
            }
        }
        this.processId();
    }

    public ModelGroupDefinition getGroupDeclaration() {
        return this.groupDeclaration;
    }

    public ModelGroupParticle getGroupReference() {
        return this.modelGroupParticle;
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        boolean foundAnnotation = false;
        NodeInfo foundCompositor = null;
        AxisIterator iter = this.iterateAxis((byte)3);
        block5: while ((child = (NodeInfo)iter.next()) != null) {
            int fp = child.getFingerprint();
            switch (fp) {
                case 578: {
                    if (foundAnnotation) {
                        this.duplicateElement("annotation");
                    }
                    if (foundCompositor != null) {
                        this.mustBeFirstElement("annotation");
                    }
                    foundAnnotation = true;
                    continue block5;
                }
                case 576: {
                    if (this.foundMinOccurs) {
                        this.mutuallyExclusiveElementAndAttribute("all", "minOccurs");
                    }
                    if (this.foundMaxOccurs) {
                        this.mutuallyExclusiveElementAndAttribute("all", "maxOccurs");
                    }
                }
                case 586: 
                case 619: {
                    if (foundCompositor != null) {
                        this.mutuallyExclusive(child.getDisplayName(), foundCompositor.getDisplayName());
                    }
                    if (this.modelGroupParticle != null) {
                        this.mutuallyExclusiveElementAndAttribute(child.getDisplayName(), "ref");
                    }
                    foundCompositor = child;
                    continue block5;
                }
            }
            this.illegalElement(child);
        }
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        if (this.groupDeclaration == null) {
            return;
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            int fp = child.getFingerprint();
            switch (fp) {
                case 576: 
                case 586: 
                case 619: {
                    ModelGroupParticle compositor = ((XSDCompositor)child).getModelGroupParticle();
                    this.groupDeclaration.addParticle(compositor);
                }
            }
        }
        if (this.isRedefinition) {
            SingleNamespaceSchema externalSchema = ((XSDRedefine)this.getParent()).getExternalSchema();
            SingleNamespaceSchema redefinedSchema = ((XSDRedefine)this.getParent()).getRedefinedSchema();
            if (externalSchema == null || redefinedSchema == null) {
                return;
            }
            ModelGroupDefinition originalGroup = externalSchema.getGroup(this.groupDeclaration.getFingerprint());
            if (originalGroup == null) {
                this.error("Group " + Err.wrap(this.groupDeclaration.getName()) + " is not defined in the schema being redefined");
                return;
            }
            if (!((XSDRedefine)this.getParent()).getExternalSchemaDocumentURI().equals(originalGroup.getSchemaDocumentURI())) {
                compiler.warning("The redefined model group was found, but not in the schema document referenced by the schemaLocation attribute of the containing <xs:redefine> element. This is not allowed by the XSD specification. However, Saxon does not currently enforce this rule.", this);
            }
            this.groupDeclaration.setRedefinitionLevel(originalGroup.getRedefinitionLevel() + 1);
            boolean found = this.patchUpSelfReferences(compiler, this.groupDeclaration.iterateParticles(), this.groupDeclaration.getFingerprint(), originalGroup, false);
            if (!found) {
                this.groupDeclaration.setRedefinedModelGroupDefinition(originalGroup);
            }
            redefinedSchema.addGroup(this.groupDeclaration);
        }
    }

    private boolean patchUpSelfReferences(SchemaCompiler compiler, Iterator particles, int fingerprint, ModelGroupDefinition originalGroup, boolean found) throws SchemaException {
        SingleNamespaceSchema redefinedSchema = ((XSDRedefine)this.getParent()).getRedefinedSchema();
        boolean f = found;
        while (particles.hasNext()) {
            ModelGroup group;
            Object p = particles.next();
            if (p instanceof ModelGroupParticle && ((ModelGroupParticle)p).getFingerprint() == fingerprint) {
                if (f) {
                    this.error("Redefined group " + Err.wrap(this.groupDeclaration.getName()) + " contains more than one reference to itself");
                }
                f = true;
                ModelGroupParticle gref = (ModelGroupParticle)p;
                if (gref.getMinOccurs() != 1) {
                    this.error("Redefined group " + Err.wrap(this.groupDeclaration.getName()) + " must have minOccurs=1");
                }
                if (gref.getMaxOccurs() != 1) {
                    this.error("Redefined group " + Err.wrap(this.groupDeclaration.getName()) + " must have maxOccurs=1");
                }
                String uri = this.getXSDSchema().getTargetNamespace();
                NamePool pool = this.getNamePool();
                String localName = pool.getLocalName(gref.getFingerprint());
                String newLocalName = localName + '_' + gref.hashCode();
                int newNameCode = pool.allocate("", uri, newLocalName);
                gref.setNameCode(newNameCode);
                originalGroup.setNameCode(newNameCode);
                redefinedSchema.addGroup(originalGroup);
                continue;
            }
            if (!(p instanceof ModelGroupParticle)) continue;
            try {
                group = ((ModelGroupParticle)p).getGroup();
            }
            catch (UnresolvedReferenceException e) {
                continue;
            }
            Iterator<Particle> subiter = group.iterateParticles();
            f = this.patchUpSelfReferences(compiler, subiter, fingerprint, originalGroup, f);
        }
        return f;
    }
}

