/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.ExplicitTimezoneFacet;
import com.saxonica.schema.Facet;
import com.saxonica.schema.ScaleFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.sdoc.AnnotationParent;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.type.SchemaException;

public class XSDFacet
extends AnnotationParent {
    private Facet facet = null;

    public void prepareAttributes() throws SchemaException {
        String[] allowed;
        AttributeCollection atts = this.getAttributeList();
        if (this.getLocalPart().equals("enumeration") || this.getLocalPart().equals("pattern")) {
            allowed = new String[]{"id", "value"};
            this.allowAttributes(atts, allowed);
        } else {
            allowed = new String[]{"fixed", "id", "value"};
            this.allowAttributes(atts, allowed);
        }
        String value = atts.getValue("", "value");
        if (value == null) {
            this.missingAttribute("value");
            value = "";
        }
        try {
            this.facet = Facet.makeFacet(this.getLocalPart(), value, this.getSchema().getConfiguration(), this.makeNamespaceContext());
        }
        catch (SchemaException err) {
            this.error(err.getMessage());
            return;
        }
        String message = atts.getValue("http://saxon.sf.net/", "message");
        if (message != null) {
            this.facet.setMessage(message);
        }
        String fixedAtt = atts.getValue("", "fixed");
        boolean fixed = false;
        if (fixedAtt != null) {
            fixed = this.parseBooleanAttribute("fixed", fixedAtt);
        }
        this.facet.setFixed(fixed);
        this.processId();
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        super.validate(compiler);
        if (compiler.getLanguageVersion() == 10) {
            if (this.facet instanceof ExplicitTimezoneFacet) {
                this.error("Timezone facet requires XSD 1.1 to be enabled");
            } else if (this.facet instanceof ScaleFacet) {
                this.error("minScale and maxScale facets require XSD 1.1 to be enabled");
            }
        }
    }

    public Facet getFacet() {
        return this.facet;
    }
}

