/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.Assertion;
import com.saxonica.schema.AttributeGroupReference;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.AttributeWildcard;
import com.saxonica.schema.ElementWildcard;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.Wildcard;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.XSDAnyAttribute;
import com.saxonica.schema.sdoc.XSDAssert;
import com.saxonica.schema.sdoc.XSDAttribute;
import com.saxonica.schema.sdoc.XSDAttributeGroup;
import com.saxonica.schema.sdoc.XSDCompositor;
import com.saxonica.schema.sdoc.XSDGroup;
import com.saxonica.schema.sdoc.XSDOpenContent;
import com.saxonica.schema.sdoc.XSDSimpleContent;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;

public class XSDExtension
extends SchemaElement {
    private UserComplexType complexType = null;
    private boolean isSimpleContent;
    private static final int[] state0terms = new int[]{586, 619, 582, 612, 578, 585, 580, 576, 584, 596};
    private static final int[] state0targets = new int[]{2, 2, 6, 4, 5, 1, 3, 2, 1, 2};
    private static final int[] state1terms = new int[]{584, 585, 580, 582};
    private static final int[] state1targets = new int[]{1, 1, 3, 6};
    private static final int[] state2terms = new int[]{584, 585, 580, 582};
    private static final int[] state2targets = new int[]{1, 1, 3, 6};
    private static final int[] state3terms = new int[]{582};
    private static final int[] state3targets = new int[]{6};
    private static final int[] state4terms = new int[]{584, 596, 586, 585, 576, 580, 619, 582};
    private static final int[] state4targets = new int[]{1, 2, 2, 1, 2, 3, 2, 6};
    private static final int[] state5terms = new int[]{586, 619, 582, 612, 585, 580, 576, 584, 596};
    private static final int[] state5targets = new int[]{2, 2, 6, 4, 1, 3, 2, 1, 2};
    private static final int[] state6terms = new int[]{582};
    private static final int[] state6targets = new int[]{6};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms, state4terms, state5terms, state6terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets, state4targets, state5targets, state6targets};

    public void prepareAttributes() throws SchemaException {
        int baseFingerprint;
        try {
            this.complexType = this.getContainingComplexType();
        }
        catch (SchemaException e) {
            e.setLocator(this);
            this.error(e);
            return;
        }
        this.isSimpleContent = this.getParent() instanceof XSDSimpleContent;
        this.complexType.setDerivationMethodName("extension");
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"base", "id"};
        this.allowAttributes(atts, allowed);
        String base = atts.getValue("", "base");
        if (base != null) {
            try {
                baseFingerprint = this.getFingerprint(base, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
        } else {
            this.missingAttribute("base");
            return;
        }
        this.checkPermittedType(baseFingerprint, base, "a base type");
        TypeReference baseType = new TypeReference(baseFingerprint, this.complexType.getConfiguration(), this);
        this.complexType.setBaseTypeReference(baseType);
        this.processId();
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        this.checkContentModel(stateTerms, stateTargets, false);
        if (this.isSimpleContent) {
            NodeInfo child;
            AxisIterator iter = this.iterateAxis((byte)3);
            while ((child = (NodeInfo)iter.next()) != null) {
                int fp = child.getFingerprint();
                switch (fp) {
                    case 576: 
                    case 586: 
                    case 596: 
                    case 619: {
                        String name = child.getLocalPart();
                        this.error((name.equals("all") ? "An" : "A") + ' ' + Err.wrap(name, 1) + " model group cannot appear in simple content");
                        return;
                    }
                    case 612: {
                        this.error("An <openContent> element cannot appear in simple content");
                        return;
                    }
                }
            }
        }
    }

    protected boolean isFinalState(int state) {
        return true;
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        if (this.complexType == null) {
            return;
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 580: {
                    AttributeWildcard wildcard = ((XSDAnyAttribute)child).getWildcard();
                    this.complexType.setAnyAttribute(wildcard);
                    break;
                }
                case 584: {
                    AttributeUse attrDecl = ((XSDAttribute)child).getAttributeUse();
                    this.complexType.addAttributeUse(attrDecl);
                    break;
                }
                case 585: {
                    AttributeGroupReference attrGroupRef = ((XSDAttributeGroup)child).getAttributeGroupReference();
                    this.complexType.addAttributeGroupReference(attrGroupRef);
                    break;
                }
                case 596: {
                    ModelGroupParticle modelGroup = ((XSDGroup)child).getGroupReference();
                    this.complexType.setParticle(modelGroup);
                    break;
                }
                case 576: 
                case 586: 
                case 619: {
                    ModelGroupParticle group = ((XSDCompositor)child).getModelGroupParticle();
                    this.complexType.setParticle(group);
                    break;
                }
                case 582: {
                    Assertion assertion = ((XSDAssert)child).getAssertion();
                    this.complexType.addAssertion(assertion);
                    break;
                }
                case 578: {
                    break;
                }
                case 612: {
                    ElementWildcard ew = ((XSDOpenContent)child).getElementWildcard();
                    Wildcard openContentWildcard = ew == null ? null : ew.getWildcard();
                    String openContentMode = ((XSDOpenContent)child).getMode();
                    this.complexType.setOpenContentWildcard(openContentWildcard, openContentMode, true);
                    break;
                }
            }
        }
    }
}

