/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.AllModelGroup;
import com.saxonica.schema.ChoiceModelGroup;
import com.saxonica.schema.ElementParticle;
import com.saxonica.schema.ElementWildcard;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SequenceModelGroup;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.XSDAny;
import com.saxonica.schema.sdoc.XSDElement;
import com.saxonica.schema.sdoc.XSDGroup;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;

public class XSDCompositor
extends SchemaElement {
    private ModelGroup modelGroup = null;
    private ModelGroupParticle particle = null;

    public void prepareAttributes() throws SchemaException {
        int maxOccurs;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "maxOccurs", "minOccurs"};
        this.allowAttributes(atts, allowed);
        int fp = this.getFingerprint();
        switch (fp) {
            case 619: {
                this.modelGroup = new SequenceModelGroup();
                break;
            }
            case 586: {
                this.modelGroup = new ChoiceModelGroup();
                break;
            }
            case 576: {
                this.modelGroup = new AllModelGroup();
                break;
            }
            default: {
                this.error("Invalid compositor element name: " + Err.wrap(this.getLocalPart(), 1) + "(fp = " + fp + ")");
                return;
            }
        }
        this.modelGroup.setLocator(this);
        this.modelGroup.setConfiguration(this.getSchema().getConfiguration());
        this.particle = new ModelGroupParticle(this.getSchema().getConfiguration(), this);
        this.particle.setTarget(this.modelGroup);
        NodeInfo parent = this.getParent();
        String attValue = atts.getValue("", "maxOccurs");
        if (attValue != null) {
            if (parent.getFingerprint() == 596) {
                if (this.modelGroup instanceof AllModelGroup) {
                    this.error("Cannot specify 'maxOccurs' on an 'all' compositor within a group");
                }
                if (this.modelGroup instanceof ChoiceModelGroup) {
                    this.error("Cannot specify 'maxOccurs' on a 'choice' compositor within a group");
                }
            }
            int max = this.processMaxOccurs(attValue);
            this.particle.setMaxOccurs(max);
        }
        if ((attValue = atts.getValue("", "minOccurs")) != null) {
            if (parent.getFingerprint() == 596) {
                if (this.modelGroup instanceof AllModelGroup) {
                    this.error("Cannot specify 'minOccurs' on an 'all' compositor within a group");
                }
                if (this.modelGroup instanceof ChoiceModelGroup) {
                    this.error("Cannot specify 'minOccurs' on a 'choice' compositor within a group");
                }
            }
            int minOccurs = this.processMinOccurs(attValue);
            this.particle.setMinOccurs(minOccurs);
        }
        if ((maxOccurs = this.particle.getMaxOccurs()) != -1 && this.particle.getMinOccurs() > maxOccurs) {
            this.error("maxOccurs must not be less than minOccurs");
        }
        if (this.modelGroup instanceof AllModelGroup) {
            int max = this.particle.getMaxOccurs();
            if (max != 1) {
                this.invalidAttributeValue("maxOccurs", max == -1 ? "unbounded" : max + "", "Must be \"1\"");
                return;
            }
            if (this.particle.getMinOccurs() > 1) {
                this.invalidAttributeValue("minOccurs", this.particle.getMinOccurs() + "", "Must be \"0\" or \"1\"");
                return;
            }
        }
        this.processId();
    }

    public ModelGroup getModelGroup() {
        return this.modelGroup;
    }

    public ModelGroupParticle getModelGroupParticle() {
        return this.particle;
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        boolean foundElement = false;
        boolean foundCompositor = false;
        boolean foundGroup = false;
        boolean foundAnnotation = false;
        AxisIterator iter = this.iterateAxis((byte)3);
        block7: while ((child = (NodeInfo)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 578: {
                    if (foundElement || foundCompositor || foundGroup) {
                        this.mustBeFirstElement("annotation");
                    }
                    if (foundAnnotation) {
                        this.duplicateElement("annotation");
                    }
                    foundAnnotation = true;
                    continue block7;
                }
                case 591: {
                    foundElement = true;
                    continue block7;
                }
                case 596: {
                    if (this.modelGroup instanceof AllModelGroup && compiler.getLanguageVersion() == 10) {
                        this.illegalElement(child);
                    }
                    foundGroup = true;
                    continue block7;
                }
                case 586: 
                case 619: {
                    if (this.modelGroup instanceof AllModelGroup) {
                        this.illegalElement(child);
                    }
                    foundCompositor = true;
                    continue block7;
                }
                case 579: {
                    if (!(this.modelGroup instanceof AllModelGroup) || compiler.getLanguageVersion() != 10) continue block7;
                    this.illegalElement(child);
                    continue block7;
                }
            }
            this.illegalElement(child);
        }
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 579: {
                    ElementWildcard wildcard = ((XSDAny)child).getElementWildcard();
                    this.modelGroup.addParticle(wildcard);
                    break;
                }
                case 578: {
                    break;
                }
                case 591: {
                    ElementParticle element = ((XSDElement)child).getElementParticle();
                    if (this.modelGroup instanceof AllModelGroup && compiler.getLanguageVersion() == 10) {
                        if (element.getMinOccurs() > 1) {
                            this.error("Within <xs:all>, an <xs:element> must have @minOccurs equal to 0 or 1");
                        }
                        if (element.getMaxOccurs() > 1) {
                            this.error("Within <xs:all>, an <xs:element> must have @maxOccurs equal to 0 or 1");
                        }
                    }
                    this.modelGroup.addParticle(element);
                    break;
                }
                case 596: {
                    ModelGroupParticle modelGroup = ((XSDGroup)child).getGroupReference();
                    this.modelGroup.addParticle(modelGroup);
                    break;
                }
                case 576: 
                case 586: 
                case 619: {
                    ModelGroupParticle p = ((XSDCompositor)child).getModelGroupParticle();
                    this.modelGroup.addParticle(p);
                }
            }
        }
    }
}

