/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.Assertion;
import com.saxonica.schema.AttributeGroupReference;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.AttributeWildcard;
import com.saxonica.schema.ElementWildcard;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.Wildcard;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.XSDAnyAttribute;
import com.saxonica.schema.sdoc.XSDAssert;
import com.saxonica.schema.sdoc.XSDAttribute;
import com.saxonica.schema.sdoc.XSDAttributeGroup;
import com.saxonica.schema.sdoc.XSDCompositor;
import com.saxonica.schema.sdoc.XSDGroup;
import com.saxonica.schema.sdoc.XSDOpenContent;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;

public class XSDComplexContentRestriction
extends SchemaElement {
    private UserComplexType complexType = null;
    private static final int[] state0terms = new int[]{586, 619, 582, 612, 578, 585, 580, 576, 584, 596};
    private static final int[] state0targets = new int[]{2, 2, 6, 4, 5, 1, 3, 2, 1, 2};
    private static final int[] state1terms = new int[]{584, 585, 580, 582};
    private static final int[] state1targets = new int[]{1, 1, 3, 6};
    private static final int[] state2terms = new int[]{584, 585, 580, 582};
    private static final int[] state2targets = new int[]{1, 1, 3, 6};
    private static final int[] state3terms = new int[]{582};
    private static final int[] state3targets = new int[]{6};
    private static final int[] state4terms = new int[]{596, 586, 576, 619};
    private static final int[] state4targets = new int[]{2, 2, 2, 2};
    private static final int[] state5terms = new int[]{586, 619, 582, 612, 585, 580, 576, 584, 596};
    private static final int[] state5targets = new int[]{2, 2, 6, 4, 1, 3, 2, 1, 2};
    private static final int[] state6terms = new int[]{582};
    private static final int[] state6targets = new int[]{6};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms, state4terms, state5terms, state6terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets, state4targets, state5targets, state6targets};

    public void prepareAttributes() throws SchemaException {
        try {
            this.complexType = this.getContainingComplexType();
        }
        catch (SchemaException e) {
            e.setLocator(this);
            this.error(e);
            return;
        }
        this.complexType.setDerivationMethodName("restriction");
        this.complexType.setRestriction(true);
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"base", "id"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String base = atts.getValue("", "base");
        if (base != null) {
            int baseFingerprint;
            try {
                baseFingerprint = this.getFingerprint(base, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            if (baseFingerprint == 634 || baseFingerprint == 633) {
                this.warning("Type " + base + " is recognized by Saxon but is not interoperable");
            } else if (baseFingerprint == 632 || baseFingerprint == 630) {
                this.error("Type " + base + " cannot be used as a base type");
            }
            TypeReference baseType = new TypeReference(baseFingerprint, (EnterpriseConfiguration)this.getConfiguration(), this);
            this.complexType.setBaseTypeReference(baseType);
        }
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        this.checkContentModel(stateTerms, stateTargets, false);
    }

    protected boolean isFinalState(int state) {
        return true;
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        if (this.complexType == null) {
            return;
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 580: {
                    AttributeWildcard wildcard = ((XSDAnyAttribute)child).getWildcard();
                    this.complexType.setAnyAttribute(wildcard);
                    break;
                }
                case 584: {
                    AttributeUse attrDecl = ((XSDAttribute)child).getAttributeUse();
                    this.complexType.addAttributeUse(attrDecl);
                    break;
                }
                case 585: {
                    AttributeGroupReference attrGroupRef = ((XSDAttributeGroup)child).getAttributeGroupReference();
                    this.complexType.addAttributeGroupReference(attrGroupRef);
                    break;
                }
                case 576: 
                case 586: 
                case 619: {
                    this.complexType.setParticle(((XSDCompositor)child).getModelGroupParticle());
                    break;
                }
                case 596: {
                    ModelGroupParticle modelGroup = ((XSDGroup)child).getGroupReference();
                    this.complexType.setParticle(modelGroup);
                    break;
                }
                case 582: {
                    Assertion assertion = ((XSDAssert)child).getAssertion();
                    this.complexType.addAssertion(assertion);
                    break;
                }
                case 612: {
                    ElementWildcard ew = ((XSDOpenContent)child).getElementWildcard();
                    Wildcard openContentWildcard = ew == null ? null : ew.getWildcard();
                    String openContentMode = ((XSDOpenContent)child).getMode();
                    this.complexType.setOpenContentWildcard(openContentWildcard, openContentMode, true);
                    break;
                }
            }
        }
    }
}

