/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.schema.sdoc.XSDComplexType;
import com.saxonica.schema.sdoc.XSDSimpleType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.UntypedAtomicValue;

public class XSDAttribute
extends SchemaElement {
    private AttributeDecl attributeDecl = null;
    private AttributeUse attributeUse = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean typeSpecified = false;
    private boolean isReference = false;

    public void prepareAttributes() throws SchemaException {
        String inheritAtt;
        int nc;
        String attValue;
        String localTargetNamespace;
        String[] allowed;
        AttributeCollection atts = this.getAttributeList();
        if (this.isTopLevel()) {
            allowed = new String[]{"default", "fixed", "id", "inheritable", "name", "type"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
        } else {
            allowed = new String[]{"default", "fixed", "form", "id", "inheritable", "name", "ref", "targetNamespace", "type", "use"};
            this.allowAttributes(atts, allowed);
        }
        this.isReference = atts.getValue("", "ref") != null;
        String form = atts.getValue("", "form");
        if (form != null) {
            if (this.isReference) {
                this.mutuallyExclusiveAttributes("form", "ref");
            }
            if (!form.equals("qualified") && !form.equals("unqualified")) {
                this.invalidAttributeValue("form", form, "Must be 'qualified' or 'unqualified'");
                form = "qualified";
            }
        } else if (this.isTopLevel()) {
            form = "qualified";
        } else {
            form = this.getXSDSchema().getAttributeFormDefault();
            if (form == null) {
                form = "unqualified";
            }
        }
        if ((localTargetNamespace = atts.getValue("", "targetNamespace")) != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The targetNamespace cannot be defined locally unless XSD 1.1 is enabled");
            }
            if (atts.getValue("", "name") == null) {
                this.error("If there is no @name then there must be no @targetNamespace");
            }
            this.checkMutuallyExclusiveAttributes("targetNamespace", "form");
        }
        if ((attValue = atts.getValue("", "name")) != null) {
            this.attributeDecl = new AttributeDecl((EnterpriseConfiguration)this.getConfiguration(), this.isTopLevel());
            this.attributeDecl.setLocator(this);
            if (attValue.equals("xmlns")) {
                this.error("The attribute name 'xmlns' is reserved");
            }
            if (atts.getValue("", "ref") != null) {
                this.mutuallyExclusiveAttributes("name", "ref");
            } else {
                try {
                    if (localTargetNamespace != null || "qualified".equals(form)) {
                        if (this.getXSDSchema().getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                            this.error("Attributes cannot be declared in the 'xsi:' namespace");
                        }
                        nc = this.getNameCode(attValue, 1);
                    } else {
                        nc = this.getNameCode(attValue, 2);
                    }
                }
                catch (SchemaException err) {
                    this.error(err.getMessage());
                    nc = 574;
                }
                this.attributeDecl.setNameCode(nc);
            }
            if (!this.isTopLevel()) {
                this.attributeUse = new AttributeUse((EnterpriseConfiguration)this.getConfiguration());
                this.attributeUse.setNameCode(this.attributeDecl.getNameCode());
                this.attributeUse.setTarget(this.attributeDecl);
                this.attributeUse.setLocator(this);
            }
        }
        if ((attValue = atts.getValue("", "ref")) != null) {
            this.attributeUse = new AttributeUse((EnterpriseConfiguration)this.getConfiguration());
            this.attributeUse.setLocator(this);
            nc = -1;
            try {
                nc = this.getNameCode(attValue, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
            }
            this.attributeUse.setNameCode(nc);
        }
        if ((attValue = atts.getValue("", "default")) != null) {
            if (this.attributeUse != null) {
                this.attributeUse.setDefaultValue(attValue);
            } else if (this.attributeDecl != null) {
                this.attributeDecl.setDefaultValue(attValue);
            }
        }
        this.processId();
        attValue = atts.getValue("", "fixed");
        if (attValue != null) {
            if (atts.getValue("", "default") != null) {
                this.mutuallyExclusiveAttributes("fixed", "default");
            }
            if (this.attributeDecl != null) {
                this.attributeDecl.setFixedValue(new UntypedAtomicValue(attValue));
            } else if (this.attributeUse != null) {
                this.attributeUse.setFixedValue(new UntypedAtomicValue(attValue));
            }
        }
        attValue = atts.getValue("", "type");
        int typeFingerprint = -1;
        if (attValue == null) {
            if (this.attributeDecl != null) {
                this.attributeDecl.setSimpleType(AnySimpleType.getInstance());
            }
        } else {
            this.typeSpecified = true;
            if (this.isReference) {
                this.mutuallyExclusiveAttributes("type", "ref");
                return;
            }
            try {
                typeFingerprint = this.getFingerprint(attValue, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            this.checkPermittedType(typeFingerprint, attValue, "an attribute type");
            if (this.attributeDecl != null) {
                this.attributeDecl.setTypeReference(new TypeReference(typeFingerprint, this.getSchema().getConfiguration(), this));
            }
        }
        if ((attValue = atts.getValue("", "use")) != null) {
            int useFlag;
            boolean hasDefault;
            boolean bl = hasDefault = atts.getValue("", "default") != null;
            if (hasDefault && !attValue.equals("optional")) {
                this.error("When @default is present, the @use attribute must have the value \"optional\"");
                attValue = "optional";
            }
            if (attValue.equals("required")) {
                useFlag = 5;
            } else if (attValue.equals("optional")) {
                useFlag = 3;
            } else if (attValue.equals("prohibited")) {
                useFlag = 4;
            } else {
                this.invalidAttributeValue("use", attValue, "Must be required|optional|prohibited");
                useFlag = 3;
            }
            if (this.attributeUse != null) {
                this.attributeUse.setUse((short)useFlag);
            }
        }
        if ((inheritAtt = atts.getValue("", "inheritable")) != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The inheritable attribute cannot be used unless XSD 1.1 is enabled");
            }
            boolean inherit = this.parseBooleanAttribute("inheritable", inheritAtt);
            if (this.attributeUse != null) {
                this.attributeUse.setInheritable(inherit ? 1 : 0);
            }
            if (this.attributeDecl != null) {
                this.attributeDecl.setInheritable(inherit);
            }
        }
        if (atts.getValue("", "fixed") != null || atts.getValue("", "default") != null) {
            SchemaType type;
            boolean needResolver = true;
            if (this.typeSpecified && typeFingerprint < 1024 && (type = BuiltInType.getSchemaType(typeFingerprint)) instanceof SimpleType && !((SimpleType)type).isNamespaceSensitive()) {
                needResolver = false;
            }
            if (needResolver) {
                if (this.attributeDecl != null) {
                    this.attributeDecl.setNamespaceResolver(new InscopeNamespaceResolver(this));
                }
                if (this.attributeUse != null) {
                    this.attributeUse.setNamespaceResolver(new InscopeNamespaceResolver(this));
                }
            }
        }
    }

    public AttributeDecl getAttributeDeclaration() {
        return this.attributeDecl;
    }

    public AttributeUse getAttributeUse() {
        return this.attributeUse;
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        String localTargetNamespace = this.getAttributeValue("", "targetNamespace");
        if (localTargetNamespace != null && !localTargetNamespace.equals(this.getXSDSchema().getTargetNamespace())) {
            this.checkLocalTargetNamespace("attribute");
        }
        if (this.attributeDecl != null) {
            NodeInfo anc;
            AxisIterator ancIter = this.iterateAxis((byte)0);
            while ((anc = (NodeInfo)ancIter.next()) != null) {
                if (!(anc instanceof XSDComplexType)) continue;
                this.attributeDecl.setContainingComplexType(((XSDComplexType)anc).getComplexType());
                break;
            }
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            int fp = child.getFingerprint();
            if (fp == 578) {
                if (this.foundAnnotation) {
                    this.duplicateElement("annotation");
                }
                if (this.foundSimpleType) {
                    this.mustBeFirstElement("annotation");
                }
                this.foundAnnotation = true;
                continue;
            }
            if (fp == 621) {
                if (this.typeSpecified) {
                    this.mutuallyExclusiveElementAndAttribute("simpleType", "type");
                }
                if (this.isReference) {
                    this.mutuallyExclusiveElementAndAttribute("simpleType", "ref");
                }
                if (this.foundSimpleType) {
                    this.duplicateElement("simpleType");
                }
                this.foundSimpleType = true;
                continue;
            }
            this.illegalElement(child);
        }
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            int fp = child.getFingerprint();
            if (fp != 621 || this.attributeDecl == null) continue;
            SimpleTypeDefinition simpleTypeDef = ((XSDSimpleType)child).getSimpleTypeDefinition();
            TypeReference ref = new TypeReference(simpleTypeDef.getFingerprint(), this.getSchema().getConfiguration(), this);
            this.attributeDecl.setTypeReference(ref);
            simpleTypeDef.setContainingDeclaration(this.attributeDecl.getFingerprint(), false);
        }
    }
}

