/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.Assertion;
import com.saxonica.schema.sdoc.AnnotationParent;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.XSDSimpleContent;
import com.saxonica.schema.sdoc.XSDSimpleType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class XSDAssert
extends AnnotationParent {
    private Assertion assertion = null;

    public void prepareAttributes() throws SchemaException {
        XPathExpression condition;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "test", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String defaultNamespace = atts.getValue("", "xpathDefaultNamespace");
        if (defaultNamespace == null) {
            defaultNamespace = this.getXSDSchema().getXPathDefaultNamespace();
        }
        if (defaultNamespace.equals("##defaultNamespace")) {
            defaultNamespace = this.getURIForPrefix("", true);
        } else if (defaultNamespace.equals("##targetNamespace")) {
            defaultNamespace = this.getXSDSchema().getTargetNamespace();
        } else if (defaultNamespace.equals("##local")) {
            defaultNamespace = "";
        }
        String xpath = atts.getValue("", "test");
        if (xpath == null) {
            this.missingAttribute("test");
            xpath = ".";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this.getConfiguration());
        env.setDefaultElementNamespace(defaultNamespace);
        env.setNamespaceResolver(this.makeNamespaceContext());
        env.setBaseURI(this.getBaseURI());
        XPathVariable valueVariable = null;
        boolean isSimple = false;
        NodeInfo anc = this;
        while ((anc = anc.getParent()) != null) {
            if (!(anc instanceof XSDSimpleType) && !(anc instanceof XSDSimpleContent)) continue;
            isSimple = true;
            break;
        }
        if (isSimple) {
            valueVariable = env.declareVariable("", "value");
        }
        XPathEvaluator xpe = new XPathEvaluator(this.getSchema().getConfiguration());
        try {
            xpe.setStaticContext(env);
            condition = xpe.createExpression(xpath);
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            try {
                condition = xpe.createExpression("false()");
            }
            catch (XPathException e2) {
                throw new AssertionError((Object)e2.getMessage());
            }
        }
        this.assertion = new Assertion(this.getSchema().getConfiguration(), condition, valueVariable, xpath);
        this.assertion.setStaticContext(env);
        String message = atts.getValue("http://saxon.sf.net/", "message");
        this.assertion.setMessage(message);
        this.processId();
    }

    public Assertion getAssertion() {
        return this.assertion;
    }
}

