/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.EnumerationFacet;
import com.saxonica.schema.Facet;
import com.saxonica.schema.LengthFacet;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.schema.UserUnionType;
import java.util.ArrayList;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaException;

public class XMLNamespaceSchema {
    public static PreparedSchema buildSchema(EnterpriseConfiguration config) {
        SingleNamespaceSchema schema = new SingleNamespaceSchema(config, "http://www.w3.org/XML/1998/namespace");
        ArrayList<TypeReference> members = new ArrayList<TypeReference>(2);
        members.add(new TypeReference(555, config, null));
        UserAtomicType zls = new UserAtomicType(config);
        zls.setBaseTypeReference(new TypeReference(513, config, null));
        zls.setNameCode(config.getNamePool().allocate("saxon", "http://saxon.sf.net/", "zero-length-string"));
        schema.addType(zls);
        ArrayList<Facet> facetList = new ArrayList<Facet>(1);
        LengthFacet lengthFacet = new LengthFacet();
        lengthFacet.setNumericValue(0);
        facetList.add(lengthFacet);
        zls.setFacetList(facetList);
        members.add(new TypeReference(zls.getFingerprint(), config, null));
        UserUnionType u = new UserUnionType(config);
        u.setMemberTypeReferences(members);
        u.setNameCode(389);
        AttributeDecl xmlLang = new AttributeDecl(schema.getConfiguration(), true);
        xmlLang.setNameCode(387);
        xmlLang.setSimpleType(u);
        schema.addAttributeDecl(xmlLang);
        UserAtomicType sp = new UserAtomicType(config);
        sp.setBaseTypeReference(new TypeReference(559, config, null));
        facetList = new ArrayList(1);
        EnumerationFacet defaultFacet = new EnumerationFacet();
        defaultFacet.setValue("default");
        EnumerationFacet preserveFacet = new EnumerationFacet();
        preserveFacet.setValue("preserve");
        facetList.add(defaultFacet);
        facetList.add(preserveFacet);
        sp.setFacetList(facetList);
        try {
            sp.mergeEnumerationFacets(null);
        }
        catch (SchemaException err) {
            throw new AssertionError((Object)err.getMessage());
        }
        AttributeDecl xmlSpace = new AttributeDecl(schema.getConfiguration(), true);
        xmlSpace.setNameCode(386);
        xmlSpace.setSimpleType(sp);
        schema.addAttributeDecl(xmlSpace);
        AttributeDecl xmlBase = new AttributeDecl(schema.getConfiguration(), true);
        xmlBase.setNameCode(385);
        xmlBase.setSimpleType(BuiltInAtomicType.ANY_URI);
        schema.addAttributeDecl(xmlBase);
        AttributeDecl xmlId = new AttributeDecl(schema.getConfiguration(), true);
        xmlId.setNameCode(388);
        xmlId.setSimpleType(BuiltInAtomicType.ID);
        schema.addAttributeDecl(xmlId);
        return schema;
    }
}

