/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.sdoc.AnnotationParent;
import com.saxonica.schema.sdoc.SchemaElement;
import java.io.Serializable;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class SaxonParam
extends AnnotationParent {
    public void prepareAttributes() throws SchemaException {
        String select;
        if (this.getParent().getFingerprint() != 581) {
            this.error("The saxon:param element is allowed only as a child of xs:appinfo");
        }
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"as", "name", "select"};
        this.allowAttributes(atts, allowed);
        this.requireAttribute(atts, "name");
        String name = atts.getValue("", "name");
        StructuredQName qName = this.makeQName(name);
        String as = atts.getValue("", "as");
        if (as == null) {
            as = "item()*";
        }
        if ((select = atts.getValue("", "select")) == null) {
            select = "()";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this, this.getConfiguration());
        env.setNamespaceResolver(this.makeNamespaceContext());
        env.setBaseURI(this.getBaseURI());
        SequenceType requiredType = this.makeSequenceType(as, env);
        ValueRepresentation defaultValue = EmptySequence.getInstance();
        try {
            Expression expr = ExpressionTool.make(select, env, env, 0, 0, this.getLineNumber(), false);
            expr.setContainer(env);
            RoleLocator role = new RoleLocator(8, (Serializable)((Object)name), 0);
            ExpressionVisitor visitor = ExpressionVisitor.make(env, env.getExecutable());
            ItemType contextItemType = Type.ITEM_TYPE;
            expr = visitor.typeCheck(expr, contextItemType);
            expr = TypeChecker.staticTypeCheck(expr, requiredType, false, role, visitor);
            SlotManager stackFrameMap = this.getConfiguration().makeSlotManager();
            ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
            Controller controller = new Controller(this.getConfiguration());
            XPathContextMajor dynamicContext = controller.newXPathContext();
            dynamicContext = dynamicContext.newCleanContext();
            dynamicContext.openStackFrame(stackFrameMap);
            defaultValue = SequenceExtent.makeSequenceExtent(expr.iterate(dynamicContext));
        }
        catch (XPathException e) {
            this.error(e.getMessage());
        }
        GlobalParam param = new GlobalParam();
        param.setVariableQName(qName);
        param.setRequiredType(requiredType);
        param.setSelectExpression(new Literal(Value.asValue(defaultValue)));
        this.getXSDSchema().addGlobalParam(param);
    }

    public SequenceType makeSequenceType(String sequenceType, StaticContext env) throws SchemaException {
        try {
            ExpressionParser parser = new ExpressionParser();
            parser.setLanguage(0, DecimalValue.TWO);
            return parser.parseSequenceType(sequenceType, env);
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            return SequenceType.ANY_SEQUENCE;
        }
    }

    public final StructuredQName makeQName(String lexicalQName) throws SchemaException {
        StructuredQName qName;
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, false, this.getConfiguration().getNameChecker(), this);
        }
        catch (XPathException e) {
            e.setIsStaticError(true);
            String code = e.getErrorCodeLocalPart();
            if ("FONS0004".equals(code)) {
                e.setErrorCode("XTSE0280");
            } else if ("FOCA0002".equals(code)) {
                e.setErrorCode("XTSE0020");
            } else if (code == null) {
                e.setErrorCode("XTSE0020");
            }
            throw new SchemaException(e);
        }
        return qName;
    }
}

