/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.fsa;

import com.saxonica.schema.AllModelGroup;
import com.saxonica.schema.ChoiceModelGroup;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.ModelGroupDefinition;
import com.saxonica.schema.Particle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SequenceModelGroup;
import com.saxonica.schema.Term;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.Wildcard;
import com.saxonica.schema.fsa.AutomatonState;
import com.saxonica.schema.fsa.DeterminizedState;
import com.saxonica.schema.fsa.Edge;
import com.saxonica.schema.fsa.NonDeterminizedState;
import com.saxonica.schema.fsa.State;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntRangeSet;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiniteStateMachine
implements Serializable {
    private int statesUsed = 0;
    private AutomatonState initialState;
    private AutomatonState[] states = new AutomatonState[20];
    private Set<TermParticlePair> alphabet = new HashSet<TermParticlePair>(20);
    private Wildcard openContentWildcard = null;
    private boolean openContentInterleaved = false;
    private UserComplexType complexType;

    public FiniteStateMachine(UserComplexType type, boolean determinized) {
        this.complexType = type;
        this.initialState = determinized ? new DeterminizedState(this) : new NonDeterminizedState(this);
    }

    public void allocateStateNumber(AutomatonState state) {
        if (this.statesUsed > this.states.length - 1) {
            AutomatonState[] a2 = new AutomatonState[this.statesUsed * 2];
            System.arraycopy(this.states, 0, a2, 0, this.statesUsed);
            this.states = a2;
        }
        this.states[this.statesUsed] = state;
        state.stateNumber = this.statesUsed++;
    }

    public int getNumberOfStates() {
        return this.statesUsed;
    }

    public AutomatonState getInitialState() {
        return this.initialState;
    }

    public void setInitialState(AutomatonState initialState) {
        this.initialState = initialState;
    }

    public AutomatonState getState(int number) {
        return this.states[number];
    }

    public void setOpenContentWildcard(Wildcard wildcard, boolean interleaved) {
        this.openContentWildcard = wildcard;
        this.openContentInterleaved = interleaved;
    }

    public static NonDeterminizedState compileParticle(SchemaCompiler compiler, Particle particle, NonDeterminizedState endState, UserComplexType subjectType, FiniteStateMachine machine) throws SchemaException, UnresolvedReferenceException {
        NonDeterminizedState n = endState;
        int max = particle.getMaxOccurs();
        int min = particle.getMinOccurs();
        if (!(!(particle.getTerm() instanceof ElementDecl) && !(particle.getTerm() instanceof Wildcard) || min <= 1 && max <= 1 || min != max && particle.isVulnerable())) {
            NonDeterminizedState t = new NonDeterminizedState(machine);
            FiniteStateMachine.compileCountingTerm(particle, t, min, max, subjectType, compiler, machine);
            if (min == max) {
                Edge leavingEdge = new Edge();
                leavingEdge.setTerm(Edge.MaxOccursTerm.getInstance());
                leavingEdge.setTargetState(n);
                t.setMaxTransition(leavingEdge);
                t.setFinalState(n.isFinalState());
                machine.alphabet.add(new TermParticlePair(Edge.MaxOccursTerm.getInstance(), Edge.MAX_OCCURS_PARTICLE));
            } else {
                t.addLambdaTransition(n);
            }
            NonDeterminizedState start = FiniteStateMachine.compileTerm(compiler, particle, t, subjectType, machine);
            if (min == 0) {
                start.addLambdaTransition(n);
            }
            return start;
        }
        int[] limits = compiler.getOccurrenceLimits();
        if (max > limits[1]) {
            compiler.warning("maxOccurs value of " + max + " treated as unbounded", subjectType);
            max = -1;
        }
        if (min > limits[0]) {
            compiler.warning("minOccurs value of " + min + " treated as " + limits[0], subjectType);
            min = limits[0];
        }
        if (max == -1) {
            NonDeterminizedState t = new NonDeterminizedState(machine);
            NonDeterminizedState b = FiniteStateMachine.compileTerm(compiler, particle, t, subjectType, machine);
            b.addLambdaTransition(n);
            t.addLambdaTransition(b);
            n = b;
        } else if (!(particle.getTerm() instanceof AllModelGroup)) {
            int count = max - min;
            for (int i = 0; i < count; ++i) {
                NonDeterminizedState b = FiniteStateMachine.compileTerm(compiler, particle, n, subjectType, machine);
                b.addLambdaTransition(endState);
                n = b;
            }
        }
        int count = min;
        for (int i = 0; i < count; ++i) {
            n = FiniteStateMachine.compileTerm(compiler, particle, n, subjectType, machine);
        }
        return n;
    }

    private static NonDeterminizedState compileTerm(SchemaCompiler compiler, Particle particle, NonDeterminizedState endState, UserComplexType subjectType, FiniteStateMachine machine) throws SchemaException, UnresolvedReferenceException {
        Term term = particle.getTerm();
        if (term instanceof Wildcard) {
            machine.alphabet.add(new TermParticlePair(term, particle));
            NonDeterminizedState b = new NonDeterminizedState(machine);
            Edge edge = new Edge();
            edge.setTerm(term);
            edge.setParticle(particle);
            edge.setTargetState(endState);
            b.addWildcardTransition(compiler, edge);
            return b;
        }
        if (term instanceof ElementDecl) {
            machine.alphabet.add(new TermParticlePair(term, particle));
            NonDeterminizedState b = new NonDeterminizedState(machine);
            Edge edge = new Edge();
            edge.setTerm(term);
            edge.setParticle(particle);
            edge.setTargetState(endState);
            b.addSpecificTransition(edge, compiler);
            int fp = ((ElementDecl)term).getFingerprint();
            Iterator<ElementDecl> iter = ((ElementDecl)term).iterateSubstitutionGroup();
            while (iter.hasNext()) {
                ElementDecl elem = iter.next();
                if (elem.getFingerprint() != fp) {
                    edge = new Edge();
                    edge.setTerm(elem);
                    machine.alphabet.add(new TermParticlePair(elem, particle));
                    edge.setParticle(particle);
                    edge.setTargetState(endState);
                    b.addSpecificTransition(edge, compiler);
                }
                elem.registerComplexTypeUsingThisElement(subjectType);
            }
            return b;
        }
        if (term instanceof ChoiceModelGroup || term instanceof AllModelGroup) {
            NonDeterminizedState b = new NonDeterminizedState(machine);
            Iterator<Particle> parts = ((ModelGroup)term).iterateParticles();
            while (parts.hasNext()) {
                NonDeterminizedState c = FiniteStateMachine.compileParticle(compiler, parts.next(), endState, subjectType, machine);
                b.addLambdaTransition(c);
            }
            return b;
        }
        if (term instanceof SequenceModelGroup || term instanceof ModelGroupDefinition) {
            NonDeterminizedState n = endState;
            Iterator<Particle> parts = ((ModelGroup)term).iterateParticles();
            ArrayList<Particle> particleList = new ArrayList<Particle>(10);
            while (parts.hasNext()) {
                particleList.add(0, parts.next());
            }
            parts = particleList.iterator();
            while (parts.hasNext()) {
                n = FiniteStateMachine.compileParticle(compiler, parts.next(), n, subjectType, machine);
            }
            return n;
        }
        throw new IllegalStateException("Unknown type of term " + term.getClass());
    }

    private static void compileCountingTerm(Particle particle, NonDeterminizedState countingState, int min, int max, UserComplexType subjectType, SchemaCompiler compiler, FiniteStateMachine machine) throws SchemaException, UnresolvedReferenceException {
        Term term = particle.getTerm();
        machine.alphabet.add(new TermParticlePair(term, particle));
        Edge edge = new Edge();
        edge.setTerm(term);
        edge.setParticle(particle);
        edge.setTargetState(countingState);
        countingState.setLimits(min, max);
        if (term instanceof ElementDecl) {
            countingState.addSpecificTransition(edge, compiler);
            int fp = ((ElementDecl)term).getFingerprint();
            Iterator<ElementDecl> iter = ((ElementDecl)term).iterateSubstitutionGroup();
            while (iter.hasNext()) {
                ElementDecl elem = iter.next();
                if (elem.getFingerprint() != fp) {
                    machine.alphabet.add(new TermParticlePair(elem, particle));
                    edge = new Edge();
                    edge.setParticle(particle);
                    edge.setTerm(elem);
                    edge.setTargetState(countingState);
                    countingState.addSpecificTransition(edge, compiler);
                }
                elem.registerComplexTypeUsingThisElement(subjectType);
            }
        } else {
            countingState.addWildcardTransition(compiler, edge);
        }
    }

    public void display(PrintStream err) {
        err.println("Initial state: " + this.initialState.stateNumber);
        for (int i = this.statesUsed - 1; i >= 0; --i) {
            this.states[i].displayState(err);
        }
    }

    public static String subsumesMachine(FiniteStateMachine base, FiniteStateMachine sub, SchemaCompiler compiler) {
        ArrayList<State[]> unprocessed = new ArrayList<State[]>(30);
        ArrayList<State[]> processed = new ArrayList<State[]>(30);
        HashSet<State> finalDerivedStates = new HashSet<State>(30);
        if (sub.initialState.isFinalState() && sub.initialState.getMinOccurs() <= 0) {
            finalDerivedStates.add(sub.initialState);
            if (!base.initialState.isFinalState() || sub.initialState.getMinOccurs() > 0) {
                return "The derived type permits empty content, but the base type does not";
            }
        }
        State[] initialPair = new State[]{base.getInitialState(), sub.getInitialState()};
        unprocessed.add(initialPair);
        while (!unprocessed.isEmpty()) {
            State[] p = (State[])unprocessed.get(0);
            State baseState = p[0];
            State derivedState = p[1];
            Iterator<Edge> derivedEdges = derivedState.getEdges();
            while (derivedEdges.hasNext()) {
                int i;
                State[] end;
                State newDerivedState;
                Edge derivedEdge = derivedEdges.next();
                try {
                    newDerivedState = derivedEdge.makeTransition(derivedState);
                }
                catch (ValidationException e) {
                    throw new AssertionError((Object)"Invalid derived transition");
                }
                if (newDerivedState.isFinalState()) {
                    finalDerivedStates.add(newDerivedState);
                }
                Edge baseEdge = null;
                if (derivedEdge.getTerm() instanceof ElementDecl) {
                    baseEdge = baseState.getTransition(((ElementDecl)derivedEdge.getTerm()).getFingerprint(), base.complexType);
                    String s = "No match";
                    if (baseEdge != null) {
                        s = baseEdge.matches(derivedEdge, compiler);
                    }
                    if (s != null) {
                        if (s.equals("No match")) {
                            return "Restricted type allows element " + compiler.getNamePool().getDisplayName(((ElementDecl)derivedEdge.getTerm()).getFingerprint()) + " where the base type does not";
                        }
                        if (s.equals("Not final")) {
                            return "Restricted type allows the content to finish after element " + compiler.getNamePool().getDisplayName(((ElementDecl)derivedEdge.getTerm()).getFingerprint()) + " where the base type does not";
                        }
                        return "Definition of element " + compiler.getNamePool().getDisplayName(((ElementDecl)derivedEdge.getTerm()).getFingerprint()) + " differs between the restricted type and the base type. " + s;
                    }
                } else {
                    Edge[] baseEdges = baseState.getWildcardEdges();
                    boolean foundWildcard = false;
                    String s = null;
                    for (int e = 0; e < baseEdges.length; ++e) {
                        baseEdge = baseEdges[e];
                        s = baseEdge.matches(derivedEdge, compiler);
                        if (s != null) continue;
                        foundWildcard = true;
                        break;
                    }
                    if (!foundWildcard) {
                        return "Restricted type allows xs:any content that is not allowed by the base type. " + s;
                    }
                }
                boolean foundExistingPair = false;
                try {
                    end = new State[]{baseEdge.makeTransition(baseState), newDerivedState};
                }
                catch (ValidationException e) {
                    return "Occurrence limits on restricted type exceed those on base type";
                }
                for (i = 0; i < unprocessed.size(); ++i) {
                    State[] s = (State[])unprocessed.get(i);
                    if (!s[0].equals(end[0]) || !s[1].equals(end[1])) continue;
                    foundExistingPair = true;
                    break;
                }
                for (i = 0; i < processed.size(); ++i) {
                    State[] s = (State[])processed.get(i);
                    if (!s[0].equals(end[0]) || !s[1].equals(end[1])) continue;
                    foundExistingPair = true;
                    break;
                }
                if (foundExistingPair) continue;
                unprocessed.add(end);
            }
            unprocessed.remove(0);
            processed.add(p);
        }
        for (State e : finalDerivedStates) {
            Iterator processedPairIterator = processed.iterator();
            boolean unfound = false;
            while (processedPairIterator.hasNext()) {
                State[] pair = (State[])processedPairIterator.next();
                if (!pair[1].equals(e) || pair[0].isFinalState()) continue;
                unfound = true;
                break;
            }
            if (!unfound) continue;
            return "Restricted type allows a final state that is not allowed by the base type";
        }
        return null;
    }

    public static FiniteStateMachine determinize(SchemaCompiler compiler, FiniteStateMachine nfsa) throws SchemaException {
        FiniteStateMachine dfsa = new FiniteStateMachine(nfsa.complexType, true);
        dfsa.setOpenContentWildcard(nfsa.openContentWildcard, nfsa.openContentInterleaved);
        HashSet<DeterminizedState> unmarkedStatesOfD = new HashSet<DeterminizedState>(20);
        HashMap<IntSet, DeterminizedState> statesOfD = new HashMap<IntSet, DeterminizedState>(20);
        DeterminizedState initialD = (DeterminizedState)dfsa.getInitialState();
        initialD.setProvenance(FiniteStateMachine.lambdaClosure(new MonoIterator(nfsa.getInitialState())));
        initialD.setFinalState(FiniteStateMachine.containsFinalState(nfsa, initialD.getProvenance()));
        initialD.setLimits(nfsa.getInitialState().getMinOccurs(), nfsa.getInitialState().getMaxOccurs());
        unmarkedStatesOfD.add(initialD);
        statesOfD.put(initialD.getProvenance(), initialD);
        while (!unmarkedStatesOfD.isEmpty()) {
            DeterminizedState x = (DeterminizedState)unmarkedStatesOfD.iterator().next();
            unmarkedStatesOfD.remove(x);
            for (TermParticlePair pair : nfsa.alphabet) {
                Particle particle = pair.particle;
                Term a = pair.term;
                Set<AutomatonState> T = x.reachableStates(pair, nfsa);
                if (T.isEmpty()) continue;
                IntSet key = FiniteStateMachine.lambdaClosure(T.iterator());
                DeterminizedState dy = (DeterminizedState)statesOfD.get(key);
                if (dy == null) {
                    dy = new DeterminizedState(dfsa);
                    dy.setProvenance(key);
                    dy.setFinalState(FiniteStateMachine.containsFinalState(nfsa, key));
                    int[] limits = FiniteStateMachine.getOccurrenceLimits(nfsa, key);
                    dy.setLimits(limits[0], limits[1]);
                    unmarkedStatesOfD.add(dy);
                    statesOfD.put(key, dy);
                }
                x.addEdge(compiler, a, particle, dy);
            }
        }
        for (int i = dfsa.getNumberOfStates() - 1; i >= 0; --i) {
            ((DeterminizedState)dfsa.getState(i)).setProvenance(null);
        }
        return dfsa;
    }

    private static boolean containsFinalState(FiniteStateMachine machine, IntSet states) {
        IntIterator i = states.iterator();
        while (i.hasNext()) {
            int state = i.next();
            if (!machine.getState(state).isConditionallyFinalState()) continue;
            return true;
        }
        return false;
    }

    private static int[] getOccurrenceLimits(FiniteStateMachine machine, IntSet states) {
        IntIterator i = states.iterator();
        while (i.hasNext()) {
            int state = i.next();
            AutomatonState aState = machine.getState(state);
            if (aState.getMinOccurs() == -1) continue;
            return new int[]{aState.getMinOccurs(), aState.getMaxOccurs()};
        }
        return new int[]{-1, -1};
    }

    public Wildcard getOpenContentWildcard() {
        return this.openContentWildcard;
    }

    public boolean isOpenContentInterleaved() {
        return this.openContentInterleaved;
    }

    private static IntSet lambdaClosure(Iterator<AutomatonState> T_iter) {
        Stack<AutomatonState> stack = new Stack<AutomatonState>();
        IntRangeSet result = new IntRangeSet();
        while (T_iter.hasNext()) {
            NonDeterminizedState state = (NonDeterminizedState)T_iter.next();
            result.add(state.stateNumber);
            stack.push(state);
        }
        while (!stack.isEmpty()) {
            NonDeterminizedState s = (NonDeterminizedState)stack.pop();
            if (s.getLambdaTransitions() == null) continue;
            for (AutomatonState t : s.getLambdaTransitions()) {
                if (!result.add(t.stateNumber)) continue;
                stack.push(t);
            }
        }
        return result;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("finiteStateMachine");
        serializer.emitAttribute("initialState", this.initialState.getStateNumber() + "");
        for (int s = 0; s < this.statesUsed; ++s) {
            this.states[s].serialize(serializer);
        }
        serializer.endElement();
    }

    protected static class TermParticlePair {
        public Term term;
        public Particle particle;

        public TermParticlePair(Term t, Particle p) {
            this.term = t;
            this.particle = p;
        }

        public boolean equals(Object obj) {
            return obj instanceof TermParticlePair && this.term == ((TermParticlePair)obj).term && this.particle == ((TermParticlePair)obj).particle;
        }

        public int hashCode() {
            return this.term.hashCode() ^ this.particle.hashCode();
        }
    }
}

