/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.fsa;

import com.saxonica.schema.Term;
import com.saxonica.schema.fsa.AutomatonState;
import com.saxonica.schema.fsa.Edge;
import com.saxonica.schema.fsa.FiniteStateMachine;
import com.saxonica.schema.fsa.NonDeterminizedState;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeterminizedState
extends AutomatonState {
    private transient IntSet provenance = null;

    public DeterminizedState(FiniteStateMachine machine) {
        super(machine);
    }

    public void setProvenance(IntSet provenance) {
        this.provenance = provenance;
    }

    public IntSet getProvenance() {
        return this.provenance;
    }

    Set originalTerms(FiniteStateMachine nfsa) {
        HashSet<Term> terms = new HashSet<Term>(10);
        IntIterator p = this.provenance.iterator();
        while (p.hasNext()) {
            NonDeterminizedState orig = (NonDeterminizedState)nfsa.getState(p.next());
            Iterator<Edge> e = orig.getEdges();
            while (e.hasNext()) {
                terms.add(e.next().getTerm());
            }
        }
        return terms;
    }

    Set<AutomatonState> reachableStates(FiniteStateMachine.TermParticlePair pair, FiniteStateMachine nfsa) {
        HashSet<AutomatonState> result = new HashSet<AutomatonState>(5);
        IntIterator p = this.provenance.iterator();
        while (p.hasNext()) {
            NonDeterminizedState n = (NonDeterminizedState)nfsa.getState(p.next());
            if (pair.term instanceof Edge.MaxOccursTerm) {
                Edge onmax = n.getMaxTransition();
                if (onmax == null) continue;
                result.add(onmax.getTargetState());
                continue;
            }
            Edge e = n.getEdge(pair.term);
            if (e == null || e.getParticle() != pair.particle) continue;
            result.add(e.getTargetState());
        }
        return result;
    }
}

