/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.fsa;

import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.fsa.AutomatonState;
import com.saxonica.schema.fsa.Edge;
import com.saxonica.schema.fsa.State;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.type.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountingState
implements State {
    private AutomatonState automatonState;
    private int counter;

    public CountingState(AutomatonState as, int startFrom) {
        this.automatonState = as;
        this.counter = startFrom;
    }

    public State incrementCounter() throws ValidationException {
        int max = this.automatonState.getMaxOccurs();
        if (max != -1 && this.counter + 1 == max) {
            Edge maxTransition = this.automatonState.getMaxTransition();
            if (maxTransition != null) {
                return maxTransition.getTargetState();
            }
        } else if (max != -1 && this.counter == max) {
            ValidationException ve = new ValidationException("Too many occurrences of repeating element: found " + (this.counter + 1) + " occurrences but maxOccurs is " + max);
            ve.setConstraintReference(1, "cvc-particle", "2.2");
            throw ve;
        }
        return new CountingState(this.automatonState, this.counter + 1);
    }

    public void testMinimumReached() throws ValidationException {
        int min = this.automatonState.getMinOccurs();
        if (this.counter < min) {
            ValidationException ve = new ValidationException("Too few occurrences of repeating element: found " + this.counter + " occurrences but minOccurs is " + min);
            ve.setConstraintReference(1, "cvc-particle", "2.1");
            throw ve;
        }
    }

    @Override
    public Edge getTransition(int token, UserComplexType type) {
        return this.automatonState.getTransition(token, type);
    }

    @Override
    public boolean isFinalState() {
        return this.automatonState.isConditionallyFinalState() && this.counter >= this.automatonState.getMinOccurs();
    }

    public AutomatonState getUnderlyingState() {
        return this.automatonState;
    }

    @Override
    public CharSequence listAllowedElements() {
        return this.automatonState.listAllowedElements();
    }

    @Override
    public Edge[] getWildcardEdges() {
        Edge[] baseEdges = this.automatonState.getWildcardEdges();
        if (this.counter < this.automatonState.getMinOccurs()) {
            int keep = 0;
            for (int i = 0; i < baseEdges.length; ++i) {
                if (baseEdges[i].getTargetState() != this.automatonState) continue;
                ++keep;
            }
            if (keep == baseEdges.length) {
                return baseEdges;
            }
            Edge[] newEdges = new Edge[keep];
            int j = 0;
            for (int i = 0; i < baseEdges.length; ++i) {
                if (baseEdges[i].getTargetState() != this.automatonState) continue;
                newEdges[j++] = baseEdges[i];
            }
            return newEdges;
        }
        if (this.automatonState.getMaxOccurs() != -1 && this.counter >= this.automatonState.getMaxOccurs()) {
            int keep = 0;
            for (int i = 0; i < baseEdges.length; ++i) {
                if (baseEdges[i].getTargetState() == this.automatonState) continue;
                ++keep;
            }
            if (keep == baseEdges.length) {
                return baseEdges;
            }
            Edge[] newEdges = new Edge[keep];
            int j = 0;
            for (int i = 0; i < baseEdges.length; ++i) {
                if (baseEdges[i].getTargetState() == this.automatonState) continue;
                newEdges[j++] = baseEdges[i];
            }
            return newEdges;
        }
        return baseEdges;
    }

    @Override
    public Iterator<Edge> getEdges() {
        Iterator<Edge> baseEdges = this.automatonState.getEdges();
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        while (baseEdges.hasNext()) {
            Edge baseEdge = baseEdges.next();
            if (baseEdge.getTargetState() == this.automatonState) {
                if (this.automatonState.getMaxOccurs() == -1 || this.automatonState.getMaxOccurs() >= 1000 || this.counter >= this.automatonState.getMaxOccurs()) continue;
                newEdges.add(baseEdge);
                continue;
            }
            if (this.counter < this.automatonState.getMinOccurs()) continue;
            newEdges.add(baseEdge);
        }
        return newEdges.iterator();
    }

    public boolean equals(Object obj) {
        return obj instanceof CountingState && ((CountingState)obj).automatonState == this.automatonState && ((CountingState)obj).counter == this.counter;
    }

    public int hashCode() {
        return this.automatonState.hashCode() ^ this.counter;
    }
}

