/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.Term;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserSchemaComponent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wildcard
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent,
Term {
    private Set<String> allowedNamespaces = null;
    private Set<String> disallowedNamespaces = null;
    private String processContents = "strict";
    private boolean disallowsDefinedNames = false;
    private boolean disallowsDefinedSiblings = false;
    private IntSet disallowedQNames;
    private boolean inexpressible = false;

    public boolean isInexpressible() {
        return this.inexpressible;
    }

    public final boolean allowsAny() {
        return this.allowedNamespaces == null && this.disallowedNamespaces == null;
    }

    public void setNoNamespacesAllowed() {
        this.allowedNamespaces = new HashSet<String>(3);
    }

    public void addAllowedNamespace(String namespace) {
        if (this.allowedNamespaces == null) {
            this.allowedNamespaces = new HashSet<String>(3);
        }
        this.allowedNamespaces.add(namespace);
    }

    public void addDisallowedNamespace(String namespace) {
        if (this.disallowedNamespaces == null) {
            this.disallowedNamespaces = new HashSet<String>(3);
        }
        this.disallowedNamespaces.add(namespace);
    }

    public Set<String> getDisallowedNamespaces() {
        return this.disallowedNamespaces;
    }

    public boolean matches(String uri) {
        if (this.allowedNamespaces != null) {
            return this.allowedNamespaces.contains(uri);
        }
        return this.disallowedNamespaces == null || !this.disallowedNamespaces.contains(uri);
    }

    public boolean matches(int fingerprint, boolean isElement, Configuration config, UserComplexType parentType) {
        if (this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint)) {
            return false;
        }
        if (this.disallowsDefinedNames && (isElement ? config.getElementDeclaration(fingerprint) : config.getAttributeDeclaration(fingerprint)) != null) {
            return false;
        }
        if (parentType != null && this.disallowsDefinedSiblings) {
            IntHashSet siblings = new IntHashSet();
            try {
                parentType.gatherAllPermittedChildren(siblings, true);
            }
            catch (SchemaException e) {
                throw new IllegalStateException(e);
            }
            if (siblings.contains(fingerprint)) {
                return false;
            }
        }
        String uri = config.getNamePool().getURI(fingerprint);
        if (this.allowedNamespaces != null) {
            return this.allowedNamespaces.contains(uri);
        }
        return this.disallowedNamespaces == null || !this.disallowedNamespaces.contains(uri);
    }

    public String reasonForNonMatch(int fingerprint, boolean isElement, Configuration config) {
        if (this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint)) {
            return "The name is in the list of disallowed QNames for the wildcard";
        }
        if (this.disallowsDefinedNames && (isElement ? config.getElementDeclaration(fingerprint) : config.getAttributeDeclaration(fingerprint)) != null) {
            return "There is a global " + (isElement ? "element" : "attribute") + " declaration for the name, and the wildcard specifies notQName='##defined'";
        }
        String uri = config.getNamePool().getURI(fingerprint);
        if (this.allowedNamespaces != null) {
            if (this.allowedNamespaces.contains(uri)) {
                return null;
            }
            return "The name is not in one of the permitted namespaces for the wildcard";
        }
        if (this.disallowedNamespaces == null || !this.disallowedNamespaces.contains(uri)) {
            return null;
        }
        return "The name is in " + (this.disallowedNamespaces.size() == 1 ? "the disallowed namespace" : "one of the disallowed namespaces") + " for the wildcard";
    }

    public boolean disallowsQName(int fingerprint) {
        return this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint);
    }

    public Set<String> getAllowedNamespaces() {
        return this.allowedNamespaces;
    }

    public String getProcessContents() {
        return this.processContents;
    }

    public void setProcessContents(String process) {
        this.processContents = process;
    }

    public void setDisallowDefinedNames(boolean disallow) {
        this.disallowsDefinedNames = disallow;
    }

    public boolean isDisallowDefinedNames() {
        return this.disallowsDefinedNames;
    }

    public void setDisallowDefinedSiblings(boolean disallow) {
        this.disallowsDefinedSiblings = disallow;
    }

    public boolean isDisallowDefinedSiblings() {
        return this.disallowsDefinedSiblings;
    }

    public void addDisallowedQName(int fingerprint) {
        if (this.disallowedQNames == null) {
            this.disallowedQNames = new IntHashSet(10);
        }
        this.disallowedQNames.add(fingerprint);
    }

    public boolean isDisallowedQName(int fingerprint) {
        return this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint);
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        return true;
    }

    public String toString() {
        if (this.disallowedNamespaces != null) {
            return "not{" + this.listOfNamespaces(this.disallowedNamespaces) + "}";
        }
        if (this.allowedNamespaces != null) {
            return "anyOf{" + this.listOfNamespaces(this.allowedNamespaces) + "}";
        }
        return "any";
    }

    private String listOfNamespaces(Set<String> namespaces) {
        if (namespaces == null) {
            return "";
        }
        FastStringBuffer sb = new FastStringBuffer(64);
        Iterator<String> iter = namespaces.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            String s = iter.next();
            sb.append(s.length() == 0 ? "##local" : s);
        }
        return sb.toString();
    }

    public boolean isSubset(Wildcard sup, NamePool pool) {
        if (!this.isNamespaceSubset(sup)) {
            return false;
        }
        if (sup.disallowedQNames != null) {
            IntIterator it = sup.disallowedQNames.iterator();
            while (it.hasNext()) {
                int fp = it.next();
                String uri = pool.getURI(fp);
                if (!this.matches(uri) || this.disallowsQName(fp)) continue;
                return false;
            }
        }
        return !sup.disallowsDefinedNames || this.disallowsDefinedNames;
    }

    private boolean isNamespaceSubset(Wildcard sup) {
        if (sup.allowedNamespaces == null && sup.disallowedNamespaces == null) {
            return true;
        }
        if (sup.allowedNamespaces != null && this.allowedNamespaces != null) {
            return sup.allowedNamespaces.containsAll(this.allowedNamespaces);
        }
        if (this.allowedNamespaces != null && sup.disallowedNamespaces != null) {
            return Collections.disjoint(this.allowedNamespaces, sup.disallowedNamespaces);
        }
        if (sup.disallowedNamespaces != null && this.disallowedNamespaces != null) {
            return this.disallowedNamespaces.containsAll(sup.disallowedNamespaces);
        }
        return false;
    }

    public boolean overlaps(Wildcard other) {
        if (this.allowedNamespaces == null && this.disallowedNamespaces == null) {
            return true;
        }
        if (other.allowedNamespaces == null && other.disallowedNamespaces == null) {
            return true;
        }
        if (this.disallowedNamespaces != null && other.disallowedNamespaces != null) {
            return true;
        }
        if (this.disallowedNamespaces != null && other.allowedNamespaces != null) {
            return !this.disallowedNamespaces.containsAll(other.allowedNamespaces);
        }
        if (other.disallowedNamespaces != null && this.allowedNamespaces != null) {
            return !other.disallowedNamespaces.containsAll(this.allowedNamespaces);
        }
        if (this.allowedNamespaces != null && other.allowedNamespaces != null) {
            return !Collections.disjoint(this.allowedNamespaces, other.allowedNamespaces);
        }
        return true;
    }

    public static boolean isNotStronger(String str1, String str2) {
        int r2;
        String ranking = "skip lax strict";
        int r1 = ranking.indexOf(str1);
        return r1 <= (r2 = ranking.indexOf(str2));
    }

    public int compareStrength(Wildcard other) {
        String ranking = "skip lax strict";
        int r1 = ranking.indexOf(this.processContents);
        int r2 = ranking.indexOf(other.processContents);
        return Integer.valueOf(r1).compareTo(r2);
    }

    public static Wildcard makeIntersection(Wildcard wat1, Wildcard wat2, NamePool pool) {
        String uri;
        int fp;
        IntIterator it;
        Set<String> allowed1 = wat1.getAllowedNamespaces();
        Set<String> allowed2 = wat2.getAllowedNamespaces();
        Set<String> disallowed1 = wat1.getDisallowedNamespaces();
        Set<String> disallowed2 = wat2.getDisallowedNamespaces();
        Wildcard result = new Wildcard();
        result.setConfiguration(wat1.getConfiguration());
        result.setProcessContents(wat1.getProcessContents());
        result.setLocator(wat1);
        if (allowed1 != null && allowed2 != null) {
            result.allowedNamespaces = Wildcard.intersection(allowed1, allowed2);
        } else if (disallowed1 != null && disallowed2 != null) {
            result.disallowedNamespaces = Wildcard.union(disallowed1, disallowed2);
        } else if (allowed1 == null && disallowed1 == null) {
            result.allowedNamespaces = allowed2;
            result.disallowedNamespaces = disallowed2;
        } else if (allowed2 == null && disallowed2 == null) {
            result.allowedNamespaces = allowed1;
            result.disallowedNamespaces = disallowed1;
        } else if (allowed1 != null && disallowed2 != null) {
            result.allowedNamespaces = Wildcard.difference(allowed1, disallowed2);
        } else if (allowed2 != null && disallowed1 != null) {
            result.allowedNamespaces = Wildcard.difference(allowed2, disallowed1);
        } else {
            throw new IllegalStateException("Invalid wildcard");
        }
        if (result.disallowedNamespaces != null && result.disallowedNamespaces.isEmpty()) {
            result.disallowedNamespaces = null;
        }
        if (wat1.disallowedQNames != null) {
            it = wat1.disallowedQNames.iterator();
            while (it.hasNext()) {
                fp = it.next();
                uri = pool.getURI(fp);
                if (!wat2.matches(uri)) continue;
                result.addDisallowedQName(fp);
            }
        }
        if (wat2.disallowedQNames != null) {
            it = wat2.disallowedQNames.iterator();
            while (it.hasNext()) {
                fp = it.next();
                uri = pool.getURI(fp);
                if (!wat1.matches(uri)) continue;
                result.addDisallowedQName(fp);
            }
        }
        if (wat1.disallowsDefinedNames || wat2.disallowsDefinedNames) {
            result.disallowsDefinedNames = true;
        }
        return result;
    }

    public static Wildcard makeUnion(Wildcard wat1, Wildcard wat2, NamePool pool) {
        String uri;
        int fp;
        IntIterator it;
        Set<String> allowed1 = wat1.getAllowedNamespaces();
        Set<String> allowed2 = wat2.getAllowedNamespaces();
        Set<String> disallowed1 = wat1.getDisallowedNamespaces();
        Set<String> disallowed2 = wat2.getDisallowedNamespaces();
        Wildcard result = new Wildcard();
        result.setConfiguration(wat1.getConfiguration());
        result.setProcessContents(wat1.getProcessContents());
        result.setLocator(wat1);
        if (allowed1 != null && allowed2 != null) {
            result.allowedNamespaces = Wildcard.union(allowed1, allowed2);
        } else if (disallowed1 != null && disallowed2 != null) {
            result.disallowedNamespaces = Wildcard.intersection(disallowed1, disallowed2);
        } else if (allowed1 == null && disallowed1 == null) {
            result.allowedNamespaces = null;
            result.disallowedNamespaces = null;
        } else if (allowed2 == null && disallowed2 == null) {
            result.allowedNamespaces = null;
            result.disallowedNamespaces = null;
        } else if (allowed1 != null && disallowed2 != null) {
            result.disallowedNamespaces = Wildcard.difference(disallowed2, allowed1);
        } else if (allowed2 != null && disallowed1 != null) {
            result.disallowedNamespaces = Wildcard.difference(disallowed1, allowed2);
        } else {
            throw new IllegalStateException("Invalid wildcard");
        }
        if (result.allowedNamespaces != null && result.allowedNamespaces.isEmpty()) {
            result.allowedNamespaces = null;
        }
        if (result.disallowedNamespaces != null && result.disallowedNamespaces.isEmpty()) {
            result.disallowedNamespaces = null;
        }
        if (wat1.disallowedQNames != null) {
            it = wat1.disallowedQNames.iterator();
            while (it.hasNext()) {
                fp = it.next();
                uri = pool.getURI(fp);
                if (wat2.matches(uri) && !wat2.disallowsQName(fp)) continue;
                result.addDisallowedQName(fp);
            }
        }
        if (wat2.disallowedQNames != null) {
            it = wat2.disallowedQNames.iterator();
            while (it.hasNext()) {
                fp = it.next();
                uri = pool.getURI(fp);
                if (wat1.matches(uri) && !wat1.disallowsQName(fp)) continue;
                result.addDisallowedQName(fp);
            }
        }
        if (wat1.disallowsDefinedNames && wat2.disallowsDefinedNames) {
            result.disallowsDefinedNames = true;
        }
        if (wat1.disallowsDefinedNames && !wat2.disallowsDefinedNames && Wildcard.allowsMoreNamespacesThan(wat1, wat2)) {
            result.inexpressible = true;
        }
        if (wat2.disallowsDefinedNames && !wat1.disallowsDefinedNames && Wildcard.allowsMoreNamespacesThan(wat2, wat1)) {
            result.inexpressible = true;
        }
        return result;
    }

    private static boolean allowsMoreNamespacesThan(Wildcard w1, Wildcard w2) {
        return w1.allowsAny() && !w2.allowsAny() || w1.allowedNamespaces != null && w2.allowedNamespaces != null && !Wildcard.difference(w1.allowedNamespaces, w2.allowedNamespaces).isEmpty() || w1.allowedNamespaces != null && w2.disallowedNamespaces != null && !Wildcard.difference(w2.disallowedNamespaces, w1.allowedNamespaces).isEmpty() || w1.disallowedNamespaces != null && w2.allowedNamespaces != null || w1.disallowedNamespaces != null && w2.disallowedNamespaces != null && !Wildcard.difference(w2.disallowedNamespaces, w1.disallowedNamespaces).isEmpty();
    }

    private static Set<String> union(Set<String> a, Set<String> b) {
        HashSet<String> result = new HashSet<String>(a.size() + b.size());
        Iterator<String> i = a.iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        i = b.iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    private static Set<String> intersection(Set<String> a, Set<String> b) {
        HashSet<String> result = new HashSet<String>();
        for (String s : a) {
            if (!b.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    private static Set<String> difference(Set<String> a, Set<String> b) {
        HashSet<String> result = new HashSet<String>();
        for (String s : a) {
            if (b.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("wildcard");
        serializer.emitAttribute("id", serializer.getId(this, true));
        serializer.emitAttribute("processContents", this.getProcessContents());
        if (this.allowedNamespaces == null) {
            if (this.disallowedNamespaces == null) {
                serializer.emitAttribute("constraint", "any");
            } else {
                serializer.emitAttribute("constraint", "not");
                serializer.emitAttribute("namespaces", this.listOfNamespaces(this.disallowedNamespaces));
            }
        } else {
            serializer.emitAttribute("constraint", "enumeration");
            serializer.emitAttribute("namespaces", this.listOfNamespaces(this.allowedNamespaces));
        }
        FastStringBuffer disallowedNames = new FastStringBuffer(100);
        if (this.disallowsDefinedNames) {
            disallowedNames.append("##defined ");
        }
        if (this.disallowsDefinedSiblings) {
            disallowedNames.append("##definedSibling ");
        }
        if (this.disallowedQNames != null && !this.disallowedQNames.isEmpty()) {
            NamePool pool = this.getConfiguration().getNamePool();
            IntIterator intit = this.disallowedQNames.iterator();
            while (intit.hasNext()) {
                int nc = intit.next();
                String name = pool.getClarkName(nc);
                disallowedNames.append(name);
                disallowedNames.append(' ');
            }
        }
        if (disallowedNames.length() > 0) {
            disallowedNames.setLength(disallowedNames.length() - 1);
            serializer.emitAttribute("notQName", disallowedNames.toString());
        }
        serializer.endElement();
    }
}

