/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;

public class WhitespaceFacet
extends Facet {
    int action;

    public boolean isConstraining() {
        return false;
    }

    public String getName() {
        return "whiteSpace";
    }

    public void setValue(String value) throws SchemaException {
        if (value.equals("preserve")) {
            this.action = 0;
        } else if (value.equals("replace")) {
            this.action = 1;
        } else if (value.equals("collapse")) {
            this.action = 2;
        } else {
            throw new SchemaException("Invalid whiteSpace facet value: " + value);
        }
    }

    public String getValue() {
        switch (this.action) {
            case 0: {
                return "preserve";
            }
            case 1: {
                return "replace";
            }
            case 2: {
                return "collapse";
            }
        }
        return null;
    }

    public int getWhitespaceAction() {
        return this.action;
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        if (base.isListType()) {
            if (this.action != 2) {
                throw new SchemaException("The whiteSpace facet on a list type must be {collapse}");
            }
        } else {
            if (base.isUnionType()) {
                throw new SchemaException("The whiteSpace facet is not applicable to a union type");
            }
            if (!(base instanceof AnySimpleType)) {
                int p = ((AtomicType)base).getPrimitiveType();
                if (type.getFingerprint() != 513) {
                    if (p == 513) {
                        if (this.action < base.getWhitespaceAction()) {
                            throw new SchemaException("The whiteSpace normalization must not be weaker than that of the base type");
                        }
                    } else if (this.action != 2) {
                        throw new SchemaException("The whiteSpace facet must be {collapse} unless the type is derived from string");
                    }
                }
            }
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }
}

