/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserListType;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserUnionType
extends UserSimpleType {
    private List<TypeReference> memberTypeReferences = null;

    public UserUnionType(EnterpriseConfiguration config) {
        this.setConfiguration(config);
        this.memberTypeReferences = new ArrayList<TypeReference>(3);
    }

    @Override
    public AtomicType getCommonAtomicType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        SchemaComponent target = this.memberTypeReferences.get(0).getTarget();
        AtomicType a = ((SimpleType)target).getCommonAtomicType();
        for (int i = 1; i < this.memberTypeReferences.size(); ++i) {
            TypeReference typeReference = this.memberTypeReferences.get(i);
            AtomicType b = ((SimpleType)typeReference.getTarget()).getCommonAtomicType();
            ItemType u = Type.getCommonSuperType(a, b, th);
            if (u.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                return (AtomicType)u;
            }
            if (!u.isAtomicType()) {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
            a = (AtomicType)u;
        }
        return a;
    }

    public void setMemberTypeReferences(List members) {
        this.memberTypeReferences = members;
    }

    public void addMemberTypeReference(TypeReference member) {
        if (this.memberTypeReferences == null) {
            this.memberTypeReferences = new ArrayList<TypeReference>(5);
        }
        this.memberTypeReferences.add(member);
    }

    public List<TypeReference> getMemberTypeReferences() {
        return this.memberTypeReferences;
    }

    public Iterator<TypeReference> iterateMemberTypeReferences() {
        return this.memberTypeReferences.iterator();
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() {
        for (int i = 0; i < this.memberTypeReferences.size(); ++i) {
            TypeReference ref = this.memberTypeReferences.get(i);
            SimpleType st = (SimpleType)ref.getTarget();
            if (!st.isIdType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdRefType() {
        for (int i = 0; i < this.memberTypeReferences.size(); ++i) {
            TypeReference ref = this.memberTypeReferences.get(i);
            SimpleType st = (SimpleType)ref.getTarget();
            if (!st.isIdRefType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBuiltInType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    @Override
    public boolean isNamespaceSensitive() {
        for (int i = 0; i < this.memberTypeReferences.size(); ++i) {
            TypeReference ref = this.memberTypeReferences.get(i);
            SimpleType st = (SimpleType)ref.getTarget();
            if (!st.isNamespaceSensitive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        switch (this.getValidationStatus()) {
            case 3: 
            case 4: {
                return true;
            }
            case 2: {
                compiler.error("The definition of the union type " + this.getDescription() + " is circular", this);
                return false;
            }
        }
        super.validate(compiler);
        this.setValidationStatus(2);
        if (this.memberTypeReferences == null) {
            this.memberTypeReferences = this.getBaseType() instanceof UserUnionType ? ((UserUnionType)this.getBaseType()).getMemberTypeReferences() : Collections.EMPTY_LIST;
        }
        this.lookForCycles(new Stack(), compiler);
        this.setValidationStatus(3);
        return result;
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        Iterator<TypeReference> members = this.iterateMemberTypeReferences();
        while (members.hasNext()) {
            TypeReference ref = members.next();
            SimpleType member = (SimpleType)ref.getTarget();
            if (!(member instanceof UserSimpleType)) continue;
            ((UserSimpleType)member).elaborate(compiler);
        }
        super.elaborate(compiler);
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        int i;
        for (i = 0; i < references.size(); ++i) {
            if (!((SchemaType)references.get(i)).isSameType(this)) continue;
            compiler.error("The definition of the union type " + this.getDescription() + " is circular", this);
            throw new SchemaException("Circular definition found");
        }
        references.push(this);
        for (i = 0; i < this.memberTypeReferences.size(); ++i) {
            SchemaType stb;
            TypeReference ref = this.memberTypeReferences.get(i);
            ref.tryToResolve(compiler);
            if (!ref.isResolved()) continue;
            SchemaType st = (SchemaType)ref.getTarget();
            if (st instanceof SimpleTypeDefinition) {
                ((SimpleTypeDefinition)st).fixup(compiler);
                st = ((SimpleTypeDefinition)st).getSimpleType();
            }
            if (st instanceof UserUnionType) {
                SchemaType stb2;
                ((UserUnionType)st).lookForCycles(references, compiler);
                while ((stb2 = st.getBaseType()) instanceof UserUnionType) {
                    ((UserUnionType)stb2).lookForCycles(references, compiler);
                    st = stb2;
                }
                continue;
            }
            if (!(st instanceof UserListType)) continue;
            SimpleType it = ((UserListType)st).getItemType();
            if (it instanceof SimpleTypeDefinition) {
                ((SimpleTypeDefinition)it).fixup(compiler);
                it = ((SimpleTypeDefinition)it).getSimpleType();
            }
            if (it.isSameType(this)) {
                compiler.error("The definition of the union type " + this.getDescription() + " is circular", this);
                throw new SchemaException("Circular definition found");
            }
            if (!(it instanceof UserUnionType)) continue;
            ((UserUnionType)it).lookForCycles(references, compiler);
            while ((stb = it.getBaseType()) instanceof UserUnionType) {
                ((UserUnionType)stb).lookForCycles(references, compiler);
                it = (UserUnionType)stb;
            }
        }
        references.pop();
    }

    @Override
    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, ConversionRules rules) {
        ValidationFailure result;
        Iterator<TypeReference> members = this.iterateMemberTypeReferences();
        boolean matched = false;
        while (members.hasNext()) {
            TypeReference ref = members.next();
            SimpleType type = (SimpleType)ref.getTarget();
            ValidationFailure err = type.validateContent(value, nsResolver, rules);
            if (err != null) continue;
            matched = true;
            break;
        }
        if (matched) {
            SchemaType base = this.getBaseType();
            if (base instanceof UserUnionType) {
                try {
                    SequenceIterator iter = ((UserUnionType)base).getTypedValue(value, nsResolver, rules);
                    Value typedValue = (Value)SequenceExtent.makeSequenceExtent(iter);
                    result = this.checkAgainstFacets(typedValue, value, this.getFacets());
                }
                catch (XPathException e) {
                    result = new ValidationFailure("Value " + Err.wrap(value, 4) + " does not match base type of union type " + this.getDescription());
                }
            } else {
                result = null;
            }
        } else {
            result = new ValidationFailure("Value " + Err.wrap(value, 4) + " does not match any member of union type " + this.getDescription());
        }
        return result;
    }

    @Override
    public SequenceIterator getTypedValue(CharSequence value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        Iterator<TypeReference> members = this.iterateMemberTypeReferences();
        while (members.hasNext()) {
            TypeReference ref = members.next();
            SimpleType type = (SimpleType)ref.getTarget();
            try {
                ValidationFailure err = type.validateContent(value, resolver, rules);
                if (err != null) continue;
                return type.getTypedValue(value, resolver, rules);
            }
            catch (ValidationException err) {
            }
        }
        throw new ValidationException("Value " + Err.wrap(value, 4) + " does not match any member of union type " + this.getName());
    }

    @Override
    public void serializeVariety(SchemaModelSerializer serializer) throws XPathException {
        serializer.emitAttribute("variety", "union");
        FastStringBuffer sb = new FastStringBuffer(64);
        Iterator<TypeReference> members = this.iterateMemberTypeReferences();
        while (members.hasNext()) {
            TypeReference ref = members.next();
            SimpleType type = (SimpleType)ref.getTarget();
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(serializer.getTypeLink(type));
        }
        serializer.emitAttribute("memberTypes", sb.toString());
    }
}

