/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.AssertionFacet;
import com.saxonica.schema.EnumerationFacet;
import com.saxonica.schema.EnumerationFacetSet;
import com.saxonica.schema.Facet;
import com.saxonica.schema.PatternFacet;
import com.saxonica.schema.PreprocessFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserDefinedType;
import com.saxonica.schema.UserSchemaComponent;
import com.saxonica.schema.UserUnionType;
import com.saxonica.schema.ValueRangeFacet;
import com.saxonica.schema.WhitespaceFacet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserSimpleType
extends UserDefinedType
implements SimpleType,
UserSchemaComponent,
SerializableSchemaComponent {
    private List<Facet> facetList = new ArrayList<Facet>(10);
    private List<Facet> extendedFacetList;

    @Override
    public final boolean isSimpleType() {
        return true;
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() {
        return false;
    }

    @Override
    public boolean isIdRefType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return false;
    }

    public List<Facet> getExtendedFacetList() {
        if (this.extendedFacetList != null) {
            return this.extendedFacetList;
        }
        this.extendedFacetList = this.addInheritedFacets(this.facetList);
        return this.extendedFacetList;
    }

    protected List<Facet> addInheritedFacets(List<Facet> localFacets) {
        SchemaType baseType = this.getBaseType();
        if (baseType instanceof UserSimpleType) {
            ArrayList<Facet> extendedFacetList = new ArrayList<Facet>(10);
            HashSet facetsFound = new HashSet();
            for (int i = 0; i < localFacets.size(); ++i) {
                Facet facet = localFacets.get(i);
                extendedFacetList.add(facet);
                facetsFound.add(facet.getClass());
            }
            List<Facet> baseFacetList = ((UserSimpleType)baseType).getExtendedFacetList();
            for (int i = 0; i < baseFacetList.size(); ++i) {
                Facet facet = baseFacetList.get(i);
                if (!(facet instanceof PatternFacet) && !(facet instanceof AssertionFacet) && facetsFound.contains(facet.getClass())) continue;
                extendedFacetList.add(baseFacetList.get(i));
                facetsFound.add(facet.getClass());
            }
            return extendedFacetList;
        }
        return localFacets;
    }

    public void addFacet(Facet facet) {
        this.facetList.add(facet);
    }

    public void mergeEnumerationFacets(SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        SchemaType baseType;
        boolean enumFound = false;
        EnumerationFacetSet efs = new EnumerationFacetSet();
        PatternFacet pf = null;
        for (int i = this.facetList.size() - 1; i >= 0; --i) {
            if (this.facetList.get(i) instanceof EnumerationFacet) {
                Value val;
                EnumerationFacet e = (EnumerationFacet)this.facetList.get(i);
                SchemaType base = this.getBaseType();
                if (base instanceof SimpleType) {
                    try {
                        val = e.getTypedValue((SimpleType)base, this.getConfiguration());
                    }
                    catch (SchemaException se) {
                        compiler.error("Enumeration value does not match base type. " + se.getMessage(), this);
                        this.setValidationStatus(4);
                        return;
                    }
                } else {
                    val = new StringValue(e.getValue());
                }
                if (val instanceof AtomicValue) {
                    for (int f = 0; f < this.facetList.size(); ++f) {
                        Facet facet = this.facetList.get(f);
                        if (facet instanceof EnumerationFacet || facet instanceof EnumerationFacetSet || facet instanceof WhitespaceFacet || facet.testAtomicValue((AtomicValue)val)) continue;
                        String value = ((AtomicValue)val).getStringValue();
                        String message = "Enumeration value " + Err.wrap(value, 4) + " is not a valid instance of the type: " + "it contravenes the " + facet.getName() + " facet";
                        String userMessage = facet.getMessage();
                        if (userMessage != null) {
                            message = message + ". " + userMessage;
                        }
                        compiler.warning(message, this);
                    }
                }
                efs.addEnumerationValue(val, e.getValue());
                this.facetList.remove(i);
                enumFound = true;
                continue;
            }
            if (!(this.facetList.get(i) instanceof PatternFacet) || ((PatternFacet)this.facetList.get(i)).isDoNotMerge()) continue;
            if (pf == null) {
                pf = (PatternFacet)this.facetList.get(i);
                continue;
            }
            String pat = this.facetList.get(i).getValue();
            pf.addBranch(pat);
            this.facetList.remove(i);
        }
        if (enumFound) {
            this.facetList.add(efs);
        }
        if ((baseType = this.getBaseType()) instanceof UserSimpleType) {
            ((UserSimpleType)baseType).mergeEnumerationFacets(compiler);
        }
    }

    public Facet getFacet(Class name) {
        Iterator<Facet> facets = this.getFacets();
        while (facets.hasNext()) {
            Facet facet = facets.next();
            if (facet.getClass() != name) continue;
            return facet;
        }
        return null;
    }

    public void setFacetList(List facetList) {
        this.facetList = facetList;
    }

    public void convertFacetValues() throws SchemaException {
        for (Facet facet : this.facetList) {
            if (!(facet instanceof ValueRangeFacet)) continue;
            ((ValueRangeFacet)facet).convertToTargetType(this, this.getConfiguration());
        }
    }

    public Iterator<Facet> getFacets() {
        return this.getExtendedFacetList().iterator();
    }

    @Override
    public int getWhitespaceAction() {
        int action = -1;
        Facet ws = this.getFacet(WhitespaceFacet.class);
        if (ws != null) {
            action = ws.getWhitespaceAction();
        }
        if (action == -1) {
            if (this instanceof UserAtomicType && ((UserAtomicType)this).getPrimitiveType() == 513) {
                TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
                if (th.isSubType((UserAtomicType)this, BuiltInAtomicType.TOKEN)) {
                    return 2;
                }
                if (th.isSubType((UserAtomicType)this, BuiltInAtomicType.NORMALIZED_STRING)) {
                    return 1;
                }
                return 0;
            }
            if (this.isUnionType()) {
                return 0;
            }
            return 2;
        }
        return action;
    }

    public CharSequence applyWhitespaceNormalization(CharSequence value) {
        int action = this.getWhitespaceAction();
        return Whitespace.applyWhitespaceNormalization(action, value);
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        SchemaType base;
        for (base = this; base != null && base.getFingerprint() > 1023; base = base.getBaseType()) {
        }
        return base;
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
        String s = UserSimpleType.isTypeDerivationOK(this, type, block);
        if (s != null) {
            throw new SchemaException(s);
        }
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        switch (this.getValidationStatus()) {
            case 3: 
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        this.setValidationStatus(2);
        if (this.getFingerprint() < 1023) {
            this.setValidationStatus(3);
            return true;
        }
        if (this.getBaseType() == null) {
            TypeReference ref = new TypeReference(573, this.getConfiguration(), this);
            ref.setTarget(AnySimpleType.getInstance());
            this.setBaseTypeReference(ref);
        } else if (this.getBaseType() instanceof UserSimpleType) {
            ((UserSimpleType)this.getBaseType()).validate(compiler);
        } else if (!this.getBaseType().isSimpleType()) {
            compiler.error("The base type of the simple type " + this.getDescription() + " is not a simple type", this);
            this.setValidationStatus(4);
            return false;
        }
        this.setValidationStatus(3);
        return true;
    }

    @Override
    public void analyzeContentExpression(Expression expression, int kind, StaticContext env) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, env, kind);
    }

    @Override
    public final SequenceIterator getTypedValue(NodeInfo node) throws XPathException {
        try {
            return this.getTypedValue(node.getStringValueCS(), this.isNamespaceSensitive() ? new InscopeNamespaceResolver(node) : null, this.getConfiguration().getConversionRules());
        }
        catch (ValidationException err) {
            throw new XPathException("Internal error: value doesn't match its type annotation. " + err.getMessage());
        }
    }

    @Override
    public Value atomize(NodeInfo node) throws XPathException {
        SequenceIterator iter = this.getTypedValue(node);
        return (Value)SequenceExtent.makeSequenceExtent(iter);
    }

    public static String isTypeDerivationOK(SimpleType d, SchemaType b, int derivation) {
        if (d.isExternalType()) {
            return "External types cannot be used in schema validation";
        }
        if (d == b) {
            return null;
        }
        if ((derivation & 1) != 0) {
            return "Simple type derivation is not OK: 'restriction' is in the set of disallowed derivations";
        }
        SchemaType actualBase = d.getBaseType();
        if (actualBase != null && !actualBase.allowsDerivation(1)) {
            return "Simple type derivation is not OK: the base type of type " + d.getDescription() + " does not allow derivation by restriction";
        }
        if (actualBase == b || actualBase.getFingerprint() == b.getFingerprint()) {
            return null;
        }
        String reason = null;
        if (actualBase != AnyType.getInstance()) {
            if (actualBase instanceof SimpleType) {
                reason = UserSimpleType.isTypeDerivationOK((SimpleType)actualBase, b, derivation);
                if (reason == null) {
                    return null;
                }
            } else {
                try {
                    UserComplexType.checkTypeDerivation((ComplexType)actualBase, b, derivation);
                    return null;
                }
                catch (SchemaException err) {
                    reason = err.getMessage();
                }
            }
        }
        if ((d.isListType() || d.isUnionType()) && b == AnySimpleType.getInstance()) {
            return null;
        }
        if (b.isSimpleType() && ((SimpleType)b).isUnionType() && b != ErrorType.getInstance() && !((UserUnionType)b).getFacets().hasNext()) {
            Iterator<TypeReference> iter = ((UserUnionType)b).iterateMemberTypeReferences();
            while (iter.hasNext()) {
                TypeReference ref = iter.next();
                SimpleType member = (SimpleType)ref.getTarget();
                reason = UserSimpleType.isTypeDerivationOK(d, member, derivation);
                if (reason != null) continue;
                return null;
            }
        }
        return "Type " + d.getDescription() + " is not validly derived from type " + b.getDescription() + (reason == null || reason.indexOf(" is not validly derived from type ") >= 0 ? "" : ". " + reason);
    }

    public List getLocalFacetList() {
        return this.facetList;
    }

    @Override
    public CharSequence preprocess(CharSequence input) throws ValidationException {
        Iterator<Facet> iter = this.getFacets();
        while (iter.hasNext()) {
            Facet facet = iter.next();
            if (!(facet instanceof PreprocessFacet)) continue;
            input = ((PreprocessFacet)facet).preprocess(input);
        }
        return input;
    }

    @Override
    public CharSequence postprocess(CharSequence input) throws ValidationException {
        Iterator<Facet> iter = this.getFacets();
        while (iter.hasNext()) {
            Facet facet = iter.next();
            if (!(facet instanceof PreprocessFacet)) continue;
            input = ((PreprocessFacet)facet).postprocess(input);
        }
        return input;
    }

    public ValidationFailure checkAgainstFacets(Value primitiveValue, CharSequence lexicalValue, Iterator iter) {
        StringValue normalizedValue = null;
        while (iter.hasNext()) {
            String message;
            Facet f = (Facet)iter.next();
            if (f instanceof PatternFacet) {
                if (normalizedValue == null) {
                    if (lexicalValue == null) {
                        try {
                            normalizedValue = StringValue.makeStringValue(primitiveValue.getStringValueCS());
                        }
                        catch (XPathException err) {
                            normalizedValue = new StringValue(primitiveValue.toString());
                        }
                    } else {
                        normalizedValue = StringValue.makeStringValue(this.applyWhitespaceNormalization(lexicalValue));
                        if (primitiveValue instanceof StringValue) {
                            ((StringValue)primitiveValue).setStringValueCS(normalizedValue.getStringValueCS());
                        }
                    }
                }
                if (f.testAtomicValue(normalizedValue)) continue;
                message = "Value " + Err.wrap(normalizedValue.getStringValue(), 4) + " contravenes the pattern facet " + (f.getValue() == null ? "" : Err.wrap(f.getValue(), 4) + ' ') + "of the type " + this.getDescription();
                if (f.getMessage() != null) {
                    message = message + ". " + f.getMessage();
                }
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "cvc-pattern-valid", "1");
                ve.setErrorCode("FORG0001");
                return ve;
            }
            if (primitiveValue instanceof AtomicValue) {
                AtomicValue av = (AtomicValue)primitiveValue;
                if (f.testAtomicValue(av)) continue;
                String message2 = "Value " + Err.wrap(UserSimpleType.displayValue(av), 4) + " contravenes the " + f.getName() + " facet " + (f.getValue() == null ? "" : Err.wrap(f.getValue(), 4) + ' ') + "of the type " + this.getDescription();
                if (f.getMessage() != null) {
                    message2 = message2 + ". " + f.getMessage();
                }
                ValidationFailure ve = new ValidationFailure(message2);
                ve.setConstraintReference(1, "cvc-simple-type", "1");
                ve.setErrorCode("FORG0001");
                return ve;
            }
            if (f.testListValue(primitiveValue)) continue;
            message = "Value " + Err.wrap(UserSimpleType.displayValue(primitiveValue), 4) + " contravenes the " + f.getName() + " facet " + (f.getValue() == null ? "" : Err.wrap(f.getValue(), 4) + ' ') + "of the type " + this.getDescription();
            if (f.getMessage() != null) {
                message = message + ". " + f.getMessage();
            }
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-simple-type", "1");
            ve.setErrorCode("FORG0001");
            return ve;
        }
        return null;
    }

    private static String displayValue(Value primitiveValue) {
        try {
            String v = primitiveValue.getStringValue();
            if (v.length() > 30) {
                v = v.substring(0, 30) + "...";
            }
            return v;
        }
        catch (XPathException e) {
            return primitiveValue.toString();
        }
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        if (this.getValidationStatus() == 0) {
            if (this.getBaseType() instanceof UserSchemaComponent) {
                ((UserSchemaComponent)((Object)this.getBaseType())).elaborate(compiler);
            }
            this.convertFacetValues();
            this.mergeEnumerationFacets(compiler);
            this.setValidationStatus(3);
        }
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("simpleType");
        serializer.emitAttribute("id", id);
        if (!this.isAnonymousType()) {
            serializer.emitAttribute("name", this.getName());
            if (this.getTargetNamespace() != null && this.getTargetNamespace().length() != 0) {
                serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
            }
        }
        serializer.emitAttribute("base", serializer.getTypeLink(this.getBaseType()));
        if (this.finalProhibitions != 0) {
            String ex = "";
            if ((this.finalProhibitions & 1) != 0) {
                ex = (ex.length() == 0 ? "" : " ") + "restriction";
            }
            if ((this.finalProhibitions & 8) != 0) {
                ex = ex + (ex.length() == 0 ? "" : " ") + "list";
            }
            if ((this.finalProhibitions & 4) != 0) {
                ex = ex + (ex.length() == 0 ? "" : " ") + "union";
            }
            serializer.emitAttribute("final", ex);
        }
        this.serializeVariety(serializer);
        boolean seenEnumeration = false;
        Iterator<Facet> iter = this.getFacets();
        while (iter.hasNext()) {
            Facet facet = iter.next();
            if (facet instanceof EnumerationFacetSet) {
                if (seenEnumeration) continue;
                seenEnumeration = true;
            }
            facet.serializeFacet(serializer);
        }
        serializer.endElement();
    }

    protected abstract void serializeVariety(SchemaModelSerializer var1) throws XPathException;
}

