/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AssertionFacet;
import com.saxonica.schema.EnumerationFacetSet;
import com.saxonica.schema.Facet;
import com.saxonica.schema.LengthFacet;
import com.saxonica.schema.MinLengthFacet;
import com.saxonica.schema.PatternFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserSimpleType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListType
extends UserSimpleType
implements ListType {
    private TypeReference itemType = null;

    public UserListType(EnterpriseConfiguration config) {
        this.setConfiguration(config);
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() {
        return this.getItemType().isIdType();
    }

    @Override
    public boolean isIdRefType() {
        return this.getItemType().isIdRefType();
    }

    @Override
    public boolean isBuiltInType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return true;
    }

    @Override
    protected List<Facet> addInheritedFacets(List<Facet> localFacets) {
        localFacets = super.addInheritedFacets(localFacets);
        for (int i = 0; i < localFacets.size(); ++i) {
            Facet f = localFacets.get(i);
            if (!(f instanceof LengthFacet) && !(f instanceof MinLengthFacet)) continue;
            return localFacets;
        }
        SchemaType base = this;
        while (base != null) {
            if (!((base = base.getBaseType()) instanceof BuiltInListType)) continue;
            ArrayList<Facet> extendedFacets = new ArrayList<Facet>(localFacets);
            MinLengthFacet minLength = new MinLengthFacet();
            minLength.setNumericValue(1);
            extendedFacets.add(minLength);
            return extendedFacets;
        }
        return localFacets;
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        SimpleType st = (SimpleType)this.itemType.getTarget();
        if (st instanceof UserSimpleType) {
            ((UserSimpleType)st).elaborate(compiler);
        }
        super.elaborate(compiler);
    }

    public TypeReference getItemTypeReference() {
        return this.itemType;
    }

    @Override
    public SimpleType getItemType() throws UnresolvedReferenceException {
        return (SimpleType)this.itemType.getTarget();
    }

    @Override
    public AtomicType getCommonAtomicType() {
        return this.getItemType().getCommonAtomicType();
    }

    public void setItemTypeReference(TypeReference type) {
        this.itemType = type;
    }

    @Override
    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, ConversionRules rules) {
        StringValue val;
        ValidationFailure result = null;
        SimpleType itemType = this.getItemType();
        StringTokenIterator iter = new StringTokenIterator(((Object)value).toString());
        int count = 0;
        while ((val = (StringValue)iter.next()) != null) {
            ValidationFailure err = itemType.validateContent(val.getStringValueCS(), nsResolver, rules);
            if (err != null) {
                return err;
            }
            ++count;
        }
        Iterator<Facet> fi = this.getFacets();
        while (fi.hasNext()) {
            Facet f;
            block16: {
                f = fi.next();
                if (f instanceof PatternFacet) {
                    boolean match = f.testAtomicValue(StringValue.makeStringValue(Whitespace.collapseWhitespace(value)));
                    if (!match) {
                        result = new ValidationFailure("List " + Err.wrap(value) + " contravenes the pattern facet " + Err.wrap(f.getValue()));
                        break;
                    }
                } else {
                    boolean match;
                    Value typedValue;
                    if (f instanceof EnumerationFacetSet) {
                        try {
                            SequenceIterator tvi = ((SimpleType)this.getBaseType()).getTypedValue(value, nsResolver, rules);
                            typedValue = (Value)SequenceExtent.makeSequenceExtent(tvi);
                            match = f.testListValue(typedValue);
                            if (!match) {
                                String message = "List " + Err.wrap(value) + " does not match any of the values in the enumeration facet " + Err.wrap(f.getValue());
                                if (f.getMessage() != null) {
                                    message = message + ". " + f.getMessage();
                                }
                                result = new ValidationFailure(message);
                            }
                            break block16;
                        }
                        catch (XPathException e) {
                            result = new ValidationFailure("List " + Err.wrap(value) + " cannot be compared against the enumeration facet " + Err.wrap(f.getValue()) + ": " + e.getMessage());
                        }
                        break;
                    }
                    if (f instanceof AssertionFacet) {
                        try {
                            SequenceIterator tvi = ((SimpleType)this.getBaseType()).getTypedValue(value, nsResolver, rules);
                            typedValue = (Value)SequenceExtent.makeSequenceExtent(tvi);
                            match = f.testListValue(typedValue);
                            if (!match) {
                                String message = f.getMessage();
                                if (message == null) {
                                    message = "List " + Err.wrap(value) + " does not satisfy the assertion " + Err.wrap(f.getValue());
                                }
                                result = new ValidationFailure(message);
                            }
                            break block16;
                        }
                        catch (XPathException e) {
                            result = new ValidationFailure("List " + Err.wrap(value) + " cannot be compared against the assertion facet " + Err.wrap(f.getValue()) + ": " + e.getMessage());
                        }
                        break;
                    }
                }
            }
            if (f.testLength(count)) continue;
            result = new ValidationFailure("Length of list " + Err.wrap(count + "") + " contravenes " + f.getName() + " facet " + Err.wrap(f.getValue()));
            break;
        }
        return result;
    }

    @Override
    public SequenceIterator getTypedValue(CharSequence value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        StringTokenIterator iter = new StringTokenIterator(((Object)value).toString());
        UserListMappingFunction map = new UserListMappingFunction();
        map.resolver = resolver;
        map.itemType = this.getItemType();
        map.rules = rules;
        return new MappingIterator(iter, map);
    }

    @Override
    public boolean isNamespaceSensitive() {
        return this.getItemType().isNamespaceSensitive();
    }

    @Override
    public void serializeVariety(SchemaModelSerializer serializer) throws XPathException {
        serializer.emitAttribute("variety", "list");
        serializer.emitAttribute("itemType", serializer.getTypeLink(this.getItemType()));
    }

    private static class UserListMappingFunction
    implements MappingFunction {
        public NamespaceResolver resolver;
        public SimpleType itemType;
        public ConversionRules rules;

        private UserListMappingFunction() {
        }

        public SequenceIterator map(Item item) throws XPathException {
            try {
                return this.itemType.getTypedValue(item.getStringValueCS(), this.resolver, this.rules);
            }
            catch (ValidationException err) {
                throw new XPathException(err);
            }
        }
    }
}

