/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserSchemaComponent;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UnresolvedReferenceException;

public abstract class UserDefinedType
extends SchemaStructure
implements Serializable,
UserSchemaComponent,
SchemaType {
    protected int finalProhibitions = 0;
    private TypeReference baseTypeReference;
    private int containingDeclarationName = -1;
    private boolean containingDeclarationIsElement = true;
    private int derivation = 1;
    private int nameCode = -1;
    protected Set extendedTypes;

    public String getName() {
        return this.getConfiguration().getNamePool().getLocalName(this.getNameCode());
    }

    public String getTargetNamespace() {
        return this.getConfiguration().getNamePool().getURI(this.getNameCode());
    }

    public boolean isExternalType() {
        return false;
    }

    public int getFingerprint() {
        if (this.nameCode == -1) {
            return -1;
        }
        return this.nameCode & 0xFFFFF;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public boolean isAnonymousType() {
        return this.nameCode == -1 || this.getNamePool().getURI(this.getFingerprint()).equals("http://ns.saxonica.com/anonymous-type");
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public TypeReference getBaseTypeReference() {
        return this.baseTypeReference;
    }

    public int getBaseTypeFingerprint() {
        if (this.baseTypeReference != null) {
            return this.baseTypeReference.getFingerprint();
        }
        return -1;
    }

    public String getLocalName() {
        return this.getName();
    }

    public String getDisplayName() {
        return this.getConfiguration().getNamePool().getDisplayName(this.nameCode);
    }

    public final boolean isComplexType() {
        return !this.isSimpleType();
    }

    public int getBlock() {
        return 0;
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public SchemaType getBaseType() throws UnresolvedReferenceException {
        if (this.baseTypeReference == null) {
            if (this.isSimpleType()) {
                return AnySimpleType.getInstance();
            }
            return AnyType.getInstance();
        }
        return (SchemaType)this.baseTypeReference.getTarget();
    }

    public void setBaseTypeReference(TypeReference baseType) {
        this.baseTypeReference = baseType;
    }

    public int getDerivationMethod() {
        return this.derivation;
    }

    public boolean allowsDerivation(int derivation) {
        return (this.finalProhibitions & derivation) == 0;
    }

    public void setDerivationMethodName(String method) throws SchemaException {
        if (method.equals("restriction")) {
            this.derivation = 1;
        } else if (method.equals("union")) {
            this.derivation = 4;
        } else if (method.equals("list")) {
            this.derivation = 8;
        } else if (method.equals("extension")) {
            this.derivation = 2;
        } else {
            throw new SchemaException("Unknown derivation method: " + method);
        }
    }

    public void setDerivationMethod(int method) {
        this.derivation = method;
    }

    public void setFinalProhibitions(int finalValue) {
        this.finalProhibitions = finalValue;
    }

    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
        UserComplexType.checkTypeDerivation((ComplexType)((Object)this), type, block);
    }

    public void setContainingDeclaration(int fingerprint, boolean isElement) {
        this.containingDeclarationName = fingerprint;
        this.containingDeclarationIsElement = isElement;
    }

    public String getDescription() {
        int fp = this.getFingerprint();
        NamePool pool = this.getNamePool();
        if (fp != -1 && !"http://ns.saxonica.com/anonymous-type".equals(pool.getURI(fp))) {
            return pool.getDisplayName(fp);
        }
        if (this.containingDeclarationName != -1) {
            return "of " + (this.containingDeclarationIsElement ? "element " : "attribute ") + pool.getDisplayName(this.containingDeclarationName);
        }
        return "defined at line " + this.getLineNumber() + " of " + this.getSystemId();
    }

    public int getContainingDeclarationName() {
        return this.containingDeclarationName;
    }

    public boolean containingDeclarationIsElement() {
        return this.containingDeclarationIsElement;
    }

    public boolean isSameType(SchemaType other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UserDefinedType) {
            UserDefinedType so = (UserDefinedType)other;
            return this.getFingerprint() == so.getFingerprint() && this.getLineNumber() == so.getLineNumber() && this.getColumnNumber() == so.getColumnNumber() && UserDefinedType.isSameURI(this.getSystemId(), so.getSystemId());
        }
        return this.getFingerprint() == other.getFingerprint();
    }

    private static boolean isSameURI(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.equals(s2)) {
            return true;
        }
        if (s1.startsWith("file:///")) {
            s1 = "file:/" + s1.substring(8);
        }
        if (s2.startsWith("file:///")) {
            s2 = "file:/" + s2.substring(8);
        }
        return s1.equals(s2);
    }

    protected void registerExtensionType(UserComplexType derived) {
        if (this.extendedTypes == null) {
            this.extendedTypes = new HashSet(5);
        }
        this.extendedTypes.add(derived);
    }

    public Iterator iterateExtensionTypes() {
        if (this.extendedTypes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.extendedTypes.iterator();
    }

    public boolean hasRegisteredExtension(UserComplexType extension) {
        return this.extendedTypes.contains(extension);
    }

    public void setExtendedTypes(Set types) {
        this.extendedTypes = types;
    }
}

