/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AssertionFacet;
import com.saxonica.schema.EnumerationFacet;
import com.saxonica.schema.EnumerationFacetSet;
import com.saxonica.schema.ExplicitTimezoneFacet;
import com.saxonica.schema.Facet;
import com.saxonica.schema.FractionDigitsFacet;
import com.saxonica.schema.LengthFacet;
import com.saxonica.schema.MaxExclusiveFacet;
import com.saxonica.schema.MaxInclusiveFacet;
import com.saxonica.schema.MaxLengthFacet;
import com.saxonica.schema.MaxScaleFacet;
import com.saxonica.schema.MinExclusiveFacet;
import com.saxonica.schema.MinInclusiveFacet;
import com.saxonica.schema.MinLengthFacet;
import com.saxonica.schema.MinScaleFacet;
import com.saxonica.schema.PatternFacet;
import com.saxonica.schema.PreprocessFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.TotalDigitsFacet;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.WhitespaceFacet;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class UserAtomicType
extends UserSimpleType
implements AtomicType {
    private Boolean namespaceSensitive;
    private static final Set<Class> STRING_FACETS = new HashSet<Class>(16);
    private static final Set<Class> BOOLEAN_FACETS = new HashSet<Class>(16);
    private static final Set<Class> ORDERED_FACETS = new HashSet<Class>(16);
    private static final Set<Class> CALENDAR_FACETS = new HashSet<Class>(16);
    private static final Set<Class> DECIMAL_FACETS = new HashSet<Class>(16);
    private static final Set<Class> PRECISION_DECIMAL_FACETS = new HashSet<Class>(16);

    public UserAtomicType(EnterpriseConfiguration config) {
        this.setConfiguration(config);
    }

    public boolean isAtomicType() {
        return true;
    }

    public boolean isIdType() {
        return this.getBaseType().isIdType();
    }

    public boolean isIdRefType() {
        return this.getBaseType().isIdRefType();
    }

    public boolean isBuiltInType() {
        return false;
    }

    public StructuredQName getTypeName() {
        if (this.isAnonymousType()) {
            return null;
        }
        return new StructuredQName(this.getNamePool(), this.getNameCode());
    }

    public boolean isPrimitiveType() {
        return false;
    }

    public AtomicType getCommonAtomicType() {
        return this;
    }

    public boolean isOrdered() {
        return ((AtomicType)this.getPrimitiveItemType()).isOrdered();
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (!super.validate(compiler)) {
            return false;
        }
        if (this.getBaseType() instanceof SimpleTypeDefinition) {
            UserSimpleType simpleType = ((SimpleTypeDefinition)this.getBaseType()).getSimpleType();
            this.getBaseTypeReference().setTarget(simpleType);
        }
        int prim = this.getPrimitiveType();
        Set<Class> allowed = null;
        switch (prim) {
            case 513: 
            case 527: 
            case 528: 
            case 529: 
            case 530: 
            case 531: {
                allowed = STRING_FACETS;
                break;
            }
            case 514: {
                allowed = BOOLEAN_FACETS;
                break;
            }
            case 516: 
            case 517: 
            case 518: 
            case 633: 
            case 634: {
                allowed = ORDERED_FACETS;
                break;
            }
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                allowed = CALENDAR_FACETS;
                break;
            }
            case 515: 
            case 533: {
                allowed = DECIMAL_FACETS;
                break;
            }
            case 532: {
                allowed = PRECISION_DECIMAL_FACETS;
            }
        }
        Iterator<Facet> fit = this.getFacets();
        while (fit.hasNext()) {
            Facet fac = fit.next();
            if (allowed != null && allowed.contains(fac.getClass())) continue;
            compiler.error("The " + fac.getName() + " facet is not applicable to types derived from " + this.getNamePool().getDisplayName(prim), this);
            return false;
        }
        return true;
    }

    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        if (item instanceof AtomicValue) {
            AtomicValue value = (AtomicValue)item;
            TypeHierarchy th = config.getTypeHierarchy();
            AtomicType type = (AtomicType)value.getItemType(th);
            return type.getFingerprint() == this.getFingerprint() || th.isSubType(type, this);
        }
        return false;
    }

    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, ConversionRules rules) {
        ValidationFailure result = null;
        if (this.isNamespaceSensitive()) {
            if (nsResolver == null) {
                throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
            }
            NameChecker checker = rules.getNameChecker();
            try {
                CharSequence lexicalValue = Whitespace.trimWhitespace(value);
                if (!checker.isQName(((Object)lexicalValue).toString())) {
                    return new ValidationFailure("Invalid lexical QName " + Err.wrap(value));
                }
                String[] parts = checker.getQNameParts(lexicalValue);
                String uri = nsResolver.getURIForPrefix(parts[0], true);
                if (uri == null) {
                    return new ValidationFailure("Namespace prefix " + Err.wrap(parts[0]) + " has not been declared");
                }
                QualifiedNameValue qname = this.getPrimitiveItemType().equals(BuiltInAtomicType.QNAME) ? new QNameValue(parts[0], uri, parts[1], BuiltInAtomicType.QNAME, checker) : new NotationValue(parts[0], uri, parts[1], checker);
                qname.setTypeLabel(this);
                return this.validate(qname, lexicalValue, rules);
            }
            catch (QNameException err) {
                result = new ValidationFailure("Invalid lexical QName " + Err.wrap(value));
            }
            catch (XPathException err) {
                result = new ValidationFailure(err.getMessage());
            }
        } else {
            ConversionResult v = StringValue.convertStringToAtomicType(value, this, rules);
            if (v instanceof ValidationFailure) {
                result = (ValidationFailure)v;
            }
        }
        return result;
    }

    public SequenceIterator getTypedValue(CharSequence value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        NameChecker checker = rules.getNameChecker();
        if (this.isNamespaceSensitive()) {
            try {
                String[] parts = checker.getQNameParts(((Object)value).toString());
                String uri = resolver.getURIForPrefix(parts[0], true);
                if (uri == null) {
                    throw new ValidationException("No namespace binding for prefix in QName value " + Err.wrap(value));
                }
                AtomicValue qname = QualifiedNameValue.makeQName(parts[0], uri, parts[1], this, value, rules);
                return SingletonIterator.makeIterator(qname);
            }
            catch (QNameException err) {
                throw new ValidationException("Malformed QName in content: " + Err.wrap(value));
            }
            catch (XPathException err) {
                throw new ValidationException("Malformed QName in content: " + Err.wrap(value));
            }
        }
        AtomicValue result = StringValue.convertStringToAtomicType(value, this, rules).asAtomic();
        return SingletonIterator.makeIterator(result);
    }

    public ItemType getSuperType(TypeHierarchy th) {
        try {
            SchemaType base = this.getBaseType();
            return (ItemType)((Object)base);
        }
        catch (ClassCastException err) {
            this.getConfiguration().getStandardErrorOutput().println("Internal failure on type " + this.getDescription());
            throw err;
        }
    }

    public ItemType getPrimitiveItemType() {
        try {
            ItemType s = (ItemType)((Object)this.getBaseType());
            if (s.isAtomicType()) {
                return s.getPrimitiveItemType();
            }
            return this;
        }
        catch (ClassCastException err) {
            if (Type.isPrimitiveType(this.getFingerprint())) {
                return this;
            }
            this.getConfiguration().getStandardErrorOutput().println("Internal failure on type " + this.getDescription());
            throw err;
        }
    }

    public int getPrimitiveType() {
        SchemaType s = this.getBaseType();
        if (s.isAtomicType()) {
            return ((AtomicType)s).getPrimitiveType();
        }
        return this.getFingerprint();
    }

    public boolean isNamespaceSensitive() {
        if (this.namespaceSensitive == null) {
            SimpleType base = this;
            int fp = base.getFingerprint();
            while (fp > 1023) {
                SchemaType b = base.getBaseType();
                base = b instanceof ComplexType ? ((ComplexType)b).getSimpleContentType() : (SimpleType)b;
                fp = base.getFingerprint();
            }
            this.namespaceSensitive = fp == 530 || fp == 531;
        }
        return this.namespaceSensitive;
    }

    public AtomicType getAtomizedItemType() {
        return this;
    }

    public boolean isAtomizable() {
        return true;
    }

    public String getSharedInstance(String value) {
        EnumerationFacetSet facet = (EnumerationFacetSet)this.getFacet(EnumerationFacet.class);
        if (facet == null) {
            return value;
        }
        return facet.getSharedInstance(value);
    }

    public String toString() {
        return this.getNamePool().getDisplayName(this.getFingerprint());
    }

    public String toString(NamePool pool) {
        return this.toString();
    }

    public int hashCode() {
        return this.getFingerprint();
    }

    public ValidationFailure validate(AtomicValue primValue, CharSequence lexicalValue, ConversionRules rules) {
        ValidationFailure vf;
        BuiltInAtomicType base = (BuiltInAtomicType)this.getBuiltInBaseType();
        if (!base.isPrimitiveType() && (vf = base.validateContent(lexicalValue, null, rules)) != null) {
            return vf;
        }
        return this.checkAgainstFacets(primValue, lexicalValue, this.getFacets());
    }

    public void serializeVariety(SchemaModelSerializer serializer) throws XPathException {
        serializer.emitAttribute("variety", "atomic");
        serializer.emitAttribute("primitiveType", "#" + ((AtomicType)this.getPrimitiveItemType()).getName());
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        visitor.visitSchemaComponent(this);
    }

    static {
        STRING_FACETS.add(LengthFacet.class);
        STRING_FACETS.add(MinLengthFacet.class);
        STRING_FACETS.add(MaxLengthFacet.class);
        STRING_FACETS.add(PatternFacet.class);
        STRING_FACETS.add(EnumerationFacet.class);
        STRING_FACETS.add(EnumerationFacetSet.class);
        STRING_FACETS.add(WhitespaceFacet.class);
        STRING_FACETS.add(AssertionFacet.class);
        STRING_FACETS.add(PreprocessFacet.class);
        BOOLEAN_FACETS.add(PatternFacet.class);
        BOOLEAN_FACETS.add(WhitespaceFacet.class);
        BOOLEAN_FACETS.add(AssertionFacet.class);
        BOOLEAN_FACETS.add(PreprocessFacet.class);
        ORDERED_FACETS.add(PatternFacet.class);
        ORDERED_FACETS.add(EnumerationFacet.class);
        ORDERED_FACETS.add(EnumerationFacetSet.class);
        ORDERED_FACETS.add(WhitespaceFacet.class);
        ORDERED_FACETS.add(MinInclusiveFacet.class);
        ORDERED_FACETS.add(MaxInclusiveFacet.class);
        ORDERED_FACETS.add(MinExclusiveFacet.class);
        ORDERED_FACETS.add(MaxExclusiveFacet.class);
        ORDERED_FACETS.add(AssertionFacet.class);
        ORDERED_FACETS.add(PreprocessFacet.class);
        CALENDAR_FACETS.add(PatternFacet.class);
        CALENDAR_FACETS.add(EnumerationFacet.class);
        CALENDAR_FACETS.add(EnumerationFacetSet.class);
        CALENDAR_FACETS.add(WhitespaceFacet.class);
        CALENDAR_FACETS.add(MinInclusiveFacet.class);
        CALENDAR_FACETS.add(MaxInclusiveFacet.class);
        CALENDAR_FACETS.add(MinExclusiveFacet.class);
        CALENDAR_FACETS.add(MaxExclusiveFacet.class);
        CALENDAR_FACETS.add(ExplicitTimezoneFacet.class);
        CALENDAR_FACETS.add(AssertionFacet.class);
        CALENDAR_FACETS.add(PreprocessFacet.class);
        DECIMAL_FACETS.add(TotalDigitsFacet.class);
        DECIMAL_FACETS.add(FractionDigitsFacet.class);
        DECIMAL_FACETS.add(PatternFacet.class);
        DECIMAL_FACETS.add(EnumerationFacet.class);
        DECIMAL_FACETS.add(EnumerationFacetSet.class);
        DECIMAL_FACETS.add(WhitespaceFacet.class);
        DECIMAL_FACETS.add(MinInclusiveFacet.class);
        DECIMAL_FACETS.add(MaxInclusiveFacet.class);
        DECIMAL_FACETS.add(MinExclusiveFacet.class);
        DECIMAL_FACETS.add(MaxExclusiveFacet.class);
        DECIMAL_FACETS.add(AssertionFacet.class);
        DECIMAL_FACETS.add(PreprocessFacet.class);
        PRECISION_DECIMAL_FACETS.add(TotalDigitsFacet.class);
        PRECISION_DECIMAL_FACETS.add(PatternFacet.class);
        PRECISION_DECIMAL_FACETS.add(EnumerationFacet.class);
        PRECISION_DECIMAL_FACETS.add(EnumerationFacetSet.class);
        PRECISION_DECIMAL_FACETS.add(WhitespaceFacet.class);
        PRECISION_DECIMAL_FACETS.add(MinInclusiveFacet.class);
        PRECISION_DECIMAL_FACETS.add(MaxInclusiveFacet.class);
        PRECISION_DECIMAL_FACETS.add(MinExclusiveFacet.class);
        PRECISION_DECIMAL_FACETS.add(MaxExclusiveFacet.class);
        PRECISION_DECIMAL_FACETS.add(MinScaleFacet.class);
        PRECISION_DECIMAL_FACETS.add(MaxScaleFacet.class);
        PRECISION_DECIMAL_FACETS.add(AssertionFacet.class);
        PRECISION_DECIMAL_FACETS.add(PreprocessFacet.class);
    }
}

