/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.ComponentReference;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.UnresolvedReferenceExceptionImpl;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UnresolvedReferenceException;

public class TypeReference
extends SchemaStructure
implements ComponentReference {
    private int fingerprint;
    private SchemaType target;

    public TypeReference(int fingerprint, EnterpriseConfiguration config, SourceLocator locator) {
        this.fingerprint = fingerprint;
        if (locator != null) {
            this.setLocator(locator);
        }
        if (fingerprint < 1024 && (fingerprint != 532 || config.getXsdVersion() != 10)) {
            this.setTarget(BuiltInType.getSchemaType(fingerprint));
        }
        this.setConfiguration(config);
    }

    public boolean isResolved() {
        return this.target != null;
    }

    public void setTarget(SchemaType target) {
        this.target = target;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getSymbolSpace() {
        return 803;
    }

    public SchemaComponent getTarget() throws UnresolvedReferenceException {
        if (this.target == null) {
            throw new UnresolvedReferenceExceptionImpl(this);
        }
        return this.target;
    }

    public void tryToResolve(SchemaCompiler compiler) {
        if (this.target == null) {
            this.target = compiler.getPreparedSchema().getType(this.getFingerprint());
        }
        if (this.target == null) {
            this.target = this.getConfiguration().getSuperSchema().getType(this.getFingerprint());
        }
    }
}

