/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserSchemaComponent;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;

public class TypeAlternative
extends SchemaStructure {
    private XPathExpression condition;
    private String conditionText;
    private NamespaceResolver namespaceContext;
    private String baseURI;
    private String defaultNamespace;
    private TypeReference typeReference;

    public TypeAlternative(EnterpriseConfiguration config, XPathExpression condition, String text) {
        this.setConfiguration(config);
        this.condition = condition;
        this.conditionText = text;
    }

    public XPathExpression getCondition() {
        return this.condition;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public void setDefaultElementNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    public String getDefaultElementNamespace() {
        return this.defaultNamespace;
    }

    public void setNamespaceContext(NamespaceResolver resolver) {
        this.namespaceContext = resolver;
    }

    public NamespaceResolver getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setTypeReference(TypeReference type) {
        this.typeReference = type;
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public SchemaType getSchemaType() {
        return (SchemaType)this.typeReference.getTarget();
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        SchemaType type = (SchemaType)PreparedSchema.validateReference(this.typeReference, compiler);
        if (type == null) {
            this.setFixupStatus(4);
            return false;
        }
        return !(type instanceof UserSchemaComponent) || ((UserSchemaComponent)((Object)type)).fixup(compiler);
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("alternativeType");
        serializer.emitNamespaceContext(this.getNamespaceContext());
        serializer.emitAttribute("test", this.conditionText == null ? "true()" : this.conditionText);
        serializer.emitAttribute("type", serializer.getTypeLink((SchemaType)this.typeReference.getTarget()));
        serializer.emitAttribute("defaultNamespace", this.getDefaultElementNamespace());
        serializer.emitAttribute("xml:base", this.getBaseURI());
        serializer.endElement();
    }
}

