/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.DigitsFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class TotalDigitsFacet
extends DigitsFacet {
    public String getName() {
        return "totalDigits";
    }

    public void setValue(String value) throws SchemaException {
        int val;
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException err) {
            throw new SchemaException("Value of " + this.getName() + " facet must be an integer");
        }
        if (val <= 0) {
            throw new SchemaException("Value of totalDigits must be greater than zero");
        }
        this.setNumericValue(val);
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        UserSimpleType ubase;
        DigitsFacet f;
        super.checkFacetRestriction(type, base, compiler);
        if (base instanceof UserSimpleType && (f = (DigitsFacet)(ubase = (UserSimpleType)base).getFacet(TotalDigitsFacet.class)) != null) {
            if (this.getNumericValue() > f.getNumericValue()) {
                throw new SchemaException("The totalDigits facet must not exceed the value on the base type");
            }
            if (f.isFixed() && this.getNumericValue() != f.getNumericValue()) {
                throw new SchemaException("The totalDigits facet is fixed in the base type and cannot be varied");
            }
        }
    }
}

