/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.ComponentReference;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.UnresolvedReferenceExceptionImpl;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.UnresolvedReferenceException;

public class SimpleComponentReference
extends SchemaStructure
implements ComponentReference {
    protected int nameCode = -1;
    protected SchemaComponent target;
    protected int symbolSpace;

    protected SimpleComponentReference() {
    }

    public SimpleComponentReference(int symbolSpace, int fingerprint, EnterpriseConfiguration config) {
        this.symbolSpace = symbolSpace;
        this.nameCode = fingerprint;
        this.setConfiguration(config);
    }

    public boolean isResolved() {
        return this.target != null;
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getSymbolSpace() {
        return this.symbolSpace;
    }

    public SchemaComponent getTarget() throws UnresolvedReferenceException {
        if (this.target == null) {
            throw new UnresolvedReferenceExceptionImpl(this);
        }
        return this.target;
    }

    public void setTarget(SchemaComponent target) {
        this.target = target;
    }

    public void tryToResolve(SchemaCompiler compiler) {
        if (this.target == null) {
            this.tryToResolve(compiler.getPreparedSchema());
        }
        if (this.target == null) {
            this.tryToResolve(compiler.getConfiguration().getSuperSchema());
        }
    }

    private void tryToResolve(PreparedSchema schema) {
        switch (this.symbolSpace) {
            case 801: {
                this.target = schema.getElementDecl(this.getFingerprint());
                return;
            }
            case 802: {
                this.target = schema.getAttributeDecl(this.getFingerprint());
                return;
            }
        }
        throw new IllegalStateException();
    }
}

