/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeGroupDecl;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ModelGroupDefinition;
import com.saxonica.schema.Notation;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.Value;

public class SchemaModelSerializer {
    private EnterpriseConfiguration config;
    private Receiver receiver;
    private Set pendingComponents = new HashSet(50);
    private Map<SchemaComponent, String> componentToIdMap = new HashMap<SchemaComponent, String>(200);
    private Set serializedComponents = new HashSet(200);
    private int nextComponent = 0;
    private HashMap<String, Integer> elementNameCodes = new HashMap();
    private HashMap<String, Integer> attributeNameCodes = new HashMap();
    private boolean inStartTag = false;

    public SchemaModelSerializer(Configuration config, Receiver out) {
        if (!config.isLicensedFeature(1)) {
            throw new IllegalArgumentException("Configuration must be schema-aware");
        }
        this.config = (EnterpriseConfiguration)config;
        NamespaceReducer reducer = new NamespaceReducer();
        reducer.setUnderlyingReceiver(out);
        reducer.setPipelineConfiguration(out.getPipelineConfiguration());
        this.receiver = reducer;
    }

    public void serialize() throws XPathException {
        SchemaStructure decl;
        this.receiver.open();
        this.receiver.startDocument(0);
        this.startElement("schema");
        this.emitAttribute("generatedAt", DateTimeValue.getCurrentDateTime(null).getStringValue());
        this.emitAttribute("xsdVersion", (String)this.config.getConfigurationProperty("http://saxon.sf.net/feature/xsd-version"));
        PreparedSchema schema = this.config.getSuperSchema();
        Iterator iter = schema.iterateTypes();
        while (iter.hasNext()) {
            SchemaType type = (SchemaType)iter.next();
            if (!(type instanceof SerializableSchemaComponent)) continue;
            this.serializeComponent((SerializableSchemaComponent)((Object)type));
        }
        iter = schema.iterateElementDeclarations();
        while (iter.hasNext()) {
            decl = (ElementDecl)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        iter = schema.iterateAttributeDeclarations();
        while (iter.hasNext()) {
            decl = (AttributeDecl)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        iter = schema.iterateModelGroups();
        while (iter.hasNext()) {
            decl = (ModelGroupDefinition)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        iter = schema.iterateAttributeGroups();
        while (iter.hasNext()) {
            decl = (AttributeGroupDecl)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        iter = schema.iterateNotations();
        while (iter.hasNext()) {
            decl = (Notation)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        while (!this.pendingComponents.isEmpty()) {
            SerializableSchemaComponent component = (SerializableSchemaComponent)this.pendingComponents.iterator().next();
            this.serializeComponent(component);
            this.pendingComponents.remove(component);
        }
        this.receiver.endElement();
        this.receiver.endDocument();
        this.receiver.close();
    }

    public void startElement(String elementName) throws XPathException {
        if (this.inStartTag) {
            this.receiver.startContent();
        }
        this.inStartTag = true;
        Integer nc = this.elementNameCodes.get(elementName);
        if (nc == null) {
            nc = this.config.getNamePool().allocate("scm", "http://ns.saxonica.com/schema-component-model", elementName);
            this.elementNameCodes.put(elementName, nc);
        }
        this.receiver.startElement(nc, 630, 0, 0);
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.receiver.startContent();
            this.inStartTag = false;
        }
        this.receiver.endElement();
    }

    public void emitNamespaceContext(NamespaceResolver resolver) throws XPathException {
        Iterator<String> iter = resolver.iteratePrefixes();
        while (iter.hasNext()) {
            String prefix = iter.next();
            String uri = resolver.getURIForPrefix(prefix, false);
            this.declareNamespace(prefix, uri);
        }
    }

    public void declareNamespace(String prefix, String uri) throws XPathException {
        this.receiver.namespace(this.config.getNamePool().allocateNamespaceCode(prefix, uri), 0);
    }

    public void emitAttribute(String attributeName, String value) throws XPathException {
        if (!this.inStartTag) {
            throw new IllegalStateException("Attribute emitted when not in start tag");
        }
        Integer nc = this.attributeNameCodes.get(attributeName);
        if (nc == null) {
            nc = attributeName.equals("xml:base") ? Integer.valueOf(385) : Integer.valueOf(this.config.getNamePool().allocate("", "", attributeName));
            this.attributeNameCodes.put(attributeName, nc);
        }
        this.receiver.attribute(nc, 631, value, 0, 0);
    }

    public void setIsSerialized(SchemaComponent component) {
        this.serializedComponents.add(component);
    }

    public String getId(SchemaComponent component, boolean forSelf) {
        if (component instanceof SimpleTypeDefinition) {
            throw new IllegalStateException("Unresolved SimpleTypeDefinition found");
        }
        if (component instanceof AttributeUse) {
            throw new IllegalStateException("AttributeUse has no ID");
        }
        if (component instanceof SerializableSchemaComponent) {
            String existing = this.componentToIdMap.get(component);
            if (existing != null) {
                return existing;
            }
            String id = "C" + this.nextComponent++;
            this.componentToIdMap.put(component, id);
            if (!forSelf) {
                this.pendingComponents.add(component);
            }
            return id;
        }
        throw new UnsupportedOperationException(component.getClass().getName());
    }

    private void serializeComponent(SerializableSchemaComponent component) throws XPathException {
        if (!this.serializedComponents.contains(component)) {
            component.serialize(this);
            this.serializedComponents.add(component);
        }
    }

    public void emitTypedValue(Value value) throws XPathException {
        AtomicValue atom;
        SequenceIterator iter = value.iterate();
        while ((atom = (AtomicValue)iter.next()) != null) {
            this.startElement("item");
            BuiltInAtomicType type = atom.getPrimitiveType();
            this.emitAttribute("type", "#" + type.getName());
            this.emitAttribute("value", atom.getStringValue());
            if (atom instanceof QualifiedNameValue) {
                this.emitAttribute("namespace", ((QualifiedNameValue)atom).getNamespaceURI());
            }
            this.endElement();
        }
    }

    public String getTypeLink(SchemaType type) {
        if (type instanceof UserSimpleType || type instanceof UserComplexType) {
            return this.getId(type, false);
        }
        return "#" + type.getName();
    }
}

