/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AllModelGroup;
import com.saxonica.schema.Assertion;
import com.saxonica.schema.AssertionFacet;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeGroupDecl;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.AttributeWildcard;
import com.saxonica.schema.ChoiceModelGroup;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ElementParticle;
import com.saxonica.schema.ElementWildcard;
import com.saxonica.schema.Facet;
import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.IdentityConstraintReference;
import com.saxonica.schema.IdentityField;
import com.saxonica.schema.IdentitySelector;
import com.saxonica.schema.Key;
import com.saxonica.schema.KeyRef;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.ModelGroupDefinition;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.Notation;
import com.saxonica.schema.Particle;
import com.saxonica.schema.PatternFacet;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.PreprocessFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SequenceModelGroup;
import com.saxonica.schema.Term;
import com.saxonica.schema.TypeAlternative;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.Unique;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserListType;
import com.saxonica.schema.UserSchemaComponent;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.UserUnionType;
import com.saxonica.schema.Wildcard;
import com.saxonica.schema.fsa.DeterminizedState;
import com.saxonica.schema.fsa.Edge;
import com.saxonica.schema.fsa.FiniteStateMachine;
import com.saxonica.schema.sdoc.SelectionParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class SchemaModelLoader
extends Sink {
    EnterpriseConfiguration config;
    PreparedSchema schema;
    HashMap components = new HashMap(100);
    HashSet anonComponents = new HashSet(100);
    List fixups = new ArrayList();
    Stack<SCMNodeHandler> handlerStack = new Stack();
    NamespaceResolver namespaceResolver;
    int elementNameCode;
    AttributeCollectionImpl attributes;
    List<PendingEdge> pendingEdges = new ArrayList<PendingEdge>();
    private static final int FIXUP_ELEMENT_TYPE = 1;
    private static final int FIXUP_ELEMENT_SUBSTITUTION_GROUP = 2;
    private static final int FIXUP_ATTRIBUTE_TYPE = 11;
    private static final int FIXUP_ALTERNATIVE_TYPE = 12;
    private static final int FIXUP_COMPLEX_TYPE_BASE_TYPE = 21;
    private static final int FIXUP_COMPLEX_TYPE_SIMPLE_TYPE = 22;
    private static final int FIXUP_COMPLEX_TYPE_OPEN_CONTENT_SUFFIX = 23;
    private static final int FIXUP_COMPLEX_TYPE_OPEN_CONTENT_INTERLEAVE = 24;
    private static final int FIXUP_SIMPLE_TYPE_ITEM_TYPE = 31;
    private static final int FIXUP_SIMPLE_TYPE_MEMBER_TYPE = 32;
    private static final int FIXUP_SIMPLE_TYPE_BASE_TYPE = 33;
    private static final int FIXUP_ATTRIBUTE_USE_DECLARATION = 41;
    private static final int FIXUP_ATTRIBUTE_WILDCARD_REF = 42;
    private static final int FIXUP_ELEMENT_PARTICLE_REF = 51;
    private static final int FIXUP_ELEMENT_WILDCARD_REF = 52;
    private static final int FIXUP_MODEL_GROUP_PARTICLE_REF = 61;
    private static final int FIXUP_KEYREF_KEY = 62;
    private static final int FIXUP_IDENTITY_CONSTRAINT_REF = 63;

    public SchemaModelLoader(Configuration config) {
        if (!config.isLicensedFeature(1)) {
            throw new IllegalArgumentException("Configuration is not schema-aware");
        }
        this.config = (EnterpriseConfiguration)config;
        this.schema = new PreparedSchema((EnterpriseConfiguration)config);
        this.attributes = new AttributeCollectionImpl(config);
    }

    public PreparedSchema load(Source source) throws XPathException {
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.getParseOptions().setSchemaValidationMode(4);
        NamespaceReducer reducer = new NamespaceReducer();
        reducer.setPipelineConfiguration(pipe);
        reducer.setUnderlyingReceiver(this);
        this.namespaceResolver = reducer;
        Sender.send(source, reducer, null);
        SchemaCompiler compiler = this.config.newSchemaCompiler();
        try {
            for (Fixup fixup : this.fixups) {
                fixup.apply();
            }
            for (PendingEdge pe : this.pendingEdges) {
                Edge edge;
                Term term;
                DeterminizedState start = (DeterminizedState)pe.machine.getState(pe.fromState);
                DeterminizedState end = (DeterminizedState)pe.machine.getState(pe.toState);
                if (pe.termId.equals("##afterMax")) {
                    term = Edge.MaxOccursTerm.getInstance();
                    edge = new Edge();
                    edge.setTerm(term);
                    edge.setTargetState(end);
                    start.setMaxTransition(edge);
                    continue;
                }
                term = (Term)this.components.get(pe.termId);
                if (term == null) {
                    throw new SchemaException("Unresolved reference to term " + pe.termId);
                }
                edge = new Edge();
                edge.setTargetState(end);
                edge.setTerm(term);
                if (term instanceof ElementDecl) {
                    start.addSpecificTransition(edge, compiler);
                    continue;
                }
                start.addWildcardTransition(compiler, edge);
            }
            compiler.setPreparedSchema(this.schema);
            for (Object o : this.components.values()) {
                if (!(o instanceof ElementDecl)) continue;
                ((ElementDecl)o).fixupSubstitutionGroup(compiler);
            }
            for (Object o : this.components.values()) {
                if (!(o instanceof UserSchemaComponent)) continue;
                ((UserSchemaComponent)o).elaborate(compiler);
            }
            for (Object o : this.anonComponents) {
                if (!(o instanceof UserSchemaComponent)) continue;
                ((UserSchemaComponent)o).elaborate(compiler);
            }
        }
        catch (SchemaException err) {
            throw new XPathException(err);
        }
        return this.schema;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.elementNameCode = nameCode;
        this.attributes.clear();
        if (this.handlerStack.isEmpty()) {
            this.handlerStack.push(new SchemaHandler());
        } else {
            SCMNodeHandler next;
            try {
                next = this.handlerStack.peek().handleChildElement(this.config.getNamePool().getLocalName(this.elementNameCode));
            }
            catch (SchemaException e) {
                throw new XPathException(e);
            }
            if (next == null) {
                throw new XPathException("No handler defined for element " + this.config.getNamePool().getLocalName(this.elementNameCode) + " in " + this.handlerStack.peek().getClass().getName());
            }
            this.handlerStack.push(next);
        }
    }

    public void startContent() throws XPathException {
        try {
            this.handlerStack.peek().processElementStart(this.config.getNamePool().getLocalName(this.elementNameCode), this.attributes);
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.attributes.addAttribute(nameCode, typeCode, ((Object)value).toString(), locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (!Whitespace.isWhite(chars)) {
            throw new XPathException("Character content not allowed in SCM document");
        }
    }

    public void endElement() throws XPathException {
        SCMNodeHandler handler = this.handlerStack.pop();
        try {
            handler.processElementEnd();
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
    }

    private static boolean toBoolean(String s) {
        if (s == null) {
            return false;
        }
        return (s = s.trim()).equals("1") || s.equals("true");
    }

    public int parseFinalOrBlock(String attrName, String finalValue, int allowed) throws SchemaException {
        if (finalValue == null) {
            return 0;
        }
        if (Whitespace.trim(finalValue).equals("#all")) {
            return allowed;
        }
        int result = 0;
        StringTokenizer tokenizer = new StringTokenizer(finalValue, " \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            int v;
            String token = tokenizer.nextToken();
            if (token.equals("union")) {
                v = 4;
            } else if (token.equals("list")) {
                v = 8;
            } else if (token.equals("restriction")) {
                v = 1;
            } else if (token.equals("extension")) {
                v = 2;
            } else if (token.equals("substitution")) {
                v = 16;
            } else {
                String err = "Invalid " + Err.wrap(attrName, 2) + " value " + Err.wrap(token, 4);
                throw new SchemaException(err);
            }
            if ((v & ~allowed) != 0) {
                String err = "The " + Err.wrap(attrName, 2) + " value " + Err.wrap(token, 4) + " is not allowed here";
                throw new SchemaException(err);
            }
            result |= v;
        }
        return result;
    }

    private TypeReference makeTypeReference(String targetId) {
        if (targetId.startsWith("#")) {
            int fp = this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", targetId.substring(1));
            SchemaType builtInType = this.config.getSchemaType(fp);
            TypeReference ref = new TypeReference(fp, this.config, null);
            ref.setTarget(builtInType);
            return ref;
        }
        SchemaType userType = (SchemaType)this.components.get(targetId);
        int fp = userType.getFingerprint();
        TypeReference ref = new TypeReference(fp, this.config, null);
        ref.setTarget(userType);
        return ref;
    }

    public static void main(String[] args) throws Exception {
        StreamSource ss = new StreamSource(new File(args[0]));
        EnterpriseConfiguration config = new EnterpriseConfiguration();
        SchemaModelLoader loader = new SchemaModelLoader(config);
        PreparedSchema ps = loader.load(ss);
        config.addSchema(ps);
        config.setSchemaValidationMode(1);
        config.buildDocument(new StreamSource(args[1]));
    }

    private class Fixup {
        private Object source;
        private String targetId;
        private int property;

        public Fixup(Object source, String targetId, int property) {
            this.source = source;
            this.targetId = targetId;
            this.property = property;
        }

        public void apply() throws SchemaException {
            switch (this.property) {
                case 1: {
                    ((ElementDecl)this.source).setTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 2: {
                    int fp = ((ElementDecl)SchemaModelLoader.this.components.get(this.targetId)).getFingerprint();
                    ((ElementDecl)this.source).addSubstitutionGroupHead(fp);
                    break;
                }
                case 12: {
                    ((TypeAlternative)this.source).setTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 11: {
                    ((AttributeDecl)this.source).setTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 21: {
                    ((UserComplexType)this.source).setBaseTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 22: {
                    ((UserComplexType)this.source).setSimpleContentTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 23: {
                    Wildcard wildcard = (Wildcard)SchemaModelLoader.this.components.get(this.targetId);
                    ((UserComplexType)this.source).setOpenContentWildcard(wildcard, "suffix", true);
                    FiniteStateMachine fsm = ((UserComplexType)this.source).getFiniteStateMachine();
                    if (fsm == null) break;
                    fsm.setOpenContentWildcard(wildcard, false);
                    break;
                }
                case 24: {
                    Wildcard wildcard = (Wildcard)SchemaModelLoader.this.components.get(this.targetId);
                    ((UserComplexType)this.source).setOpenContentWildcard(wildcard, "interleave", true);
                    FiniteStateMachine fsm = ((UserComplexType)this.source).getFiniteStateMachine();
                    if (fsm == null) break;
                    fsm.setOpenContentWildcard(wildcard, true);
                    break;
                }
                case 31: {
                    ((UserListType)this.source).setItemTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 32: {
                    ((UserUnionType)this.source).addMemberTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 33: {
                    ((UserSimpleType)this.source).setBaseTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 41: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((AttributeUse)this.source).setTarget(target);
                    ((AttributeUse)this.source).setNameCode(((AttributeDecl)target).getNameCode());
                    break;
                }
                case 42: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((AttributeWildcard)this.source).setWildcard((Wildcard)target);
                    break;
                }
                case 51: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((ElementParticle)this.source).setTarget(target);
                    ((ElementParticle)this.source).setNameCode(((ElementDecl)target).getNameCode());
                    break;
                }
                case 52: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((ElementWildcard)this.source).setWildcard((Wildcard)target);
                    break;
                }
                case 61: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((ModelGroupParticle)this.source).setTarget(target);
                    ((ModelGroupParticle)this.source).setNameCode(((ModelGroupDefinition)target).getNameCode());
                    break;
                }
                case 62: {
                    IdentityConstraint target = (IdentityConstraint)SchemaModelLoader.this.components.get(this.targetId);
                    ((KeyRef)this.source).setTargetKey(target);
                    ((KeyRef)this.source).setReferFingerprint(target.getFingerprint());
                    break;
                }
                case 63: {
                    IdentityConstraint target = (IdentityConstraint)SchemaModelLoader.this.components.get(this.targetId);
                    ((IdentityConstraintReference)this.source).setTarget(target);
                    break;
                }
            }
        }
    }

    private static class PendingEdge {
        public FiniteStateMachine machine;
        public int fromState;
        public int toState;
        public String termId;

        private PendingEdge() {
        }
    }

    private class FiniteStateMachineEdgeHandler
    implements SCMNodeHandler {
        private FiniteStateMachineHandler fsm;
        private DeterminizedState state;

        public FiniteStateMachineEdgeHandler(FiniteStateMachineHandler fsm, DeterminizedState state) {
            this.fsm = fsm;
            this.state = state;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String term = attributes.getValue("", "term");
            int targetState = Integer.parseInt(attributes.getValue("", "to"));
            PendingEdge pe = new PendingEdge();
            pe.machine = this.fsm.getFiniteStateMachine();
            pe.fromState = this.state.getStateNumber();
            pe.toState = targetState;
            pe.termId = term;
            SchemaModelLoader.this.pendingEdges.add(pe);
        }

        public void processElementEnd() {
        }
    }

    private class FiniteStateMachineStateHandler
    implements SCMNodeHandler {
        private FiniteStateMachineHandler fsmHandler;
        private DeterminizedState state;

        public FiniteStateMachineStateHandler(FiniteStateMachineHandler fsmHandler) {
            this.fsmHandler = fsmHandler;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("edge")) {
                return new FiniteStateMachineEdgeHandler(this.fsmHandler, this.state);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String afterMax;
            String stateNumber = attributes.getValue("", "nr");
            FiniteStateMachine fsm = this.fsmHandler.getFiniteStateMachine();
            this.state = stateNumber.equals("0") ? (DeterminizedState)fsm.getInitialState() : new DeterminizedState(fsm);
            String isFinal = attributes.getValue("", "final");
            this.state.setFinalState(isFinal != null && SchemaModelLoader.toBoolean(isFinal));
            String min = attributes.getValue("", "minOccurs");
            String max = attributes.getValue("", "maxOccurs");
            if (min != null && max != null) {
                this.state.setLimits(Integer.parseInt(min), max.equals("unbounded") ? -1 : Integer.parseInt(max));
            }
            if ((afterMax = attributes.getValue("", "afterMax")) != null) {
                PendingEdge leavingEdge = new PendingEdge();
                leavingEdge.machine = fsm;
                leavingEdge.termId = "##afterMax";
                leavingEdge.fromState = Integer.parseInt(stateNumber);
                leavingEdge.toState = Integer.parseInt(afterMax);
                SchemaModelLoader.this.pendingEdges.add(leavingEdge);
            }
        }

        public void processElementEnd() {
        }
    }

    private class FiniteStateMachineHandler
    implements SCMNodeHandler {
        private FiniteStateMachine fsm;

        public FiniteStateMachineHandler(UserComplexType complexType) {
            this.fsm = new FiniteStateMachine(complexType, true);
            complexType.setFiniteStateMachine(this.fsm);
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("state")) {
                return new FiniteStateMachineStateHandler(this);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
        }

        public FiniteStateMachine getFiniteStateMachine() {
            return this.fsm;
        }

        public void processElementEnd() {
        }
    }

    private class WildcardHandler
    implements SCMNodeHandler {
        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String disallowedQNames;
            Wildcard wildcard = new Wildcard();
            wildcard.setConfiguration((EnterpriseConfiguration)SchemaModelLoader.this.getConfiguration());
            String id = attributes.getValue("", "id");
            if (id != null) {
                SchemaModelLoader.this.components.put(id, wildcard);
            }
            String processContents = attributes.getValue("", "processContents");
            wildcard.setProcessContents(processContents);
            String constraint = attributes.getValue("", "constraint");
            if (!constraint.equals("any")) {
                String ns;
                StringTokenizer st;
                String namespaces;
                if (constraint.equals("not")) {
                    namespaces = attributes.getValue("", "namespaces");
                    st = new StringTokenizer(namespaces);
                    while (st.hasMoreTokens()) {
                        ns = st.nextToken();
                        wildcard.addDisallowedNamespace(ns.equals("##local") ? "" : ns);
                    }
                } else if (constraint.equals("enumeration")) {
                    wildcard.setNoNamespacesAllowed();
                    namespaces = attributes.getValue("", "namespaces");
                    st = new StringTokenizer(namespaces);
                    while (st.hasMoreTokens()) {
                        ns = st.nextToken();
                        wildcard.addAllowedNamespace(ns.equals("##local") ? "" : ns);
                    }
                } else {
                    throw new SchemaException("Unknown wildcard constraint " + constraint);
                }
            }
            if ((disallowedQNames = attributes.getValue("", "notQName")) != null) {
                NamePool pool = SchemaModelLoader.this.getNamePool();
                StringTokenizer st = new StringTokenizer(disallowedQNames, " \r\t\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ("##defined".equals(token)) {
                        wildcard.setDisallowDefinedNames(true);
                        continue;
                    }
                    if ("##definedSibling".equals(token)) {
                        wildcard.setDisallowDefinedSiblings(true);
                        continue;
                    }
                    int nc = pool.allocateClarkName(token);
                    wildcard.addDisallowedQName(nc & 0xFFFFF);
                }
            }
        }

        public void processElementEnd() {
        }
    }

    private class ItemHandler
    implements SCMNodeHandler {
        private FixedValueHandler container;

        public ItemHandler(FixedValueHandler container) {
            this.container = container;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            AtomicValue typedValue;
            block7: {
                String type = attributes.getValue("", "type");
                int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", type.substring(1));
                BuiltInAtomicType t = (BuiltInAtomicType)SchemaModelLoader.this.config.getSchemaType(fp);
                String value = attributes.getValue("", "value");
                String namespace = attributes.getValue("", "namespace");
                NameChecker nameChecker = SchemaModelLoader.this.config.getNameChecker();
                try {
                    if (namespace == null) {
                        SequenceIterator iter = t.getTypedValue(value, null, SchemaModelLoader.this.config.getConversionRules());
                        typedValue = (AtomicValue)iter.next();
                        break block7;
                    }
                    String[] parts = nameChecker.getQNameParts(value);
                    if (fp == 530) {
                        typedValue = new QNameValue(parts[0], namespace, parts[1]);
                        break block7;
                    }
                    if (fp == 531) {
                        typedValue = new NotationValue(parts[0], namespace, parts[1]);
                        break block7;
                    }
                    throw new AssertionError((Object)("Unknown namespace-sensitive type " + type));
                }
                catch (ValidationException e) {
                    throw new SchemaException(e);
                }
                catch (QNameException e) {
                    throw new SchemaException(e);
                }
                catch (XPathException e) {
                    throw new SchemaException(e);
                }
            }
            this.container.appendAtomicValue(typedValue);
        }

        public void processElementEnd() {
        }
    }

    private class FixedValueHandler
    implements SCMNodeHandler {
        private SchemaComponent container;
        private List<AtomicValue> atomicValues = new ArrayList<AtomicValue>(4);

        public FixedValueHandler(SchemaComponent container) {
            this.container = container;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("item")) {
                return new ItemHandler(this);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
        }

        public void processElementEnd() {
            Value v = new SequenceExtent(this.atomicValues).reduce();
            if (this.container instanceof ElementDecl) {
                ((ElementDecl)this.container).setFixedValue(v);
            } else if (this.container instanceof AttributeDecl) {
                ((AttributeDecl)this.container).setFixedValue(v);
            } else if (this.container instanceof AttributeUse) {
                ((AttributeUse)this.container).setFixedValue(v);
            }
        }

        public void appendAtomicValue(AtomicValue item) {
            this.atomicValues.add(item);
        }
    }

    private class AttributeWildcardHandler
    implements SCMNodeHandler {
        private SchemaComponent container;

        public AttributeWildcardHandler(SchemaComponent container) {
            this.container = container;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            AttributeWildcard awc = new AttributeWildcard((EnterpriseConfiguration)SchemaModelLoader.this.getConfiguration());
            if (this.container instanceof AttributeGroupDecl) {
                ((AttributeGroupDecl)this.container).setAnyAttribute(awc);
            } else if (this.container instanceof UserComplexType) {
                ((UserComplexType)this.container).setNonInheritedAnyAttribute(awc);
            } else {
                throw new IllegalArgumentException(this.container.getClass().getName());
            }
            String ref = attributes.getValue("", "ref");
            SchemaModelLoader.this.fixups.add(new Fixup(awc, ref, 42));
        }

        public void processElementEnd() {
        }
    }

    private class OpenContentHandler
    implements SCMNodeHandler {
        private UserComplexType container;

        public OpenContentHandler(UserComplexType container) {
            this.container = container;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String mode = attributes.getValue("", "mode");
            String wildcardRef = attributes.getValue("", "wildcard");
            if (mode.equals("suffix")) {
                SchemaModelLoader.this.fixups.add(new Fixup(this.container, wildcardRef, 23));
            } else {
                SchemaModelLoader.this.fixups.add(new Fixup(this.container, wildcardRef, 24));
            }
        }

        public void processElementEnd() {
        }
    }

    private class AssertionHandler
    implements SCMNodeHandler {
        private Object container;

        public AssertionHandler(Object container) {
            this.container = container;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            XPathExpression condition;
            String xpathText = attributes.getValue("", "test");
            String xmlBase = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            String defaultNamespace = attributes.getValue("", "defaultNamespace");
            XPathEvaluator evaluator = new XPathEvaluator(SchemaModelLoader.this.config);
            IndependentContext env = new IndependentContext(SchemaModelLoader.this.config);
            evaluator.setStaticContext(env);
            env.setNamespaceResolver(SchemaModelLoader.this.namespaceResolver);
            env.setBaseURI(xmlBase);
            env.setDefaultElementNamespace(defaultNamespace);
            boolean isSimple = this.container instanceof UserSimpleType || this.container instanceof UserComplexType && ((UserComplexType)this.container).isSimpleContent();
            XPathVariable valueVariable = null;
            if (isSimple || this.container instanceof PreprocessFacet) {
                valueVariable = env.declareVariable("", "value");
            }
            try {
                condition = evaluator.createExpression(xpathText);
            }
            catch (XPathException err) {
                throw new SchemaException(err);
            }
            Assertion assertion = new Assertion(SchemaModelLoader.this.config, condition, valueVariable, xpathText);
            assertion.setStaticContext(env);
            if (this.container instanceof UserComplexType) {
                ((UserComplexType)this.container).addAssertion(assertion);
            } else if (this.container instanceof UserSimpleType) {
                UserSimpleType ust = (UserSimpleType)this.container;
                AssertionFacet facet = new AssertionFacet(assertion);
                ust.addFacet(facet);
            } else if (this.container instanceof PreprocessFacet) {
                PreprocessFacet ppf = (PreprocessFacet)this.container;
                if (ppf.getAction() == null) {
                    ppf.setAction(assertion);
                } else {
                    ppf.setReverseAction(assertion);
                }
            }
        }

        public void processElementEnd() {
        }
    }

    private class ModelGroupHandler
    implements SCMNodeHandler {
        private ModelGroupParticle referrer;
        protected ModelGroup group;

        public ModelGroupHandler() {
            this.referrer = null;
        }

        public ModelGroupHandler(ModelGroupParticle referrer) {
            this.referrer = referrer;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("elementParticle")) {
                return new ParticleHandler(this.group);
            }
            if (localName.equals("elementWildcard")) {
                return new ParticleHandler(this.group);
            }
            if (localName.equals("modelGroupParticle")) {
                return new ParticleHandler(this.group);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            if (localName.equals("sequence")) {
                this.group = new SequenceModelGroup();
            } else if (localName.equals("choice")) {
                this.group = new ChoiceModelGroup();
            } else if (localName.equals("all")) {
                this.group = new AllModelGroup();
            } else {
                throw new SchemaException("Unknown kind of model group " + localName);
            }
            if (this.referrer != null) {
                this.referrer.setTarget(this.group);
            }
            SchemaModelLoader.this.anonComponents.add(this.group);
        }

        public void processElementEnd() {
        }
    }

    private class ParticleHandler
    implements SCMNodeHandler {
        private SchemaComponent container;
        private Particle particle;

        public ParticleHandler(SchemaComponent container) {
            this.container = container;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("sequence")) {
                return new ModelGroupHandler((ModelGroupParticle)this.particle);
            }
            if (localName.equals("choice")) {
                return new ModelGroupHandler((ModelGroupParticle)this.particle);
            }
            if (localName.equals("all")) {
                return new ModelGroupHandler((ModelGroupParticle)this.particle);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            if (localName.equals("elementParticle")) {
                this.particle = new ElementParticle(SchemaModelLoader.this.config, null);
            } else if (localName.equals("elementWildcard")) {
                this.particle = new ElementWildcard(SchemaModelLoader.this.config);
            } else if (localName.equals("modelGroupParticle")) {
                this.particle = new ModelGroupParticle(SchemaModelLoader.this.config, null);
            } else {
                throw new SchemaException("Unknown kind of particle " + localName);
            }
            String minOccursAtt = attributes.getValue("", "minOccurs");
            int minOccurs = 1;
            if (minOccursAtt != null) {
                minOccurs = Integer.parseInt(minOccursAtt.trim());
            }
            this.particle.setMinOccurs(minOccurs);
            String maxOccursAtt = attributes.getValue("", "maxOccurs");
            int maxOccurs = -1;
            if (maxOccursAtt != null) {
                maxOccurs = (maxOccursAtt = maxOccursAtt.trim()).equals("unbounded") ? -1 : Integer.parseInt(maxOccursAtt);
            }
            this.particle.setMaxOccurs(maxOccurs);
            if (this.particle instanceof ElementParticle) {
                String ref = attributes.getValue("", "ref");
                SchemaModelLoader.this.fixups.add(new Fixup(this.particle, ref, 51));
            } else if (this.particle instanceof ModelGroupParticle) {
                String ref = attributes.getValue("", "ref");
                if (ref != null) {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.particle, ref, 61));
                }
            } else if (this.particle instanceof ElementWildcard) {
                String ref = attributes.getValue("", "ref");
                SchemaModelLoader.this.fixups.add(new Fixup(this.particle, ref, 52));
            } else {
                throw new IllegalStateException("Unknown particle " + this.particle.getClass().getName());
            }
            if (this.container instanceof ModelGroup) {
                ((ModelGroup)this.container).addParticle(this.particle);
            } else if (this.container instanceof UserComplexType) {
                ((UserComplexType)this.container).setParticle(this.particle);
            } else {
                throw new IllegalArgumentException(this.container.getClass().getName());
            }
        }

        public void processElementEnd() {
        }
    }

    private class PreprocessHandler
    implements SCMNodeHandler {
        private UserSimpleType simpleType;
        private PreprocessFacet facet;

        public PreprocessHandler(UserSimpleType simpleType) {
            this.simpleType = simpleType;
            this.facet = new PreprocessFacet();
            simpleType.addFacet(this.facet);
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("assertion")) {
                return new AssertionHandler(this.facet);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String fixed = attributes.getValue("", "fixed");
            if (fixed != null) {
                this.facet.setFixed(SchemaModelLoader.toBoolean(fixed));
            }
        }

        public void processElementEnd() {
        }
    }

    private class FacetHandler
    implements SCMNodeHandler {
        private UserSimpleType simpleType;

        public FacetHandler(UserSimpleType simpleType) {
            this.simpleType = simpleType;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("assertion")) {
                return new AssertionHandler(this.simpleType);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            if (!localName.equals("assert")) {
                String value = attributes.getValue("", "value");
                boolean namespaceSensitive = SchemaModelLoader.toBoolean(attributes.getValue("", "namespaceSensitive"));
                SavedNamespaceContext resolver = null;
                if (namespaceSensitive) {
                    resolver = new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver, SchemaModelLoader.this.config.getNamePool());
                }
                Facet facet = Facet.makeFacet(localName, value, SchemaModelLoader.this.config, resolver);
                String fixed = attributes.getValue("", "fixed");
                if (fixed != null) {
                    facet.setFixed(SchemaModelLoader.toBoolean(fixed));
                }
                if (facet instanceof PatternFacet) {
                    ((PatternFacet)facet).setDoNotMerge(true);
                }
                this.simpleType.addFacet(facet);
            }
        }

        public void processElementEnd() {
        }
    }

    private class AttributeUseHandler
    implements SCMNodeHandler {
        private SchemaComponent container;
        private AttributeUse attributeUse;

        public AttributeUseHandler(SchemaComponent container) {
            this.container = container;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("fixed")) {
                return new FixedValueHandler(this.attributeUse);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            boolean required = SchemaModelLoader.toBoolean(attributes.getValue("", "required"));
            boolean isInheritable = SchemaModelLoader.toBoolean(attributes.getValue("", "inheritable"));
            String ref = attributes.getValue("", "ref");
            String defaultValue = attributes.getValue("", "default");
            this.attributeUse = new AttributeUse(SchemaModelLoader.this.config);
            this.attributeUse.setInheritable(isInheritable ? 1 : 0);
            if (this.container instanceof UserComplexType) {
                ((UserComplexType)this.container).addNonInheritedAttributeUse(this.attributeUse);
            } else {
                ((AttributeGroupDecl)this.container).addAttributeUse(this.attributeUse);
            }
            this.attributeUse.setUse(required ? (short)5 : 3);
            if (defaultValue != null) {
                this.attributeUse.setDefaultValue(defaultValue);
            }
            SchemaModelLoader.this.fixups.add(new Fixup(this.attributeUse, ref, 41));
        }

        public void processElementEnd() {
        }
    }

    private class ModelGroupDefinitionHandler
    extends ModelGroupHandler {
        private ModelGroupDefinitionHandler() {
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            int nameCode = SchemaModelLoader.this.config.getNamePool().allocate("", namespace, name);
            ModelGroupDefinition mgd = new ModelGroupDefinition(SchemaModelLoader.this.config, null);
            mgd.setNameCode(nameCode);
            SchemaModelLoader.this.components.put(id, mgd);
            SchemaModelLoader.this.schema.addGroup(mgd);
            this.group = mgd;
        }

        public void processElementEnd() {
        }
    }

    private class NotationHandler
    implements SCMNodeHandler {
        private NotationHandler() {
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            Notation notation = new Notation(SchemaModelLoader.this.config, null);
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            int nameCode = name == null ? SchemaModelLoader.this.config.getNamePool().allocate("anon", "http://ns.saxonica.com/anonymous-type", id) : SchemaModelLoader.this.config.getNamePool().allocate("", namespace, name);
            notation.setNameCode(nameCode);
            String systemId = attributes.getValue("", "systemId");
            notation.setNotationSystemId(systemId);
            String publicId = attributes.getValue("", "publicId");
            notation.setNotationPublicId(publicId);
            SchemaModelLoader.this.components.put(id, notation);
            SchemaModelLoader.this.schema.addNotation(notation);
        }

        public void processElementEnd() {
        }
    }

    private class AttributeGroupHandler
    implements SCMNodeHandler {
        AttributeGroupDecl group;

        public AttributeGroupHandler() {
            this.group = new AttributeGroupDecl(SchemaModelLoader.this.config);
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("attributeUse")) {
                return new AttributeUseHandler(this.group);
            }
            if (localName.equals("attributeWildcard")) {
                return new AttributeWildcardHandler(this.group);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            int nameCode = -1;
            if (name != null) {
                nameCode = SchemaModelLoader.this.config.getNamePool().allocate("", namespace, name);
            }
            SchemaModelLoader.this.components.put(id, this.group);
            this.group.setNameCode(nameCode);
            SchemaModelLoader.this.schema.addAttributeGroup(this.group);
        }

        public void processElementEnd() {
        }
    }

    private class SimpleTypeHandler
    implements SCMNodeHandler {
        private UserSimpleType simpleType;

        private SimpleTypeHandler() {
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (Facet.isFacetName(localName, SchemaModelLoader.this.getConfiguration().getXsdVersion()) || localName.equals("assert")) {
                return new FacetHandler(this.simpleType);
            }
            if (localName.equals("preprocess")) {
                return new PreprocessHandler(this.simpleType);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            int fp;
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            int nameCode = name == null ? SchemaModelLoader.this.config.getNamePool().allocate("anon", "http://ns.saxonica.com/anonymous-type", id) : SchemaModelLoader.this.config.getNamePool().allocate("", namespace, name);
            String base = attributes.getValue("", "base");
            String variety = attributes.getValue("", "variety");
            String itemType = attributes.getValue("", "itemType");
            String memberTypes = attributes.getValue("", "memberTypes");
            if ("atomic".equals(variety)) {
                this.simpleType = new UserAtomicType(SchemaModelLoader.this.config);
            } else if ("list".equals(variety)) {
                this.simpleType = new UserListType(SchemaModelLoader.this.config);
            } else if ("union".equals(variety)) {
                this.simpleType = new UserUnionType(SchemaModelLoader.this.config);
            } else {
                throw new SchemaException("Unknown simple type variety: " + variety);
            }
            SchemaModelLoader.this.components.put(id, this.simpleType);
            this.simpleType.setNameCode(nameCode);
            if (base != null) {
                if (base.startsWith("#")) {
                    fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", base.substring(1));
                    this.simpleType.setBaseTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.simpleType, base, 33));
                }
            }
            if (itemType != null) {
                if (itemType.startsWith("#")) {
                    fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", itemType.substring(1));
                    ((UserListType)this.simpleType).setItemTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.simpleType, itemType, 31));
                }
            }
            if (memberTypes != null) {
                StringTokenizer st = new StringTokenizer(memberTypes);
                while (st.hasMoreTokens()) {
                    String memberType = st.nextToken();
                    if (memberType.startsWith("#")) {
                        int fp2 = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", memberType.substring(1));
                        ((UserUnionType)this.simpleType).addMemberTypeReference(new TypeReference(fp2, SchemaModelLoader.this.config, null));
                        continue;
                    }
                    SchemaModelLoader.this.fixups.add(new Fixup(this.simpleType, memberType, 32));
                }
            }
            if (name == null) {
                SchemaModelLoader.this.schema.addAnonymousType(this.simpleType);
            } else {
                SchemaModelLoader.this.schema.addType(this.simpleType);
            }
        }

        public void processElementEnd() {
        }
    }

    private class ComplexTypeHandler
    implements SCMNodeHandler {
        UserComplexType complexType;

        private ComplexTypeHandler() {
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("openContent")) {
                return new OpenContentHandler(this.complexType);
            }
            if (localName.equals("attributeUse")) {
                return new AttributeUseHandler(this.complexType);
            }
            if (localName.equals("attributeWildcard")) {
                return new AttributeWildcardHandler(this.complexType);
            }
            if (localName.equals("modelGroup")) {
                return new ParticleHandler(this.complexType);
            }
            if (localName.equals("elementParticle")) {
                return new ParticleHandler(this.complexType);
            }
            if (localName.equals("elementWildcard")) {
                return new ParticleHandler(this.complexType);
            }
            if (localName.equals("modelGroupParticle")) {
                return new ParticleHandler(this.complexType);
            }
            if (localName.equals("finiteStateMachine")) {
                return new FiniteStateMachineHandler(this.complexType);
            }
            if (localName.equals("assertion")) {
                return new AssertionHandler(this.complexType);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            int nameCode = name == null ? SchemaModelLoader.this.config.getNamePool().allocate("anon", "http://ns.saxonica.com/anonymous-type", id) : SchemaModelLoader.this.config.getNamePool().allocate("", namespace, name);
            String base = attributes.getValue("", "base");
            String variety = attributes.getValue("", "variety");
            boolean isAbstract = SchemaModelLoader.toBoolean(attributes.getValue("", "abstract"));
            String derivation = attributes.getValue("", "derivationMethod");
            String simpleType = attributes.getValue("", "simpleType");
            this.complexType = new UserComplexType(SchemaModelLoader.this.config, null);
            this.complexType.setEmptyCombinedAttributeGroup();
            SchemaModelLoader.this.components.put(id, this.complexType);
            this.complexType.setNameCode(nameCode);
            if (base != null) {
                if (base.startsWith("#")) {
                    int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", base.substring(1));
                    this.complexType.setBaseTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.complexType, base, 21));
                }
            }
            int varietyCode = 2;
            if ("mixed".equals(variety)) {
                varietyCode = 3;
            } else if ("empty".equals(variety)) {
                varietyCode = 0;
            } else if ("element-only".equals(variety)) {
                varietyCode = 2;
            } else if ("simple".equals(variety)) {
                varietyCode = 1;
            }
            this.complexType.setVariety(varietyCode);
            this.complexType.setAbstract(isAbstract);
            this.complexType.setDerivationMethodName(derivation);
            if (simpleType != null) {
                if (simpleType.startsWith("#")) {
                    int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", simpleType.substring(1));
                    this.complexType.setSimpleContentTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.complexType, simpleType, 22));
                }
            }
            if (name == null) {
                SchemaModelLoader.this.schema.addAnonymousType(this.complexType);
            } else {
                SchemaModelLoader.this.schema.addType(this.complexType);
            }
            String blockAtt = attributes.getValue("", "block");
            int blockSet = SchemaModelLoader.this.parseFinalOrBlock("block", blockAtt, 3);
            this.complexType.setBlock(blockSet);
            String finalAtt = attributes.getValue("", "final");
            int finalSet = SchemaModelLoader.this.parseFinalOrBlock("final", finalAtt, 3);
            this.complexType.setFinalProhibitions(finalSet);
        }

        public void processElementEnd() {
        }
    }

    private class AttributeHandler
    implements SCMNodeHandler {
        private AttributeDecl attributeDecl;

        private AttributeHandler() {
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("fixed")) {
                return new FixedValueHandler(this.attributeDecl);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            int nameCode = -1;
            if (name != null) {
                nameCode = SchemaModelLoader.this.config.getNamePool().allocate("", namespace, name);
            }
            boolean isGlobal = SchemaModelLoader.toBoolean(attributes.getValue("", "global"));
            boolean isInheritable = SchemaModelLoader.toBoolean(attributes.getValue("", "inheritable"));
            String type = attributes.getValue("", "type");
            String defaultValue = attributes.getValue("", "default");
            this.attributeDecl = new AttributeDecl(SchemaModelLoader.this.config, isGlobal);
            SchemaModelLoader.this.components.put(id, this.attributeDecl);
            this.attributeDecl.setNameCode(nameCode);
            this.attributeDecl.setInheritable(isInheritable);
            if (defaultValue != null) {
                this.attributeDecl.setDefaultValue(defaultValue);
            }
            if (type != null) {
                if (type.startsWith("#")) {
                    int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", type.substring(1));
                    this.attributeDecl.setTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.attributeDecl, type, 11));
                }
            }
            if (isGlobal) {
                SchemaModelLoader.this.schema.addAttributeDecl(this.attributeDecl);
            }
        }

        public void processElementEnd() {
        }
    }

    public class SelectorHandler
    implements SCMNodeHandler {
        private IdentityConstraint identityConstraint;

        public SelectorHandler(IdentityConstraint identityConstraint) {
            this.identityConstraint = identityConstraint;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            Pattern selector;
            String xpath = attributes.getValue("", "xpath");
            boolean isField = localName.equals("field");
            String defaultNamespace = attributes.getValue("", "defaultNamespace");
            IndependentContext env = new IndependentContext(SchemaModelLoader.this.config);
            env.setNamespaceResolver(SchemaModelLoader.this.namespaceResolver);
            env.setDefaultElementNamespace(defaultNamespace);
            try {
                selector = new SelectionParser().parseSelector(xpath, env, isField);
            }
            catch (XPathException err) {
                throw new SchemaException(err);
            }
            if (isField) {
                IdentityField idf = new IdentityField(xpath);
                idf.setSelection(selector);
                idf.setNamespaceContext(new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver, SchemaModelLoader.this.config.getNamePool()));
                idf.setXPathDefaultNamespace(defaultNamespace);
                this.identityConstraint.addField(idf);
            } else {
                IdentitySelector ids = new IdentitySelector(xpath);
                ids.setSelection(selector);
                ids.setNamespaceContext(new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver, SchemaModelLoader.this.config.getNamePool()));
                ids.setXPathDefaultNamespace(defaultNamespace);
                this.identityConstraint.setSelector(ids);
            }
        }

        public void processElementEnd() {
        }
    }

    public class IdentityConstraintHandler
    implements SCMNodeHandler {
        private IdentityConstraint identityConstraint;

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("selector")) {
                return new SelectorHandler(this.identityConstraint);
            }
            if (localName.equals("field")) {
                return new SelectorHandler(this.identityConstraint);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            IdentityConstraint ic;
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            String key = attributes.getValue("", "key");
            int nameCode = SchemaModelLoader.this.config.getNamePool().allocate("", namespace, name);
            if (localName.equals("unique")) {
                ic = new Unique();
                SchemaModelLoader.this.components.put(id, ic);
            } else if (localName.equals("key")) {
                ic = new Key();
                SchemaModelLoader.this.components.put(id, ic);
            } else if (localName.equals("keyref")) {
                ic = new KeyRef();
                SchemaModelLoader.this.components.put(id, ic);
                SchemaModelLoader.this.fixups.add(new Fixup(ic, key, 62));
            } else {
                throw new AssertionError((Object)("unknown IdentityConstraint " + localName));
            }
            ic.setConfiguration(SchemaModelLoader.this.config);
            ic.setNameCode(nameCode);
            this.identityConstraint = ic;
        }

        public void processElementEnd() {
        }
    }

    private class IdentityConstraintReferenceHandler
    implements SCMNodeHandler {
        private ElementDecl container;
        private IdentityConstraintReference constraintRef;

        public IdentityConstraintReferenceHandler(ElementDecl container) {
            this.container = container;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String ref = attributes.getValue("", "ref");
            this.constraintRef = new IdentityConstraintReference();
            this.container.addIdentityConstraint(this.constraintRef);
            SchemaModelLoader.this.fixups.add(new Fixup(this.constraintRef, ref, 63));
        }

        public void processElementEnd() {
        }
    }

    public class AlternativeTypeHandler
    implements SCMNodeHandler {
        private ElementDecl elementDecl;

        public AlternativeTypeHandler(ElementDecl decl) {
            this.elementDecl = decl;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            XPathExpression condition;
            String xpathText = attributes.getValue("", "test");
            String xmlBase = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            String defaultNamespace = attributes.getValue("", "defaultNamespace");
            String type = attributes.getValue("", "type");
            XPathEvaluator evaluator = new XPathEvaluator(SchemaModelLoader.this.config);
            IndependentContext env = new IndependentContext(SchemaModelLoader.this.config);
            evaluator.setStaticContext(env);
            env.setNamespaceResolver(SchemaModelLoader.this.namespaceResolver);
            env.setDefaultElementNamespace(defaultNamespace);
            env.setBaseURI(xmlBase);
            try {
                condition = evaluator.createExpression(xpathText);
            }
            catch (XPathException err) {
                throw new SchemaException(err);
            }
            TypeAlternative alt = new TypeAlternative(SchemaModelLoader.this.config, condition, xpathText);
            alt.setBaseURI(xmlBase);
            alt.setDefaultElementNamespace(defaultNamespace);
            alt.setNamespaceContext(new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver, SchemaModelLoader.this.config.getNamePool()));
            if (type.startsWith("#")) {
                int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", type.substring(1));
                alt.setTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
            } else {
                SchemaModelLoader.this.fixups.add(new Fixup(alt, type, 12));
            }
            this.elementDecl.addTypeAlternative(alt);
        }

        public void processElementEnd() {
        }
    }

    public class SubstitutionGroupAffiliationHandler
    implements SCMNodeHandler {
        private ElementDecl elementDecl;

        public SubstitutionGroupAffiliationHandler(ElementDecl decl) {
            this.elementDecl = decl;
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String head = attributes.getValue("", "ref");
            if (head != null) {
                SchemaModelLoader.this.fixups.add(new Fixup(this.elementDecl, head, 2));
            }
        }

        public void processElementEnd() {
        }
    }

    private class ElementHandler
    implements SCMNodeHandler {
        private ElementDecl elementDecl;

        private ElementHandler() {
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("identityConstraint")) {
                return new IdentityConstraintReferenceHandler(this.elementDecl);
            }
            if (localName.equals("substitutionGroupAffiliation")) {
                return new SubstitutionGroupAffiliationHandler(this.elementDecl);
            }
            if (localName.equals("alternativeType")) {
                return new AlternativeTypeHandler(this.elementDecl);
            }
            if (localName.equals("fixed")) {
                return new FixedValueHandler(this.elementDecl);
            }
            return null;
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            int nameCode = -1;
            if (name != null) {
                nameCode = SchemaModelLoader.this.config.getNamePool().allocate("", namespace, name);
            }
            boolean isGlobal = SchemaModelLoader.toBoolean(attributes.getValue("", "global"));
            boolean isNillable = SchemaModelLoader.toBoolean(attributes.getValue("", "nillable"));
            boolean isAbstract = SchemaModelLoader.toBoolean(attributes.getValue("", "abstract"));
            String type = attributes.getValue("", "type");
            String finalAtt = attributes.getValue("", "final");
            String defaultValue = attributes.getValue("", "default");
            int finalSet = SchemaModelLoader.this.parseFinalOrBlock("final", finalAtt, 19);
            String blockAtt = attributes.getValue("", "block");
            int blockSet = SchemaModelLoader.this.parseFinalOrBlock("block", blockAtt, 19);
            this.elementDecl = new ElementDecl(SchemaModelLoader.this.config, isGlobal, null);
            SchemaModelLoader.this.components.put(id, this.elementDecl);
            this.elementDecl.setNameCode(nameCode);
            this.elementDecl.setAbstract(isAbstract);
            this.elementDecl.setNillable(isNillable);
            this.elementDecl.setBlock(blockSet);
            this.elementDecl.setFinalProhibitions(finalSet);
            this.elementDecl.setDefaultValue(defaultValue);
            if (type != null) {
                if (type.startsWith("#")) {
                    int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", type.substring(1));
                    this.elementDecl.setTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.elementDecl, type, 1));
                }
            }
            if (isGlobal) {
                SchemaModelLoader.this.schema.addElementDecl(this.elementDecl);
            }
        }

        public void processElementEnd() {
        }
    }

    private class SchemaHandler
    implements SCMNodeHandler {
        private SchemaHandler() {
        }

        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String xsdVersion = attributes.getValue("", "xsdVersion");
            if (xsdVersion != null && xsdVersion.compareTo((String)SchemaModelLoader.this.config.getConfigurationProperty("http://saxon.sf.net/feature/xsd-version")) > 0) {
                throw new SchemaException("Imported schema component model requires XSD version " + xsdVersion);
            }
        }

        public SCMNodeHandler handleChildElement(String localName) throws SchemaException {
            if (localName.equals("element")) {
                return new ElementHandler();
            }
            if (localName.equals("attribute")) {
                return new AttributeHandler();
            }
            if (localName.equals("complexType")) {
                return new ComplexTypeHandler();
            }
            if (localName.equals("simpleType")) {
                return new SimpleTypeHandler();
            }
            if (localName.equals("attributeGroup")) {
                return new AttributeGroupHandler();
            }
            if (localName.equals("modelGroupDefinition")) {
                return new ModelGroupDefinitionHandler();
            }
            if (localName.equals("notation")) {
                return new NotationHandler();
            }
            if (localName.equals("wildcard")) {
                return new WildcardHandler();
            }
            if (localName.equals("unique")) {
                return new IdentityConstraintHandler();
            }
            if (localName.equals("key")) {
                return new IdentityConstraintHandler();
            }
            if (localName.equals("keyref")) {
                return new IdentityConstraintHandler();
            }
            return null;
        }

        public void processElementEnd() {
        }
    }

    private static interface SCMNodeHandler {
        public void processElementStart(String var1, AttributeCollection var2) throws SchemaException;

        public SCMNodeHandler handleChildElement(String var1) throws SchemaException;

        public void processElementEnd() throws SchemaException;
    }
}

